/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.phpunit.PhpMethodLocation;
import com.jetbrains.php.phpunit.PhpUnitRuntimeConfigurationProducer;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitTestRunLineMarkerProvider
extends RunLineMarkerContributor {
    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement leaf) {
        PhpMethodLocation dataSet;
        PhpNamedElement element;
        if (leaf == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (PhpPsiUtil.isOfType(leaf, PhpTokenTypes.IDENTIFIER) && (element = (PhpNamedElement)ObjectUtils.tryCast((Object)leaf.getParent(), PhpNamedElement.class)) != null && element.getNameIdentifier() == leaf) {
            PhpClass containingClass;
            if (element instanceof PhpClass && PhpUnitUtil.isRunnableTestClass((PhpClass)element)) {
                return PhpUnitTestRunLineMarkerProvider.getInfo(PhpUnitTestRunLineMarkerProvider.getLocationHint((PhpClass)element), leaf.getProject(), true);
            }
            if (element instanceof Method && PhpUnitUtil.isTestMethod((Method)element) && (containingClass = ((Method)element).getContainingClass()) != null) {
                return PhpUnitTestRunLineMarkerProvider.getInfo(PhpUnitTestRunLineMarkerProvider.getLocationHint(containingClass, (Method)element), leaf.getProject(), false);
            }
        }
        if ((dataSet = PhpUnitRuntimeConfigurationProducer.getDataSetFromDataProvider(leaf)) != null) {
            Method dataProvider = (Method)dataSet.getPsiElement();
            return PhpUnitTestRunLineMarkerProvider.getInfo(PhpUnitTestRunLineMarkerProvider.getLocationHint(dataSet.getContainingClass(), dataProvider, dataSet.getDataSet()), dataProvider.getProject(), false);
        }
        return null;
    }

    @NotNull
    private static RunLineMarkerContributor.Info getInfo(String url, Project project, boolean isClass) {
        return new RunLineMarkerContributor.Info(PhpUnitTestRunLineMarkerProvider.getTestStateIcon((String)url, (Project)project, (boolean)isClass), ExecutorAction.getActions(), RUN_TEST_TOOLTIP_PROVIDER);
    }

    @NotNull
    private static String getLocationHint(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(1);
        }
        String string = PhpUnitTestRunLineMarkerProvider.getLocationHint(phpClass.getContainingFile()) + "::" + phpClass.getFQN();
        if (string == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String getLocationHint(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(3);
        }
        String string = "php_qn://" + PhpUnitTestRunLineMarkerProvider.getFilePathDeploymentAware(psiFile.getContainingFile());
        if (string == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getFilePathDeploymentAware(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(5);
        }
        String localPath = psiFile.getVirtualFile().getPath();
        PhpCommandLinePathProcessor remoteMapper = PhpUnitTestRunLineMarkerProvider.createPathMapper(psiFile.getProject());
        String string = remoteMapper.canProcess(localPath) ? remoteMapper.process(localPath) : localPath;
        if (string == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static PhpCommandLinePathProcessor createPathMapper(@NotNull Project project) {
        PhpCommandLinePathProcessor phpCommandLinePathProcessor;
        PhpInterpreter interpreter;
        if (project == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(7);
        }
        PhpSdkAdditionalData data = (interpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter()) != null && interpreter.isRemote() ? interpreter.getPhpSdkAdditionalData() : null;
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        try {
            phpCommandLinePathProcessor = manager != null && data != null ? manager.createPathMapper(project, data) : PhpCommandLinePathProcessor.LOCAL;
        }
        catch (ExecutionException e) {
            PhpCommandLinePathProcessor phpCommandLinePathProcessor2 = PhpCommandLinePathProcessor.LOCAL;
            if (phpCommandLinePathProcessor2 == null) {
                PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(9);
            }
            return phpCommandLinePathProcessor2;
        }
        if (phpCommandLinePathProcessor == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(8);
        }
        return phpCommandLinePathProcessor;
    }

    @NotNull
    static String getLocationHint(@NotNull PhpClass containingClass, @NotNull Method method) {
        if (containingClass == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(10);
        }
        if (method == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(11);
        }
        String string = PhpUnitTestRunLineMarkerProvider.getLocationHint(containingClass) + "::" + method.getName();
        if (string == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    static String getLocationHint(@NotNull PhpClass containingClass, @NotNull Method method, String datasetName) {
        if (containingClass == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(13);
        }
        if (method == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(14);
        }
        String string = PhpUnitTestRunLineMarkerProvider.getLocationHint(containingClass) + "::" + method.getName() + " with data set " + datasetName;
        if (string == null) {
            PhpUnitTestRunLineMarkerProvider.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 9, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitTestRunLineMarkerProvider";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitTestRunLineMarkerProvider";
                break;
            }
            case 2: 
            case 4: 
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationHint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathDeploymentAware";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLocationHint";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilePathDeploymentAware";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPathMapper";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 8, 9, 12, 15 -> new IllegalStateException(string);
        };
    }
}

