/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpTestFrameworkVersionDetector;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class PhpUnitVersion {
    private static final Logger LOG = Logger.getInstance(PhpUnitVersion.class);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String ALPHA = "alpha";
    private static final String BETA = "beta";
    protected final String myVersion;
    protected final HashMap<String, Pair<String, String>> myOptionToSupportedVersion;

    public PhpUnitVersion(@NotNull String version) {
        if (version == null) {
            PhpUnitVersion.$$$reportNull$$$0(0);
        }
        this.myOptionToSupportedVersion = new HashMap<String, Pair<String, String>>(){
            {
                this.put("--cache-result-file=", new Pair((Object)"7.3.0", (Object)"11.0"));
                this.put("--teamcity", new Pair((Object)"5.0.0", (Object)"*"));
            }
        };
        this.myVersion = version;
    }

    public static PhpUnitVersion create(@NotNull String fullVersion) {
        int separator;
        if (fullVersion == null) {
            PhpUnitVersion.$$$reportNull$$$0(1);
        }
        if ((separator = fullVersion.indexOf("-")) < 0) {
            return new PhpUnitVersion(fullVersion);
        }
        String shortVersion = fullVersion.substring(0, separator);
        if (StringUtil.equals((CharSequence)shortVersion, (CharSequence)ALPHA) || StringUtil.equals((CharSequence)shortVersion, (CharSequence)BETA)) {
            try {
                String date = fullVersion.substring(separator + 1);
                return new PhpUnitUnstableVersion(shortVersion, DATE_FORMAT.parse(date));
            }
            catch (ParseException e) {
                LOG.warn("Fail to parse phpunit build date", (Throwable)e);
            }
        }
        return new PhpUnitFromGitVersion(shortVersion);
    }

    public boolean isAfterPrinterChange() {
        return this.supportsOption("--teamcity");
    }

    public boolean isAfterCacheFileOptionAdded() {
        return this.supportsOption("--cache-result-file=");
    }

    protected boolean supportsOption(String option) {
        if (this.myOptionToSupportedVersion.containsKey(option)) {
            String startVersion = (String)this.myOptionToSupportedVersion.get((Object)option).first;
            String endVersion = (String)this.myOptionToSupportedVersion.get((Object)option).second;
            return PhpTestFrameworkVersionDetector.versionCompare(this.myVersion, startVersion) >= 0 && (endVersion.equals("*") || PhpTestFrameworkVersionDetector.versionCompare(this.myVersion, endVersion) < 0);
        }
        return false;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            PhpUnitVersion.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullVersion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class PhpUnitUnstableVersion
    extends PhpUnitVersion {
        private static final Date PRINTER_ADDED_DATE = new GregorianCalendar(2015, 8, 20).getTime();
        private final Date myDate;

        PhpUnitUnstableVersion(@NotNull String version, @NotNull Date date) {
            if (version == null) {
                PhpUnitUnstableVersion.$$$reportNull$$$0(0);
            }
            if (date == null) {
                PhpUnitUnstableVersion.$$$reportNull$$$0(1);
            }
            super(version);
            this.myDate = date;
        }

        @Override
        public boolean isAfterPrinterChange() {
            return this.myDate.after(PRINTER_ADDED_DATE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "version";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "date";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/phpunit/PhpUnitVersion$PhpUnitUnstableVersion";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpUnitFromGitVersion
    extends PhpUnitVersion {
        PhpUnitFromGitVersion(@NotNull String version) {
            if (version == null) {
                PhpUnitFromGitVersion.$$$reportNull$$$0(0);
            }
            super(version);
        }

        @Override
        public boolean isAfterPrinterChange() {
            boolean notFullySupported = StringUtil.startsWith((CharSequence)this.myVersion, (CharSequence)"5.0") || StringUtil.startsWith((CharSequence)this.myVersion, (CharSequence)"5.1");
            return !notFullySupported && super.isAfterPrinterChange();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/php/phpunit/PhpUnitVersion$PhpUnitFromGitVersion", "<init>"));
        }
    }
}

