/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpTestFrameworkVersionDetector;
import com.jetbrains.php.phpunit.PhpUnitVersion;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitVersionDetector
extends PhpTestFrameworkVersionDetector<PhpUnitVersion> {
    @NlsSafe
    private static final String PHPUNIT = "PHPUnit";
    private static PhpUnitVersionDetector myInstance;

    public static PhpUnitVersionDetector getInstance() {
        if (myInstance == null) {
            myInstance = new PhpUnitVersionDetector();
        }
        return myInstance;
    }

    @Override
    @NotNull
    protected String getPresentableName() {
        return PHPUNIT;
    }

    @Override
    @NotNull
    protected String getTitle() {
        String string = PhpBundle.message("phpunit.getting.phpunit.version", new Object[0]);
        if (string == null) {
            PhpUnitVersionDetector.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public PhpUnitVersion parse(@Nullable String output) throws ExecutionException {
        List split = StringUtil.isNotEmpty((String)(output = PhpUnitVersionDetector.trimBeforePhpUnitLiteral(output))) ? StringUtil.split((String)output.trim(), (String)" ") : Collections.emptyList();
        int index = split.indexOf(PHPUNIT);
        if (index >= 0 && index < split.size() - 1) {
            PhpUnitVersion phpUnitVersion = PhpUnitVersion.create(((String)split.get(index + 1)).trim());
            if (phpUnitVersion == null) {
                PhpUnitVersionDetector.$$$reportNull$$$0(1);
            }
            return phpUnitVersion;
        }
        throw new ExecutionException(PhpBundle.message("can.not.parse.phpunit.version.output.0", output));
    }

    @Nullable
    private static String trimBeforePhpUnitLiteral(@Nullable String output) {
        int i;
        if (output != null && (i = output.indexOf(PHPUNIT)) > 0) {
            return output.substring(i);
        }
        return output;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/phpunit/PhpUnitVersionDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

