/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit.coverage;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import org.jetbrains.annotations.NotNull;

public class PhpDbgCommandSettingsBuilder
extends PhpCommandSettingsBuilder {
    public static final String PHPDBG = "phpdbg";
    public static final String PHP = "php";

    public PhpDbgCommandSettingsBuilder(@NotNull Project project, @NotNull PhpInterpreter interpreter) {
        if (project == null) {
            PhpDbgCommandSettingsBuilder.$$$reportNull$$$0(0);
        }
        if (interpreter == null) {
            PhpDbgCommandSettingsBuilder.$$$reportNull$$$0(1);
        }
        super(project, interpreter);
    }

    @Override
    @NotNull
    protected PhpCommandSettings createLocalSettings() throws ExecutionException {
        PhpCommandLinePathProcessor pathProcessor = PhpCommandLinePathProcessor.LOCAL;
        assert (this.myInterpreter != null);
        VirtualFile phpdbgFile = PhpDbgCommandSettingsBuilder.findPhpDbg(this.myInterpreter);
        PhpCommandSettings command = PhpDbgCommandSettingsBuilder.create(pathProcessor.process(phpdbgFile.getPath()), pathProcessor, null);
        command.addOption("-qrr");
        PhpCommandSettings phpCommandSettings = command;
        if (phpCommandSettings == null) {
            PhpDbgCommandSettingsBuilder.$$$reportNull$$$0(2);
        }
        return phpCommandSettings;
    }

    public static VirtualFile findPhpDbg(@NotNull PhpInterpreter interpreter) throws ExecutionException {
        if (interpreter == null) {
            PhpDbgCommandSettingsBuilder.$$$reportNull$$$0(3);
        }
        VirtualFile binary = PhpDbgCommandSettingsBuilder.findPhpBinary(interpreter.getHomePath());
        String phpdbgName = binary.getName().replace(PHP, PHPDBG);
        VirtualFile phpdbg = binary.getParent().findChild(phpdbgName);
        if (phpdbg == null) {
            throw new ExecutionException(PhpBundle.message("validation.0.not.found.at.1", phpdbgName, binary.getParent().getPresentableUrl()));
        }
        return phpdbg;
    }

    @Override
    @NotNull
    protected PhpCommandSettings createRemoteSettings() throws ExecutionException {
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        if (manager == null) {
            throw new ExecutionException(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage());
        }
        assert (this.myInterpreter != null);
        PhpSdkAdditionalData data = this.myInterpreter.clone().getPhpSdkAdditionalData();
        manager.replaceWithPhpDbg(data);
        PhpCommandSettings command = manager.createPhpCommand(this.myProject, data);
        command.addOption("-qrr");
        PhpCommandSettings phpCommandSettings = command;
        if (phpCommandSettings == null) {
            PhpDbgCommandSettingsBuilder.$$$reportNull$$$0(4);
        }
        return phpCommandSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/coverage/PhpDbgCommandSettingsBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/coverage/PhpDbgCommandSettingsBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPhpDbg";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

