/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.profiler.model.ProfilerModel;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfilerModelWrapper {
    private static final Key<ProfilerModelWrapper> KEY = Key.create((String)"profiler.model.wrapper.key");
    final Object2LongMap<ProfilerModel.Callable> mySummaryTimeMap;
    @NotNull
    private final ProfilerModel myModel;
    private long mySummaryTime;
    private long mySummaryInvocationCount;

    @Nullable
    public static ProfilerModelWrapper find(VirtualFile file) {
        return (ProfilerModelWrapper)file.getUserData(KEY);
    }

    public static void removeFrom(VirtualFile file) {
        file.putUserData(KEY, null);
    }

    public static void store(VirtualFile file, ProfilerModelWrapper wrapper) {
        file.putUserData(KEY, (Object)wrapper);
    }

    public ProfilerModelWrapper(@NotNull ProfilerModel model) {
        if (model == null) {
            ProfilerModelWrapper.$$$reportNull$$$0(0);
        }
        this.mySummaryTimeMap = new Object2LongOpenHashMap();
        this.mySummaryTime = -1L;
        this.mySummaryInvocationCount = -1L;
        this.myModel = model;
    }

    @NotNull
    public ProfilerModel getModel() {
        ProfilerModel profilerModel = this.myModel;
        if (profilerModel == null) {
            ProfilerModelWrapper.$$$reportNull$$$0(1);
        }
        return profilerModel;
    }

    public long getSummaryTime() {
        if (this.mySummaryTime == -1L) {
            long time = 0L;
            Map<ProfilerModel.Callable, ProfilerModel.Call> callees = this.myModel.getCallees(null);
            for (ProfilerModel.Callable callable : callees.keySet()) {
                time += this.getSummaryTime(callable);
            }
            this.mySummaryTime = time;
        }
        return this.mySummaryTime;
    }

    public long getSummaryTime(@Nullable ProfilerModel.Callable callable) {
        if (callable == null) {
            return this.getSummaryTime();
        }
        long summaryTime = this.mySummaryTimeMap.getLong((Object)callable);
        if (summaryTime == 0L) {
            summaryTime = ProfilerModelWrapper.getSummaryTime(this.myModel, callable);
            this.mySummaryTimeMap.put((Object)callable, summaryTime);
        }
        return summaryTime;
    }

    public static long getSummaryTime(@NotNull ProfilerModel model, @NotNull ProfilerModel.Callable callable) {
        if (model == null) {
            ProfilerModelWrapper.$$$reportNull$$$0(2);
        }
        if (callable == null) {
            ProfilerModelWrapper.$$$reportNull$$$0(3);
        }
        long time = callable.getSummaryOwnTime();
        for (Map.Entry<ProfilerModel.Callable, ProfilerModel.Call> entry : model.getCallees(callable).entrySet()) {
            if (model.callablesAreEqual(callable, entry.getKey())) continue;
            time += entry.getValue().getTime();
        }
        return time;
    }

    public long getSummaryInvocationCount() {
        if (this.mySummaryInvocationCount == -1L) {
            long summaryInvocationCount = 0L;
            Set<ProfilerModel.Callable> callables = this.myModel.getCallables();
            for (ProfilerModel.Callable callable : callables) {
                summaryInvocationCount += (long)callable.getSummaryInvocationCount();
            }
            this.mySummaryInvocationCount = summaryInvocationCount;
        }
        assert (this.mySummaryInvocationCount > 0L);
        return this.mySummaryInvocationCount;
    }

    public long getSummaryOwnTime(@Nullable ProfilerModel.Callable callable) {
        if (callable != null) {
            return callable.getSummaryOwnTime();
        }
        return this.getSummaryTime();
    }

    public long getSummaryInvocationCount(@Nullable ProfilerModel.Callable callable) {
        if (callable != null) {
            return callable.getSummaryInvocationCount();
        }
        return this.getSummaryInvocationCount();
    }

    @NotNull
    public ProfilerModel.Callable getMaxSummaryInvocationCount() {
        ProfilerModel.Callable max = null;
        long maxValue = 0L;
        for (ProfilerModel.Callable next : this.myModel.getCallables()) {
            long curValue = this.getSummaryInvocationCount(next);
            if (maxValue >= curValue) continue;
            max = next;
            maxValue = curValue;
        }
        assert (max != null);
        ProfilerModel.Callable callable = max;
        if (callable == null) {
            ProfilerModelWrapper.$$$reportNull$$$0(4);
        }
        return callable;
    }

    @NotNull
    public ProfilerModel.Callable getMaxSummaryOwnTime() {
        ProfilerModel.Callable max = null;
        long maxValue = 0L;
        for (ProfilerModel.Callable next : this.myModel.getCallables()) {
            long curValue = this.getSummaryOwnTime(next);
            if (maxValue > curValue) continue;
            max = next;
            maxValue = curValue;
        }
        assert (max != null);
        ProfilerModel.Callable callable = max;
        if (callable == null) {
            ProfilerModelWrapper.$$$reportNull$$$0(5);
        }
        return callable;
    }

    @NotNull
    public ProfilerModel.Callable getMaxSummaryTime() {
        ProfilerModel.Callable max = null;
        long maxValue = 0L;
        for (ProfilerModel.Callable next : this.myModel.getCallables()) {
            long curValue = this.getSummaryTime(next);
            if (maxValue > curValue) continue;
            max = next;
            maxValue = curValue;
        }
        assert (max != null);
        ProfilerModel.Callable callable = max;
        if (callable == null) {
            ProfilerModelWrapper.$$$reportNull$$$0(6);
        }
        return callable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/profiler/ProfilerModelWrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/profiler/ProfilerModelWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxSummaryInvocationCount";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxSummaryOwnTime";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxSummaryTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSummaryTime";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

