/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.model.impl;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.Interner;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class ProfilerSourcePositionData {
    private final String myFileName;
    private final int myLineNumber;
    static Interner<ProfilerSourcePositionData> ourInterner = Interner.createWeakInterner();
    public static final ProfilerSourcePositionData NULL = new ProfilerSourcePositionData("", 0);

    private ProfilerSourcePositionData(@NotNull String fileName, int lineNumber) {
        if (fileName == null) {
            ProfilerSourcePositionData.$$$reportNull$$$0(0);
        }
        this.myFileName = fileName;
        this.myLineNumber = lineNumber;
    }

    @NotNull
    @NlsSafe
    public String getFilePath() {
        String string = this.myFileName;
        if (string == null) {
            ProfilerSourcePositionData.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfilerSourcePositionData position = (ProfilerSourcePositionData)o;
        return this.myLineNumber == position.myLineNumber && this.myFileName.equals(position.myFileName);
    }

    public int hashCode() {
        return Objects.hash(this.myFileName, this.myLineNumber);
    }

    @NotNull
    public static ProfilerSourcePositionData createSourcePosition(@NotNull String fileName, int lineNumber) {
        if (fileName == null) {
            ProfilerSourcePositionData.$$$reportNull$$$0(2);
        }
        ProfilerSourcePositionData profilerSourcePositionData = (ProfilerSourcePositionData)ourInterner.intern((Object)new ProfilerSourcePositionData(fileName, lineNumber));
        if (profilerSourcePositionData == null) {
            ProfilerSourcePositionData.$$$reportNull$$$0(3);
        }
        return profilerSourcePositionData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/profiler/model/impl/ProfilerSourcePositionData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/profiler/model/impl/ProfilerSourcePositionData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSourcePosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSourcePosition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

