/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.xdebug.model2;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.profiler.PhpSnapshotFormatException;
import com.jetbrains.php.profiler.model.impl.ProfilerSourcePositionData;
import com.jetbrains.php.profiler.xdebug.model2.XCall;
import com.jetbrains.php.profiler.xdebug.model2.XCallable;
import com.jetbrains.php.profiler.xdebug.model2.XModel;
import com.jetbrains.php.profiler.xdebug.model2.XModelBuilderInterface;
import com.jetbrains.php.profiler.xdebug.model2.statistics.XCallableStatisticsData;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.NotNull;

public class XModelBuilder
implements XModelBuilderInterface {
    private final Deque<XCall> myPendingList = new ArrayDeque<XCall>();
    public final XModel myModel = new XModel();
    private final XCall.Builder myCurrentCallBuilder = new XCall.Builder();
    private boolean myVersionIsHigherThan3;

    public XModelBuilder() {
        this(false);
    }

    public XModelBuilder(boolean isWithMemoryData) {
    }

    @Override
    public void onFinished() {
        this.myModel.calculateStatistics();
    }

    @Override
    public void onSnapshotStarted() throws PhpSnapshotFormatException {
        if (!this.myPendingList.isEmpty()) {
            throw new PhpSnapshotFormatException("unbalanced calls");
        }
    }

    @Override
    public void onSnapshotFinished() throws PhpSnapshotFormatException {
        if (this.myPendingList.isEmpty()) {
            throw new PhpSnapshotFormatException("unbalanced calls");
        }
        this.myModel.myXModelStorage.addTreeRoots(this.myPendingList);
        this.myPendingList.clear();
    }

    @Override
    public void callStarted(@NotNull String fileName, @NotNull String functionName, int lineNumber, long ownTime) throws PhpSnapshotFormatException {
        if (fileName == null) {
            XModelBuilder.$$$reportNull$$$0(0);
        }
        if (functionName == null) {
            XModelBuilder.$$$reportNull$$$0(1);
        }
        if (!this.myCurrentCallBuilder.isClear()) {
            throw new PhpSnapshotFormatException("unbalanced calls");
        }
        if (fileName.startsWith("php:internal")) {
            lineNumber = 0;
        }
        XCallable callable = XCallable.createCallable(this.myModel.myXModelStorage, ProfilerSourcePositionData.createSourcePosition(fileName, lineNumber), functionName);
        this.myCurrentCallBuilder.setFunction(callable).setOwnTime(ownTime).setCumulativeTime(ownTime);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void callStarted(@NotNull String fileName, @NotNull String functionName, int lineNumber, long ownTime, long l) throws PhpSnapshotFormatException {
        void ownMemory;
        if (fileName == null) {
            XModelBuilder.$$$reportNull$$$0(2);
        }
        if (functionName == null) {
            XModelBuilder.$$$reportNull$$$0(3);
        }
        this.callStarted(fileName, functionName, lineNumber, ownTime);
        this.myCurrentCallBuilder.setOwnMemory((long)ownMemory).setCumulativeMemory((long)ownMemory);
    }

    @Override
    public void callFinished(boolean isWithMemory) throws PhpSnapshotFormatException {
        if (this.myCurrentCallBuilder.isClear()) {
            throw new PhpSnapshotFormatException("unbalanced call");
        }
        XCall builtCall = this.myCurrentCallBuilder.build(this.myModel.myXModelStorage);
        this.myModel.myXModelStatistics.getSnapshotSummaryData().addToNumberOfCall(builtCall.getInvocationCount());
        this.myModel.myXModelStatistics.getSnapshotSummaryData().addToSummaryTime(builtCall.getOwnTime());
        XCallable callable = builtCall.getCallable();
        XCallableStatisticsData statistics = this.myModel.getStatistics(callable);
        statistics.addToNumberOfCall(builtCall.getInvocationCount());
        statistics.addToCumulativeTime(builtCall.getCumulativeTime());
        statistics.addToOwnTime(builtCall.getOwnTime());
        if (isWithMemory) {
            statistics.addToOwnMemory(builtCall.getOwnMemory());
            statistics.addToCumulativeMemory(builtCall.getCumulativeMemory());
        }
        statistics.myCallees.addAll(ContainerUtil.map(builtCall.getChildren(this.myModel), e -> e.getCallable()));
        this.myPendingList.addLast(builtCall);
        this.myCurrentCallBuilder.clear();
    }

    @Override
    public void processSubCall(long time) throws PhpSnapshotFormatException {
        this.processSubCall(false, time, 0L);
    }

    @Override
    public void processSubCall(long time, long memory) throws PhpSnapshotFormatException {
        this.processSubCall(true, time, memory);
    }

    @Override
    public void setVersionHigherThan3(boolean b) {
        this.myVersionIsHigherThan3 = b;
    }

    @Override
    public boolean isVersionIsHigherThan3() {
        return this.myVersionIsHigherThan3;
    }

    private void processSubCall(boolean withMemory, long time, long memory) throws PhpSnapshotFormatException {
        if (this.myCurrentCallBuilder.isClear()) {
            throw new PhpSnapshotFormatException("unbalanced calls");
        }
        this.myCurrentCallBuilder.myCumulativeTime += time;
        this.myCurrentCallBuilder.myCumulativeMemory += memory;
        if (this.myPendingList.isEmpty()) {
            XCall.Builder builder2 = new XCall.Builder().setCumulativeTime(0L).setOwnTime(0L).setFunction(XCallable.UNKNOWN);
            if (withMemory) {
                builder2.setCumulativeMemory(0L).setOwnMemory(0L);
            }
            this.myPendingList.addLast(builder2.build(this.myModel.myXModelStorage));
            this.myModel.getStatistics(this.myModel.myXModelStorage.createOrGet(XCallable.UNKNOWN)).addToNumberOfCall(1L);
            this.myModel.myXModelStatistics.getSnapshotSummaryData().addToNumberOfCall(1L);
        }
        this.myCurrentCallBuilder.addChild(this.myPendingList.pollLast());
    }

    @Override
    public XModel getModel() {
        return this.myModel;
    }

    public void addVirtualFile(VirtualFile file) {
        this.myModel.addVirtualFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fileName";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "functionName";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/profiler/xdebug/model2/XModelBuilder";
        objectArray[2] = "callStarted";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

