/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.LastRunReformatCodeOptionsProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SmartList;
import com.jetbrains.php.codeInsight.PhpImportOptimizer;
import com.jetbrains.php.lang.PhpLangUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpBaseRefactoringProcessor
extends BaseRefactoringProcessor {
    protected List<NonCodeUsageInfo> myNonCodeUsageInfos = new SmartList();

    protected PhpBaseRefactoringProcessor(Project project) {
        super(project);
    }

    public PhpBaseRefactoringProcessor(Project project, SearchScope scope) {
        super(project, scope, null);
    }

    public static void findNonCodeUsages(@NotNull PsiElement element, @NotNull SearchScope searchScope, @NotNull String oldText, @NotNull String newText, @NotNull Collection<UsageInfo> usages, boolean searchInStringsAndComments, boolean searchForTextOccurrences) {
        String oldShortName;
        if (element == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(1);
        }
        if (oldText == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(2);
        }
        if (newText == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(3);
        }
        if (usages == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(4);
        }
        if (!PhpLangUtil.equalsClassNames(oldShortName = PhpLangUtil.toShortName(oldText), oldText)) {
            PhpBaseRefactoringProcessor.findComplexNonCodeUsage(element, searchScope, oldShortName, oldText, newText, usages, searchInStringsAndComments, searchForTextOccurrences);
        } else {
            TextOccurrencesUtil.findNonCodeUsages((PsiElement)element, (SearchScope)searchScope, (String)oldText, (boolean)searchInStringsAndComments, (boolean)searchForTextOccurrences, (String)newText, usages);
        }
    }

    private static void findComplexNonCodeUsage(@NotNull PsiElement element, @NotNull SearchScope searchScope, @NotNull String oldShortName, @NotNull String oldText, @NotNull String newText, @NotNull Collection<UsageInfo> usages, boolean searchInStringsAndComments, boolean searchForTextOccurrences) {
        if (element == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(5);
        }
        if (searchScope == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(6);
        }
        if (oldShortName == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(7);
        }
        if (oldText == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(8);
        }
        if (newText == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(9);
        }
        if (usages == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(10);
        }
        TextOccurrencesUtil.findNonCodeUsages((PsiElement)element, (SearchScope)searchScope, (String)oldText, (boolean)searchInStringsAndComments, (boolean)false, (String)newText, usages);
        String oldTextEscaped = StringUtil.escapeBackSlashes((String)oldText);
        String newTextEscaped = StringUtil.escapeBackSlashes((String)newText);
        TextOccurrencesUtil.findNonCodeUsages((PsiElement)element, (SearchScope)searchScope, (String)oldTextEscaped, (boolean)searchInStringsAndComments, (boolean)false, (String)newTextEscaped, usages);
        int prefixLen = oldText.length() - oldShortName.length();
        int prefixEscapedLen = oldTextEscaped.length() - oldShortName.length();
        ArrayList shortNameUsages = new ArrayList();
        TextOccurrencesUtil.findNonCodeUsages((PsiElement)element, (SearchScope)searchScope, (String)oldShortName, (boolean)false, (boolean)searchForTextOccurrences, (String)newText, shortNameUsages);
        for (UsageInfo usage : shortNameUsages) {
            Segment segment = usage.getSegment();
            if (segment == null) continue;
            NonCodeUsageInfo newUsage = PhpBaseRefactoringProcessor.createNonCodeUsage(element, segment, usage, oldText, newText, prefixLen);
            if (newUsage != null) {
                usages.add((UsageInfo)newUsage);
                continue;
            }
            NonCodeUsageInfo newUsageEscaped = PhpBaseRefactoringProcessor.createNonCodeUsage(element, segment, usage, oldTextEscaped, newTextEscaped, prefixEscapedLen);
            if (newUsageEscaped == null) continue;
            usages.add((UsageInfo)newUsageEscaped);
        }
    }

    @Nullable
    private static NonCodeUsageInfo createNonCodeUsage(@NotNull PsiElement element, @NotNull Segment segment, @NotNull UsageInfo usage, @NotNull String oldText, @NotNull String newText, int prefixLen) {
        String oldFragment;
        PsiFile file;
        int startOffset;
        if (element == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(11);
        }
        if (segment == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(12);
        }
        if (usage == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(13);
        }
        if (oldText == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(14);
        }
        if (newText == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(15);
        }
        if ((startOffset = segment.getStartOffset() - prefixLen) >= 0 && (file = usage.getFile()) != null && StringUtil.equals((CharSequence)(oldFragment = file.getText().substring(startOffset, segment.getEndOffset())), (CharSequence)oldText)) {
            return NonCodeUsageInfo.create((PsiFile)file, (int)startOffset, (int)segment.getEndOffset(), (PsiElement)element, (String)newText);
        }
        return null;
    }

    protected abstract void performMainRefactoring(UsageInfo[] var1);

    protected void performPostRefactoring(UsageInfo[] usages) {
    }

    protected boolean forceOptimizeImports() {
        return false;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(16);
        }
        this.performMainRefactoring(usages);
        if (!this.myNonCodeUsageInfos.isEmpty()) {
            RenameUtil.renameNonCodeUsages((Project)this.myProject, (NonCodeUsageInfo[])this.myNonCodeUsageInfos.toArray(new NonCodeUsageInfo[0]));
        }
        this.performPostRefactoring(usages);
    }

    protected void optimizeImports(@NotNull Collection<PsiFile> files) {
        if (files == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(17);
        }
        this.optimizeImports(files.toArray(PsiFile.EMPTY_ARRAY));
    }

    protected void optimizeImports(PsiFile ... files) {
        if (files == null) {
            PhpBaseRefactoringProcessor.$$$reportNull$$$0(18);
        }
        LastRunReformatCodeOptionsProvider settings = new LastRunReformatCodeOptionsProvider(PropertiesComponent.getInstance());
        if (this.forceOptimizeImports() || settings.getLastOptimizeImports()) {
            ArrayList optimizers = new ArrayList();
            boolean complete = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                PhpImportOptimizer optimizer = new PhpImportOptimizer();
                for (PsiFile file : files) {
                    if (!file.isValid() || !file.isWritable() || !optimizer.supports(file)) continue;
                    optimizers.add(optimizer.processFile(file));
                }
            }, CodeInsightBundle.message((String)"progress.text.optimizing.imports", (Object[])new Object[0]), true, this.myProject);
            if (!complete) {
                throw new ProcessCanceledException();
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (Runnable optimizer : optimizers) {
                    optimizer.run();
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldText";
                break;
            }
            case 3: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 4: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldShortName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/PhpBaseRefactoringProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findNonCodeUsages";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "findComplexNonCodeUsage";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createNonCodeUsage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "performRefactoring";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "optimizeImports";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

