/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.refactoring.PhpFileCreator;
import com.jetbrains.php.refactoring.validation.PhpFilePathValidationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFileCreationInfo {
    private final PsiDirectory myBaseDirectory;
    @Nullable
    private final String myRelativeTargetDirectory;
    private final String myFileName;

    protected PhpFileCreationInfo(@NotNull PsiDirectory baseDirectory, @Nullable String directory, @NotNull String fileName) {
        if (baseDirectory == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(0);
        }
        if (fileName == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(1);
        }
        this.myBaseDirectory = baseDirectory;
        this.myRelativeTargetDirectory = directory;
        this.myFileName = fileName;
    }

    @NotNull
    public PsiDirectory getBaseDirectory() {
        PsiDirectory psiDirectory = this.myBaseDirectory;
        if (psiDirectory == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(2);
        }
        return psiDirectory;
    }

    @NotNull
    public String getRelativePath() {
        String string = (String)(StringUtil.isEmpty((String)this.myRelativeTargetDirectory) ? "" : this.myRelativeTargetDirectory + "/") + this.myFileName;
        if (string == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getAbsolutePath() {
        String basePath = this.myBaseDirectory.getVirtualFile().getPath();
        String relativePath = StringUtil.isEmpty((String)this.myRelativeTargetDirectory) ? "" : "/" + this.myRelativeTargetDirectory;
        String string = basePath + relativePath + "/" + this.myFileName;
        if (string == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static PhpFileCreationInfo generateConfiguration(@NotNull Project project, @NotNull String filePath, @NotNull String fileName) throws PhpFilePathValidationException {
        if (project == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(6);
        }
        if (filePath == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(7);
        }
        if (fileName == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(8);
        }
        return PhpFileCreationInfo.generateConfiguration(project, filePath, fileName, true);
    }

    @NotNull
    public static PhpFileCreationInfo generateConfiguration(@NotNull Project project, @NotNull String filePath, @NotNull String fileName, boolean checkFileExists) throws PhpFilePathValidationException {
        PsiDirectory existingDir;
        if (project == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(9);
        }
        if (filePath == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(10);
        }
        if (fileName == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(11);
        }
        if ((existingDir = PhpFileCreationInfo.extractDeepestExistingDirectory(project, filePath)) == null) {
            throw new PhpFilePathValidationException(PhpBundle.message("refactoring.common.validation.target.directory.is.not.valid", filePath));
        }
        VirtualFile baseDir = existingDir.getVirtualFile();
        boolean isInProject = ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(baseDir);
        if (!isInProject) {
            throw new PhpFilePathValidationException(PhpBundle.message("refactoring.common.validation.target.directory.not.inside.project", baseDir.getPath()));
        }
        String relativeTargetDir = PhpFileCreationInfo.getRelativePath(baseDir, filePath);
        if (relativeTargetDir == null) {
            throw new PhpFilePathValidationException(PhpBundle.message("validation.file.not.valid.name", filePath));
        }
        String message = PhpFileCreationInfo.isValidFilePath(existingDir, relativeTargetDir, fileName, checkFileExists);
        if (StringUtil.isNotEmpty((String)message)) {
            throw new PhpFilePathValidationException(message);
        }
        return new PhpFileCreationInfo(existingDir, relativeTargetDir, fileName);
    }

    @Nullable
    private static String getRelativePath(@NotNull VirtualFile baseDir, @NotNull String filePath) {
        String relativeDirPath;
        if (baseDir == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(12);
        }
        if (filePath == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(13);
        }
        return StringUtil.equals((CharSequence)(relativeDirPath = FileUtil.getRelativePath((String)baseDir.getPath(), (String)filePath, (char)'/')), (CharSequence)".") ? "" : relativeDirPath;
    }

    @Nullable
    private static String isValidFilePath(@NotNull PsiDirectory baseDirectory, @NotNull String relativeDirPath, @NotNull String fileName, boolean checkFileExists) {
        String filePath;
        String dirPath;
        if (baseDirectory == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(14);
        }
        if (relativeDirPath == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(15);
        }
        if (fileName == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(16);
        }
        List split = ContainerUtil.append(StringUtil.isEmpty((String)(dirPath = FileUtil.toSystemIndependentName((String)relativeDirPath))) ? new ArrayList() : StringUtil.split((String)dirPath, (String)"/"), (Object[])new String[]{fileName});
        for (String path : split) {
            if (PathUtil.isValidFileName((String)path)) continue;
            return PhpBundle.message("validation.file.not.valid.name", relativeDirPath);
        }
        if (!checkFileExists) {
            return null;
        }
        VirtualFile baseDirectoryFile = baseDirectory.getVirtualFile();
        VirtualFile fileByRelativePath = baseDirectoryFile.findFileByRelativePath(filePath = StringUtil.isEmpty((String)dirPath) ? fileName : dirPath + "/" + fileName);
        if (fileByRelativePath != null) {
            StringBuilder directoryPath = new StringBuilder(baseDirectoryFile.getPath());
            if (!StringUtil.isEmpty((String)dirPath)) {
                directoryPath.append("/");
                directoryPath.append(dirPath);
            }
            return PhpBundle.message("validation.file.already.exists.in.dir", filePath, FileUtil.toSystemDependentName((String)directoryPath.toString()));
        }
        return null;
    }

    @Nullable
    private static PsiDirectory extractDeepestExistingDirectory(@NotNull Project project, @NotNull String path) {
        TempFileSystem fileSystem;
        if (project == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(17);
        }
        if (path == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(18);
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        String existingPath = path;
        PsiDirectory directory = null;
        Object object = fileSystem = ApplicationManager.getApplication().isUnitTestMode() ? TempFileSystem.getInstance() : LocalFileSystem.getInstance();
        while (StringUtil.isNotEmpty((String)existingPath) && directory == null && !existingPath.isEmpty()) {
            VirtualFile file = fileSystem.findFileByPath(existingPath);
            if (file != null) {
                directory = manager.findDirectory(file);
                continue;
            }
            existingPath = PathUtil.getParentPath((String)existingPath);
        }
        return directory;
    }

    @NotNull
    public PsiDirectory findOrCreateTargetDirectory() {
        List path = StringUtil.split((String)FileUtil.toSystemIndependentName((String)this.getRelativePath()), (String)"/");
        PsiDirectory psiDirectory = PhpFileCreator.createDirectory(path, this.getBaseDirectory());
        if (psiDirectory == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(19);
        }
        return psiDirectory;
    }

    public String toString() {
        return "PhpFileCreationInfo{myBaseDirectory=" + this.myBaseDirectory.getVirtualFile().getPath() + ", myRelativeTargetDirectory='" + this.myRelativeTargetDirectory + "', myFileName='" + this.myFileName + "'}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpFileCreationInfo";
                break;
            }
            case 6: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeDirPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpFileCreationInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateTargetDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 19: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateConfiguration";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isValidFilePath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "extractDeepestExistingDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 19 -> new IllegalStateException(string);
        };
    }
}

