/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpChangeVisibilityIntentionBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpMoveClassMemberBase {
    protected static final Logger LOG = Logger.getInstance(PhpMoveClassMemberBase.class);
    private static final TokenSet FIELD_LIST_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.CLASS_FIELDS, PhpElementTypes.CLASS_CONSTANTS});
    private static final Condition<PsiElement> FIELD_LIST_CONDITION = element -> {
        ASTNode node = element.getNode();
        IElementType elementType = node == null ? null : node.getElementType();
        return FIELD_LIST_TOKEN_SET.contains(elementType);
    };
    protected PhpClass myTargetClass;
    protected boolean myShouldWeakAccess;
    protected boolean myMoveConstantsAsEnum;

    private PhpMoveClassMemberBase(PhpClass targetClass, boolean shouldWeakAccess) {
        this.myTargetClass = targetClass;
        this.myShouldWeakAccess = shouldWeakAccess;
    }

    private PhpMoveClassMemberBase(PhpClass targetClass, boolean shouldWeakAccess, boolean moveConstantsAsEnum) {
        this.myTargetClass = targetClass;
        this.myShouldWeakAccess = shouldWeakAccess;
        this.myMoveConstantsAsEnum = moveConstantsAsEnum;
    }

    @NotNull
    public static PhpMoveClassMemberBase getInstance(@NotNull PhpClass targetClass, boolean shouldWeakAccess) {
        if (targetClass == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(0);
        }
        return PhpMoveClassMemberBase.getInstance(targetClass, shouldWeakAccess, false);
    }

    @NotNull
    public static PhpMoveClassMemberBase getInstance(@NotNull PhpClass targetClass, boolean shouldWeakAccess, boolean moveConstantsAsEnum) {
        if (targetClass == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(1);
        }
        if (targetClass.isInterface()) {
            return new PhpMoveClassMemberToInterface(targetClass, shouldWeakAccess);
        }
        return new PhpMoveClassMember(targetClass, shouldWeakAccess, moveConstantsAsEnum);
    }

    public static void removeMembers(@NotNull List<? extends PhpClassMember> members, boolean shouldRemoveMethods) {
        if (members == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(2);
        }
        for (PhpClassMember phpClassMember : members) {
            if (phpClassMember instanceof Field) {
                PhpMoveClassMemberBase.removeFieldWithPhpDoc((Field)phpClassMember);
                continue;
            }
            if (!shouldRemoveMethods || !(phpClassMember instanceof Method)) continue;
            PhpMoveClassMemberBase.removeFunctionWithPhpDoc((Function)((Method)phpClassMember));
        }
    }

    public static void removeFieldWithPhpDoc(Field field) {
        PsiElement fieldList = PhpMoveClassMemberBase.getFieldListElement(field);
        LOG.assertTrue(fieldList != null);
        if (PhpMoveClassMemberBase.isSingleFieldList(fieldList)) {
            PsiElement parent = fieldList.getParent();
            PhpDocComment comment = field.getDocComment();
            parent.deleteChildRange((PsiElement)(comment == null ? fieldList : comment), fieldList);
        } else {
            PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)field, PhpTokenTypes.opCOMMA);
        }
    }

    public static void removeFunctionWithPhpDoc(Function function) {
        PsiElement methodParent = function.getParent();
        if (function instanceof PhpDocMethod) {
            methodParent.getParent().deleteChildRange(methodParent, methodParent);
            return;
        }
        PhpDocComment comment = function.getDocComment();
        methodParent.deleteChildRange((PsiElement)(comment != null ? comment : function), (PsiElement)function);
    }

    @NotNull
    public List<PsiElement> move(@NotNull List<PhpClassMember> members, boolean shouldRemoveMethods) {
        if (members == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(3);
        }
        List<PsiElement> list = this.cutAndMove(members, shouldRemoveMethods);
        if (list == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<PsiElement> move(@NotNull List<PhpClassMember> members, PhpModifier.Access access, boolean shouldRemoveMethods) {
        if (members == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(5);
        }
        for (PhpClassMember memberIt : members) {
            PhpMoveClassMemberBase.changeMemberVisibility(access, memberIt);
        }
        List<PsiElement> list = this.cutAndMove(members, shouldRemoveMethods);
        if (list == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static void changeMemberVisibility(PhpModifier.Access access, PhpClassMember member) {
        PsiElement modifierList;
        PhpModifier modifier = member.getModifier();
        PhpModifierList newModifierList = PhpPsiElementFactory.createModifierList(member.getProject(), PhpModifier.instance((PhpModifier.Access)access, (PhpModifier.Abstractness)modifier.getAbstractness(), (PhpModifier.State)modifier.getState()));
        PhpClassMember element = member;
        if (member instanceof Field) {
            element = member.getParent();
        }
        if ((modifierList = PhpPsiUtil.getChildOfType((PsiElement)element, PhpElementTypes.MODIFIER_LIST)) instanceof PhpModifierList) {
            PsiElement replace = modifierList.replace((PsiElement)newModifierList);
            if (modifierList.getTextRange().isEmpty()) {
                replace.getParent().addAfter((PsiElement)PhpPsiElementFactory.createWhiteSpace(replace.getProject()), replace);
            }
        }
    }

    public List<PsiElement> move(List<PhpClassMember> members) {
        PhpClassReferenceResolver referenceResolver = new PhpClassReferenceResolver();
        referenceResolver.processElements(members);
        boolean hasAbstractMembers = false;
        ArrayList<PsiElement> movedMembers = new ArrayList<PsiElement>();
        for (PhpClassMember member : members) {
            if (member instanceof Method) {
                movedMembers.add((PsiElement)this.moveMethod((Method)member, members));
                hasAbstractMembers = hasAbstractMembers || ((Method)member).isAbstract();
                continue;
            }
            movedMembers.add(this.moveField((Field)member));
        }
        if (hasAbstractMembers && !this.myTargetClass.isAbstract()) {
            PsiElement abstractClass = PhpPsiElementFactory.createFromText(this.myTargetClass.getProject(), PhpTokenTypes.kwABSTRACT, "abstract class A {}");
            PsiElement child = this.myTargetClass.getFirstChild();
            if (child != null) {
                this.myTargetClass.addBefore(abstractClass, child);
            }
        }
        PhpPsiElement scopeHolder = PhpMoveClassMemberBase.getScopeHolder(this.myTargetClass);
        referenceResolver.importReferences(scopeHolder, movedMembers);
        return movedMembers;
    }

    @NotNull
    public List<PsiElement> cutAndMove(@NotNull List<PhpClassMember> members, boolean shouldRemoveMethods) {
        if (members == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(7);
        }
        List<PsiElement> movedMembers = this.move(members);
        PhpMoveClassMemberBase.removeMembers(members, shouldRemoveMethods);
        List<PsiElement> list = movedMembers;
        if (list == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static PhpPsiElement getScopeHolder(@NotNull PhpClass targetClass) {
        if (targetClass == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(9);
        }
        PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)targetClass);
        assert (scopeHolder != null);
        PhpPsiElement phpPsiElement = scopeHolder;
        if (phpPsiElement == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(10);
        }
        return phpPsiElement;
    }

    @NotNull
    protected abstract Method moveMethod(@NotNull Method var1, List<PhpClassMember> var2);

    @NotNull
    private PsiElement moveField(@NotNull Field field) {
        if (field == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(11);
        }
        return PhpMoveClassMemberBase.addField(this.myTargetClass, this.myShouldWeakAccess, field, this.myMoveConstantsAsEnum);
    }

    protected void updateMethodAccess(@NotNull Method method, @NotNull String currentAccess, @NotNull String destinationAccess) {
        if (method == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(12);
        }
        if (currentAccess == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(13);
        }
        if (destinationAccess == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(14);
        }
        String methodCode = method.getText().replaceFirst(currentAccess, destinationAccess);
        Method newMethod = PhpPsiElementFactory.createMethod(method.getProject(), methodCode);
        method.replace((PsiElement)newMethod);
    }

    @NotNull
    private static <T extends Function> Method addMethodUp(@NotNull PhpClass clazz, @NotNull T method, @NotNull String methodCode, @Nullable String currentAccess, @NotNull String destinationAccess) {
        if (clazz == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(15);
        }
        if (method == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(16);
        }
        if (methodCode == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(17);
        }
        if (destinationAccess == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(18);
        }
        if (!(method instanceof PhpDocMethod)) {
            if (currentAccess != null) {
                methodCode = methodCode.replaceFirst(currentAccess, destinationAccess);
            }
            return PhpMoveClassMemberBase.addMethodWithPhpDoc(clazz, method, methodCode);
        }
        PhpCodeEditUtil.insertDocMethodBeforeClass(clazz, method.getParent());
        PhpDocMethod phpDocMethod = (PhpDocMethod)method;
        if (phpDocMethod == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(19);
        }
        return phpDocMethod;
    }

    @NotNull
    private static PsiElement addField(@NotNull PhpClass clazz, boolean moveUp, @NotNull Field field, boolean moveConstantsAsEnum) {
        if (clazz == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(20);
        }
        if (field == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(21);
        }
        PsiElement fieldList = PhpMoveClassMemberBase.getFieldListElement(field);
        assert (fieldList != null);
        PhpPsiElement newField = PhpMoveClassMemberBase.constructField(field, moveUp, moveConstantsAsEnum);
        PhpDocComment comment = PhpMoveClassMemberBase.isSingleFieldList(fieldList) ? field.getDocComment() : null;
        PsiElement insertedField = PhpCodeEditUtil.insertClassMemberWithPhpDoc(clazz, (PsiElement)newField, comment);
        assert (insertedField != null);
        PsiElement psiElement = insertedField;
        if (psiElement == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(22);
        }
        return psiElement;
    }

    public static String getDefaultValueText(@NotNull Field field) {
        ClassReference classReference;
        if (field == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(23);
        }
        ClassConstantReference classConstReference = (ClassConstantReference)ObjectUtils.tryCast((Object)field.getDefaultValue(), ClassConstantReference.class);
        PhpClass containingClass = field.getContainingClass();
        if (classConstReference != null && containingClass != null && (classReference = (ClassReference)ObjectUtils.tryCast((Object)classConstReference.getClassReference(), ClassReference.class)) != null && PhpLangUtil.isSelfReference(classReference)) {
            return containingClass.getName() + "::" + classConstReference.getName();
        }
        return PhpChangeVisibilityIntentionBase.getDefaultValueText(field);
    }

    @NotNull
    public static PhpPsiElement constructField(@NotNull Field field, boolean moveUp, boolean moveConstantsAsEnum) {
        if (field == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(24);
        }
        Project project = field.getProject();
        PhpModifier modifier = field.getModifier();
        PhpModifier.Access access = modifier.isPrivate() && moveUp ? PhpModifier.Access.PROTECTED : modifier.getAccess();
        PhpType type = PhpLanguageFeature.TYPED_CLASS_CONSTANTS.isSupported(project) ? field.getGlobalType() : null;
        String typeString = type != null ? PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, type, (PsiElement)field) : null;
        String defaultValueText = PhpMoveClassMemberBase.getDefaultValueText(field);
        if (field.isConstant()) {
            if (moveConstantsAsEnum) {
                PhpEnumCase phpEnumCase = PhpPsiElementFactory.createEnumCase(project, field.getName(), defaultValueText);
                if (phpEnumCase == null) {
                    PhpMoveClassMemberBase.$$$reportNull$$$0(25);
                }
                return phpEnumCase;
            }
            PhpPsiElement phpPsiElement = PhpPsiElementFactory.createClassConstant(project, PhpMoveClassMemberBase.getNewConstModifier(project, modifier, access), field.getName(), typeString, StringUtil.notNullize((String)defaultValueText));
            if (phpPsiElement == null) {
                PhpMoveClassMemberBase.$$$reportNull$$$0(26);
            }
            return phpPsiElement;
        }
        PhpPsiElement phpPsiElement = PhpPsiElementFactory.createClassField(project, PhpModifier.instance((PhpModifier.Access)access, (PhpModifier.Abstractness)modifier.getAbstractness(), (PhpModifier.State)modifier.getState()), field.isReadonly(), field.getName(), defaultValueText, PhpMoveClassMemberBase.getFieldTypeText(field));
        if (phpPsiElement == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(27);
        }
        return phpPsiElement;
    }

    @Nullable
    private static PhpModifier getNewConstModifier(Project project, PhpModifier oldModifier, PhpModifier.Access newAccess) {
        if (PhpLanguageFeature.FINAL_CLASS_CONSTANTS.isSupported(project)) {
            return PhpModifier.instance((PhpModifier.Access)newAccess, (PhpModifier.Abstractness)oldModifier.getAbstractness(), (PhpModifier.State)PhpModifier.State.DYNAMIC);
        }
        if (PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY.isSupported(project)) {
            return PhpModifier.instance((PhpModifier.Access)newAccess, (PhpModifier.Abstractness)PhpModifier.Abstractness.IMPLEMENTED, (PhpModifier.State)PhpModifier.State.DYNAMIC);
        }
        return null;
    }

    @Nullable
    private static String getFieldTypeText(@NotNull Field field) {
        if (field == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(28);
        }
        PhpTypeDeclaration typeDeclaration = (PhpTypeDeclaration)PhpPsiUtil.getPrevSiblingByCondition((PsiElement)field, (Condition<? super PsiElement>)((Condition)PhpTypeDeclaration.class::isInstance));
        return typeDeclaration == null ? null : typeDeclaration.getText();
    }

    @Nullable
    public static PsiElement getFieldListElement(@NotNull Field field) {
        if (field == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(29);
        }
        return PhpPsiUtil.getParentByCondition((PsiElement)field, false, FIELD_LIST_CONDITION);
    }

    public static boolean isSingleFieldList(@NotNull PsiElement fieldList) {
        List childFields;
        if (fieldList == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(30);
        }
        return (childFields = PhpPsiUtil.getChildren(fieldList, (Condition<? super PsiElement>)Field.INSTANCEOF)).size() <= 1;
    }

    @NotNull
    private static Method addMethodWithPhpDoc(@NotNull PhpClass clazz, @NotNull Function method, @NotNull String methodCode) {
        if (clazz == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(31);
        }
        if (method == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(32);
        }
        if (methodCode == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(33);
        }
        Method newMethod = PhpPsiElementFactory.createMethod(clazz.getProject(), methodCode);
        PsiElement insertedMethod = PhpCodeEditUtil.insertClassMemberWithPhpDoc(clazz, (PsiElement)newMethod, method.getDocComment());
        assert (insertedMethod instanceof Method);
        Method method2 = (Method)insertedMethod;
        if (method2 == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(34);
        }
        return method2;
    }

    public static <T extends Function> T resolvePhpDoc(final T method) {
        PhpDocComment doc = method.getDocComment();
        if (doc != null) {
            doc.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

                public void visitPhpDocType(PhpDocType type) {
                    PhpMoveClassMemberBase.resolveReferencesInDoc(type, method);
                }
            });
        }
        return method;
    }

    protected static <T extends Function> T refactorInternalStaticReferences(final @NotNull T method, final @Nullable PhpClass fromClass, final PhpClass targetClass, final List<PhpClassMember> members) {
        if (method == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(35);
        }
        method.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpFieldReference(@NotNull FieldReference fieldReference) {
                if (fieldReference == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.refactorInternalStaticReference((MemberReference)fieldReference);
            }

            public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
                this.refactorInternalStaticReference((MemberReference)constantReference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.refactorInternalStaticReference((MemberReference)reference);
                super.visitPhpMethodReference(reference);
            }

            public void visitPhpClassReference(ClassReference classReference) {
                2.refactorInternalClassReference(classReference);
            }

            public void visitPhpDocType(PhpDocType type) {
                PhpMoveClassMemberBase.resolveReferencesInDoc(type, method);
            }

            private static void refactorInternalClassReference(@NotNull ClassReference reference) {
                if (reference == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!(reference.getParent() instanceof MemberReference)) {
                    String newName;
                    PhpClass resolvedClass;
                    PsiElement element = reference.resolve();
                    String classReferenceName = reference.getName();
                    if (element != null && (resolvedClass = PhpPsiUtil.getParentOfClass(element, false, PhpClass.class)) != null && !(newName = resolvedClass.getName()).isEmpty() && classReferenceName != null && (classReferenceName.equalsIgnoreCase("parent") || classReferenceName.equalsIgnoreCase("self"))) {
                        reference.getElement().replace((PsiElement)PhpPsiElementFactory.createClassReference(reference.getProject(), newName));
                    }
                }
            }

            private void refactorInternalStaticReference(@NotNull MemberReference reference) {
                if (reference == null) {
                    2.$$$reportNull$$$0(2);
                }
                PhpExpression classReferenceExpression = reference.getClassReference();
                PsiElement resolvedMember = reference.resolve();
                if (classReferenceExpression != null && reference.isStatic()) {
                    PhpClass referencedClass;
                    PsiElement psiElement = resolvedMember = fromClass != null ? PhpMoveClassMemberBase.refactorClassKeywordReference(reference, resolvedMember, fromClass) : resolvedMember;
                    if (resolvedMember != null && (referencedClass = PhpMoveClassMemberBase.getContainingClass(resolvedMember)) != null && PhpMoveClassMemberBase.classReferenceShouldBeProcessed(referencedClass, classReferenceExpression.getName(), fromClass, targetClass) && resolvedMember != method) {
                        PsiElement classReferenceIdentifier = classReferenceExpression.getFirstChild();
                        classReferenceIdentifier.replace(PhpPsiElementFactory.createFromText(reference.getProject(), PhpTokenTypes.IDENTIFIER, PhpMoveClassMemberBase.newClassReferenceIdentifier(resolvedMember, referencedClass, fromClass, members)));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fieldReference";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPhpFieldReference";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "refactorInternalClassReference";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "refactorInternalStaticReference";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return method;
    }

    @NotNull
    private static String newClassReferenceIdentifier(PsiElement resolvedMember, PhpClass referencedClass, PhpClass fromClass, List<PhpClassMember> movedMembers) {
        if (movedMembers.contains(resolvedMember) && referencedClass == fromClass) {
            return "self";
        }
        String string = referencedClass.getName();
        if (string == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(36);
        }
        return string;
    }

    @Nullable
    private static PhpClass getContainingClass(PsiElement resolvedElement) {
        if (resolvedElement instanceof PhpClassMember) {
            return ((PhpClassMember)resolvedElement).getContainingClass();
        }
        if (resolvedElement instanceof PhpClass) {
            return (PhpClass)resolvedElement;
        }
        return null;
    }

    private static PsiElement refactorClassKeywordReference(MemberReference reference, PsiElement resolvedMember, PhpClass fromClass) {
        if (resolvedMember == null && PhpPsiUtil.isOfType(reference.getLastChild(), PhpTokenTypes.kwCLASS)) {
            PsiElement firstChild = reference.getFirstChild();
            String firstChildText = firstChild.getText();
            if (firstChildText.equalsIgnoreCase("self")) {
                resolvedMember = fromClass;
            }
            if (firstChildText.equalsIgnoreCase("parent")) {
                resolvedMember = fromClass.getSuperClass();
            }
        }
        return resolvedMember;
    }

    private static boolean classReferenceShouldBeProcessed(@Nullable PhpClass referencedClass, @Nullable String name, @Nullable PhpClass fromClass, PhpClass targetClass) {
        if (fromClass == null) {
            return false;
        }
        if (referencedClass != null) {
            return "parent".equalsIgnoreCase(name) || "self".equalsIgnoreCase(name) || referencedClass == fromClass || referencedClass == targetClass || PhpClassHierarchyUtils.isSuperClass((PhpClass)referencedClass, (PhpClass)fromClass, (boolean)true);
        }
        return true;
    }

    private static void resolveReferencesInDoc(PhpDocType type, Function method) {
        PhpClass fromClass = PhpPsiUtil.getParentOfClass((PsiElement)method, true, PhpClass.class);
        if (fromClass != null) {
            PhpDocType element;
            PhpClass parentClass = fromClass.getSuperClass();
            String fromClassName = fromClass.getName();
            String parentClassName = null;
            if (parentClass != null) {
                parentClassName = parentClass.getName();
            }
            Object object = element = type.getText().equalsIgnoreCase("$this") ? type : PhpPsiUtil.getChildOfType((PsiElement)type, PhpDocTokenTypes.DOC_IDENTIFIER);
            if (element != null) {
                if (element.getText().equalsIgnoreCase("self")) {
                    element.replace(PhpPsiElementFactory.createFromText(type.getProject(), PhpDocTokenTypes.DOC_IDENTIFIER, "/** " + fromClassName + "*/"));
                }
                if (element.getText().equalsIgnoreCase("parent") && parentClassName != null) {
                    element.replace(PhpPsiElementFactory.createFromText(type.getProject(), PhpDocTokenTypes.DOC_IDENTIFIER, "/** " + parentClassName + "*/"));
                }
                if (element.getText().equalsIgnoreCase("$this")) {
                    element.replace(PhpPsiElementFactory.createFromText(type.getProject(), PhpDocTokenTypes.DOC_IDENTIFIER, "/** " + fromClassName + "*/"));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8, 10, 19, 22, 25, 26, 27, 34, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase";
                break;
            }
            case 11: 
            case 21: 
            case 23: 
            case 24: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 12: 
            case 16: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentAccess";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationAccess";
                break;
            }
            case 15: 
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCode";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "move";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "cutAndMove";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeHolder";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "addMethodUp";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "addField";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "constructField";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "addMethodWithPhpDoc";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "newClassReferenceIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeMembers";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 34: 
            case 36: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cutAndMove";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getScopeHolder";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "moveField";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateMethodAccess";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addMethodUp";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addField";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValueText";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "constructField";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFieldTypeText";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFieldListElement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isSingleFieldList";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addMethodWithPhpDoc";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "refactorInternalStaticReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8, 10, 19, 22, 25, 26, 27, 34, 36 -> new IllegalStateException(string);
        };
    }

    private static class PhpMoveClassMemberToInterface
    extends PhpMoveClassMemberBase {
        private static final String DESTINATION_ACCESS = "public";

        PhpMoveClassMemberToInterface(PhpClass clazz, boolean shouldWeakAccess) {
            super(clazz, shouldWeakAccess);
        }

        @Override
        @NotNull
        protected Method moveMethod(@NotNull Method method, List<PhpClassMember> members) {
            if (method == null) {
                PhpMoveClassMemberToInterface.$$$reportNull$$$0(0);
            }
            String methodCode = PhpFunctionCodeGenerator.DECLARATION.generate((Function)method) + ";";
            PhpModifier.Access access = method.getAccess();
            String currentAccess = !this.myShouldWeakAccess || access.isPublic() ? null : StringUtil.toLowerCase((String)access.toString());
            Method declaration = PhpMoveClassMemberBase.addMethodUp(this.myTargetClass, method, methodCode, currentAccess, DESTINATION_ACCESS);
            if (currentAccess != null) {
                this.updateMethodAccess(method, currentAccess, DESTINATION_ACCESS);
            }
            Method method2 = declaration;
            if (method2 == null) {
                PhpMoveClassMemberToInterface.$$$reportNull$$$0(1);
            }
            return method2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase$PhpMoveClassMemberToInterface";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase$PhpMoveClassMemberToInterface";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "moveMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "moveMethod";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static final class PhpMoveClassMember
    extends PhpMoveClassMemberBase {
        private PhpMoveClassMember(PhpClass targetClass, boolean shouldWeakAccess, boolean moveConstantsAsEnum) {
            super(targetClass, shouldWeakAccess, moveConstantsAsEnum);
        }

        @Override
        @NotNull
        protected Method moveMethod(@NotNull Method method, List<PhpClassMember> members) {
            if (method == null) {
                PhpMoveClassMember.$$$reportNull$$$0(0);
            }
            PhpModifier.Access access = method.getAccess();
            String currentAccess = this.myShouldWeakAccess && access.isPrivate() ? StringUtil.toLowerCase((String)access.toString()) : null;
            PhpClass fromClass = PhpPsiUtil.getParentOfClass((PsiElement)method, true, PhpClass.class);
            PhpClass targetClass = this.myTargetClass;
            return PhpMoveClassMember.copyAsMethodToTargetClass((Function)method, currentAccess, fromClass, targetClass, members);
        }

        @NotNull
        public static Method copyAsMethodToTargetClass(@NotNull Function function, @Nullable String currentAccess, @Nullable PhpClass fromClass, PhpClass targetClass, List<PhpClassMember> members) {
            if (function == null) {
                PhpMoveClassMember.$$$reportNull$$$0(1);
            }
            function = PhpMoveClassMember.resolvePhpDoc(function);
            function = PhpMoveClassMember.refactorInternalStaticReferences(function, fromClass, targetClass, members);
            Method method = PhpMoveClassMemberBase.addMethodUp(targetClass, function, function.getText(), currentAccess, "protected");
            if (method == null) {
                PhpMoveClassMember.$$$reportNull$$$0(2);
            }
            return method;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase$PhpMoveClassMember";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase$PhpMoveClassMember";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyAsMethodToTargetClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "moveMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "copyAsMethodToTargetClass";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

