/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpMissingFieldTypeInspection;
import com.jetbrains.php.lang.intentions.PhpDeclareFieldIntention;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRefactoringUtil {
    private static final IElementType[] NON_EXTRACTABLE_EXPRESSION_TYPES = new IElementType[]{PhpElementTypes.HASH_ARRAY_ELEMENT};

    private PhpRefactoringUtil() {
    }

    public static boolean isExpression(@NotNull PsiElement element) {
        if (element == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PhpExpression)) {
            if (element instanceof Function) {
                return ((Function)element).isClosure();
            }
            return false;
        }
        if (element instanceof Variable && ((Variable)element).isDeclaration()) {
            return false;
        }
        return !(element instanceof ArrayIndex);
    }

    public static boolean canBeAssignmentValue(@NotNull PsiElement element) {
        if (element == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(1);
        }
        if (!PhpRefactoringUtil.isExpression(element)) {
            return false;
        }
        if (element instanceof ClassReference) {
            return !PhpLangUtil.isSelfReference((ClassReference)element);
        }
        return true;
    }

    public static boolean isEmbedVariableAllowed(@NotNull PhpIntroduceContext introduceContext) {
        if (introduceContext == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(2);
        }
        PsiElement physicalElement = introduceContext.getPhysicalElement();
        if (!introduceContext.isPhysical() && physicalElement instanceof StringLiteralExpression && PhpElementTypes.STRING.equals(physicalElement.getNode().getElementType())) {
            return physicalElement.getText().charAt(0) == '\"';
        }
        return false;
    }

    public static boolean isScalarExpressions(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(3);
        }
        if (!(expression instanceof PhpExpression)) {
            return false;
        }
        if (expression instanceof ArrayHashElement) {
            return false;
        }
        return PhpType.isScalar((PhpType)((PhpExpression)expression).getType(), (Project)expression.getProject());
    }

    public static boolean isReferenceFreeExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(4);
        }
        final boolean[] result = new boolean[]{true};
        expression.accept((PsiElementVisitor)new PhpElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PhpReference && !(element instanceof ConstantReference) && !(element instanceof ClassConstantReference)) {
                    result[0] = false;
                }
                if (result[0]) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/refactoring/PhpRefactoringUtil$1", "visitElement"));
            }
        });
        return result[0];
    }

    public static boolean containsLocalVariables(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(5);
        }
        final boolean[] result = new boolean[]{false};
        expression.accept((PsiElementVisitor)new PhpElementVisitor(){

            public void visitPhpVariable(Variable variable) {
                result[0] = true;
            }

            public void visitPhpFieldReference(FieldReference fieldReference) {
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!result[0]) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/refactoring/PhpRefactoringUtil$2", "visitElement"));
            }
        });
        return result[0];
    }

    public static String[] getPrefixesByReference(PhpReference reference) {
        if (reference instanceof MethodReference) {
            return PhpLangUtil.METHOD_PREFIXES;
        }
        if (reference instanceof FieldReference) {
            return PhpLangUtil.FIELD_PREFIXES;
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public static boolean isFunction(@NotNull PsiElement element) {
        if (element == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(6);
        }
        return element instanceof Function && !(element instanceof Method);
    }

    public static boolean isConstructor(@NotNull Method method) {
        PhpClass containingClass;
        if (method == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(7);
        }
        if ((containingClass = method.getContainingClass()) == null) {
            return false;
        }
        Method constructor = containingClass.getConstructor();
        if (constructor == null) {
            return false;
        }
        return method == constructor;
    }

    @NotNull
    public static String getParameterTypeDeclarationString(Parameter parameter) {
        PhpTypeDeclaration typeDeclaration = parameter.getTypeDeclaration();
        return typeDeclaration != null ? typeDeclaration.getText().trim() : "";
    }

    public static void initializeFieldsByParameters(@NotNull PhpClass clazz, @NotNull Collection<? extends Parameter> parameters, @NotNull PhpModifier.Access access) {
        if (clazz == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(8);
        }
        if (parameters == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(9);
        }
        if (access == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(10);
        }
        if (parameters.isEmpty()) {
            return;
        }
        Method constructor = clazz.getConstructor();
        Object groupStatement = PhpPsiUtil.getChildByCondition((PsiElement)constructor, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (groupStatement != null) {
            HashSet<String> fieldNames = new HashSet<String>();
            Collection fields = clazz.getFields();
            for (Field field : fields) {
                if (field.getModifier().isPrivate() && field.getContainingClass() != clazz) continue;
                fieldNames.add(field.getName());
            }
            Project project = clazz.getProject();
            for (Parameter parameter : parameters) {
                String parameterName = parameter.getName();
                if (!fieldNames.contains(parameterName)) {
                    PhpModifier modifier = PhpModifier.instance((PhpModifier.Access)access, (PhpModifier.Abstractness)PhpModifier.Abstractness.IMPLEMENTED, (PhpModifier.State)PhpModifier.State.DYNAMIC);
                    PhpType type = parameter.isVariadic() ? PhpType.ARRAY : parameter.getGlobalType();
                    PhpPsiElement field = PhpPsiElementFactory.createClassField(project, modifier, false, parameterName, null, PhpRefactoringUtil.createFieldTypeDeclaration(project, type, (PsiElement)clazz));
                    PhpDocComment comment = PhpDeclareFieldIntention.getDocComment(project, (PsiElement)field, clazz, type);
                    PhpCodeEditUtil.insertClassMemberWithPhpDoc(clazz, (PsiElement)field, comment);
                }
                AssignmentExpression assignmentExpression = PhpPsiElementFactory.createPhpPsiFromText(project, AssignmentExpression.class, "$this->" + parameterName + " = $" + parameterName + ";");
                PsiElement semicolon = assignmentExpression.getNextSibling();
                assert (semicolon != null);
                groupStatement.addRangeBefore((PsiElement)assignmentExpression, semicolon, groupStatement.getLastChild());
            }
        }
    }

    @Nullable
    public static String createFieldTypeDeclaration(@NotNull Project project, @Nullable PhpType type, @NotNull PsiElement scope) {
        if (project == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(12);
        }
        if (type == null || !PhpLanguageFeature.TYPED_PROPERTIES.isSupported(project)) {
            return null;
        }
        PhpType declaredType = PhpMissingFieldTypeInspection.composeFieldType(project, type.global(project), PhpType.EMPTY);
        return PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, declaredType, scope);
    }

    public static boolean isElementConstructor(@Nullable PsiElement element) {
        return element instanceof Method && ((Method)element).getMethodType(false) == Method.MethodType.CONSTRUCTOR;
    }

    public static boolean isExtractableExpression(PhpExpression expression) {
        return !PhpPsiUtil.isOfType((PsiElement)expression, NON_EXTRACTABLE_EXPRESSION_TYPES[0]);
    }

    @NotNull
    public static TextRange getVariableIdentifierRange(@NotNull TextRange range, @NotNull PsiElement element) {
        ASTNode node;
        if (range == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(13);
        }
        if (element == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(14);
        }
        if (element instanceof PhpNamedElement && (node = ((PhpNamedElement)element).getNameNode()) != null) {
            int offset = element.getTextRange().getStartOffset();
            TextRange nodeRange = node.getTextRange();
            assert (nodeRange.getStartOffset() >= offset);
            range = new TextRange(nodeRange.getStartOffset() - offset, nodeRange.getEndOffset() - offset);
        }
        if (element.getTextLength() > range.getStartOffset() && element.getText().charAt(range.getStartOffset()) == '$') {
            return new TextRange(range.getStartOffset() + 1, range.getEndOffset());
        }
        TextRange textRange = range;
        if (textRange == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(15);
        }
        return textRange;
    }

    @Nullable
    public static PsiReference getReferenceAtCaret(@NotNull PsiElement scope, @NotNull Editor editor) {
        int startOffset;
        TextRange textRange;
        if (scope == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(17);
        }
        int offset = editor.getCaretModel().getOffset();
        PsiFile editorFile = PsiDocumentManager.getInstance((Project)scope.getProject()).getPsiFile(editor.getDocument());
        PsiFile file = editorFile != null ? editorFile : scope.getContainingFile();
        PsiReference reference = file.findReferenceAt(offset);
        if (reference != null || offset == 0) {
            return reference;
        }
        PsiReference leftReference = file.findReferenceAt(offset - 1);
        if (leftReference != null && (textRange = leftReference.getRangeInElement()).shiftRight(startOffset = leftReference.getElement().getTextRange().getStartOffset()).containsOffset(offset)) {
            return leftReference;
        }
        return null;
    }

    public static void adjustCaretOffsetToIdentifierRange(@NotNull Editor editor, @NotNull PsiElement element, @NotNull TextRange range) {
        int offset;
        TextRange identifierRange;
        TextRange absoluteRange;
        if (editor == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(18);
        }
        if (element == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(19);
        }
        if (range == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(20);
        }
        if (!(absoluteRange = (identifierRange = PhpRefactoringUtil.getVariableIdentifierRange(range, element)).shiftRight(element.getTextRange().getStartOffset())).containsOffset(offset = editor.getCaretModel().getOffset())) {
            editor.getCaretModel().moveToOffset(absoluteRange.getStartOffset());
        }
    }

    @NotNull
    public static Statement wrapWithBraces(@NotNull Project project, @NotNull Statement statement) {
        if (project == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(21);
        }
        if (statement == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(22);
        }
        GroupStatement groupStatement = (GroupStatement)PhpPsiElementFactory.createStatement(project, "{}");
        groupStatement.addAfter((PsiElement)statement, groupStatement.getFirstChild());
        groupStatement = (GroupStatement)statement.replace((PsiElement)groupStatement);
        Statement statement2 = (Statement)groupStatement.statements().first();
        if (statement2 == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(23);
        }
        return statement2;
    }

    public static void removeReferenceFromExtendsList(ExtendsList extendsList, PhpClass toRemove) {
        List elements = extendsList.getReferenceElements();
        List<String> newExtendsList = elements.stream().filter(i -> !i.isReferenceTo((PsiElement)toRemove)).map(e -> e.getText()).toList();
        if (newExtendsList.isEmpty()) {
            extendsList.replace(PhpRefactoringUtil.createEmptyExtendsList(extendsList.getProject()));
        } else {
            extendsList.replace(PhpPsiElementFactory.createExtendsList(extendsList.getProject(), StringUtil.join(newExtendsList, (String)",")));
        }
    }

    public static void removeReferenceFromImplementsList(ImplementsList implementsList, PhpClass toRemove) {
        List elements = implementsList.getReferenceElements();
        List<String> newExtendsList = elements.stream().filter(i -> !i.isReferenceTo((PsiElement)toRemove)).map(e -> e.getText()).toList();
        if (newExtendsList.isEmpty()) {
            implementsList.replace(PhpRefactoringUtil.createEmptyImplementsList(implementsList.getProject()));
        } else {
            implementsList.replace(PhpPsiElementFactory.createImplementsList(implementsList.getProject(), StringUtil.join(newExtendsList, (String)",")));
        }
    }

    private static PsiElement createEmptyExtendsList(Project project) {
        return PhpPsiElementFactory.createPhpPsiFromText(project, ExtendsList.class, "class A {}");
    }

    private static PsiElement createEmptyImplementsList(Project project) {
        return PhpPsiElementFactory.createPhpPsiFromText(project, ImplementsList.class, "class A {}");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpRefactoringUtil";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpRefactoringUtil";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableIdentifierRange";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithBraces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isExpression";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canBeAssignmentValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEmbedVariableAllowed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isScalarExpressions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceFreeExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsLocalVariables";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFunction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isConstructor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initializeFieldsByParameters";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createFieldTypeDeclaration";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getVariableIdentifierRange";
                break;
            }
            case 15: 
            case 23: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAtCaret";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "adjustCaretOffsetToIdentifierRange";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithBraces";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 23 -> new IllegalStateException(string);
        };
    }
}

