/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.codesmells;

import com.jetbrains.php.refactoring.codesmells.Dependency;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DependencyMap<F, T> {
    public final Map<F, Dependency<T>> dependencyMap = new HashMap<F, Dependency<T>>();

    public void add(F from, T to) {
        Dependency<T> value = this.dependencyMap.get(from);
        if (value == null) {
            value = new Dependency();
        }
        value.add(to);
        this.dependencyMap.put(from, value);
    }

    public Dependency<T> getDependency(F source) {
        Dependency<T> dependency = this.dependencyMap.get(source);
        return Objects.requireNonNullElseGet(dependency, () -> Dependency.EMPTY_DEPENDENCY);
    }
}

