/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractClass.ui;

import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.refactoring.ui.PhpCodeComponentsFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassSignaturePreview
extends EditorTextField {
    public PhpClassSignaturePreview(String signature, Project project, FileType filetype) {
        super(PhpClassSignaturePreview.createNonUndoableDocument(signature), project, filetype, true, false);
        this.setFont(EditorFontType.PLAIN.getGlobalFont());
        this.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.CARET_ROW_COLOR));
    }

    private static Document createNonUndoableDocument(String text) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text);
        UndoUtil.disableUndoFor((Document)document);
        return document;
    }

    public void setSignature(String signature) {
        this.setText(signature);
        EditorEx editor = (EditorEx)this.getEditor();
        if (editor != null) {
            editor.getScrollingModel().scrollVertically(0);
            editor.getScrollingModel().scrollHorizontally(0);
        }
    }

    @NotNull
    protected EditorEx createEditor() {
        EditorEx editor = super.createEditor();
        editor.setHorizontalScrollbarVisible(true);
        editor.setVerticalScrollbarVisible(true);
        EditorEx editorEx = PhpCodeComponentsFactory.setPhpCodeFragmentHighlighter(editor);
        if (editorEx == null) {
            PhpClassSignaturePreview.$$$reportNull$$$0(0);
        }
        return editorEx;
    }

    @Nullable
    protected String getFileName() {
        return "dummy." + PhpFileType.INSTANCE.getDefaultExtension();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/extractClass/ui/PhpClassSignaturePreview", "createEditor"));
    }
}

