/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.core.CoreBundle;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpArrayAccessTypeAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFieldNamesAssignedByTheConstructorIndex;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.introduce.PhpBaseInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBasePresenter;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseSettings;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceRefactoringHandler;
import com.jetbrains.php.util.PhpTrimRendererVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpIntroduceBaseHandler<S extends PhpIntroduceBaseSettings, P extends PhpIntroduceBasePresenter<?, S, ?>>
implements RefactoringActionHandler,
PhpIntroduceRefactoringHandler<S> {
    protected static final Logger LOG = Logger.getInstance(PhpIntroduceBaseHandler.class);
    public static PhpWithoutSideEffectsReplaceChoice WITHOUT_SIDE_EFFECTS_REPLACE_CHOICE = new PhpWithoutSideEffectsReplaceChoice();

    @NotNull
    protected static PsiElement findContext(PsiElement element) {
        PsiElement parent = element.getParent();
        while (!PhpIntroduceBaseHandler.isContext(parent)) {
            parent = parent.getParent();
        }
        if (parent instanceof Constant && PhpPsiUtil.isOfType(parent, (IElementType)PhpStubElementTypes.DEFINE)) {
            parent = parent.getParent();
            while (!PhpIntroduceBaseHandler.isContext(parent)) {
                parent = parent.getParent();
            }
        }
        PsiElement psiElement = parent;
        if (psiElement == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    private static boolean isContext(@Nullable PsiElement element) {
        if (element instanceof Constant) {
            return true;
        }
        return element instanceof Parameter || element instanceof Function || element instanceof PhpFile || element instanceof Field;
    }

    private static boolean isSingleQuotedString(@Nullable IElementType startElementType, @Nullable IElementType endElementType) {
        return !(!PhpTokenTypes.chLSINGLE_QUOTE.equals(startElementType) && !PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE.equals(startElementType) || !PhpTokenTypes.chRSINGLE_QUOTE.equals(endElementType) && !PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE.equals(endElementType));
    }

    private static boolean isDoubleQuotedString(@Nullable IElementType startElementType, @Nullable IElementType endElementType) {
        return !(!PhpTokenTypes.chLDOUBLE_QUOTE.equals(startElementType) && !PhpTokenTypes.STRING_LITERAL.equals(startElementType) || !PhpTokenTypes.chRDOUBLE_QUOTE.equals(endElementType) && !PhpTokenTypes.STRING_LITERAL.equals(endElementType));
    }

    private static boolean isSkipStartElement(@Nullable PsiElement startElement) {
        return startElement instanceof PsiWhiteSpace;
    }

    private static boolean isSkipEndElement(@Nullable PsiElement endElement) {
        return endElement instanceof PsiWhiteSpace || PhpPsiUtil.isOfType(endElement, PhpTokenTypes.opSEMICOLON);
    }

    @Nullable
    private static PhpPsiElement findIntroducibleElementAtRange(PsiFile file, int startOffset, int endOffset) {
        PhpPsiElement element = (PhpPsiElement)PhpPsiUtil.findElementOfClassAtRange(file, startOffset, endOffset, PhpExpression.class, true, true);
        if (element == null) {
            element = (PhpPsiElement)PhpPsiUtil.findElementOfClassAtRange(file, startOffset, endOffset, Function.class, true, true);
        }
        if (!(element == null || element.getTextRange().getEndOffset() == endOffset && PhpRefactoringUtil.canBeAssignmentValue((PsiElement)element))) {
            element = null;
        }
        return element;
    }

    @Nullable
    private static PhpPsiElement extractFromBinaryExpression(PsiFile file, int startOffset, int endOffset) {
        String selectedText = file.getText().substring(startOffset, endOffset);
        BinaryExpression selectedExpression = (BinaryExpression)PhpPsiElementFactory.createPhpPsiFromText(file.getProject(), PhpElementTypes.BINARY_EXPRESSIONS, selectedText);
        if (selectedExpression == null) {
            return null;
        }
        if (selectedExpression.getTextLength() != endOffset - startOffset) {
            return null;
        }
        if (PsiTreeUtil.hasErrorElements((PsiElement)selectedExpression)) {
            return null;
        }
        return selectedExpression;
    }

    @Nullable
    private static PhpPsiElement extractFromDoubleQuotedString(PsiFile file, StringLiteralExpression context, int startOffset, int endOffset) {
        PhpPsiElement selectedExpression;
        TextRange fullRange = context.getTextRange();
        Object selectedText = file.getText().substring(startOffset, endOffset);
        if (fullRange.getStartOffset() != startOffset) {
            selectedText = "\"" + (String)selectedText;
        }
        if (fullRange.getEndOffset() != endOffset) {
            selectedText = (String)selectedText + "\"";
        }
        if (PsiTreeUtil.hasErrorElements((PsiElement)(selectedExpression = PhpPsiElementFactory.createPhpPsiFromText(file.getProject(), PhpElementTypes.STRING, (String)selectedText)))) {
            return null;
        }
        return selectedExpression;
    }

    @Nullable
    private static PhpPsiElement extractFromSingleQuotedString(PsiFile file, StringLiteralExpression context, int startOffset, int endOffset) {
        StringLiteralExpression selectedExpression;
        TextRange fullRange = context.getTextRange();
        Object selectedText = file.getText().substring(startOffset, endOffset);
        if (fullRange.getStartOffset() != startOffset) {
            selectedText = "'" + (String)selectedText;
        }
        if (fullRange.getEndOffset() != endOffset) {
            selectedText = (String)selectedText + "'";
        }
        if (PsiTreeUtil.hasErrorElements((PsiElement)(selectedExpression = (StringLiteralExpression)PhpPsiElementFactory.createPhpPsiFromText(file.getProject(), PhpElementTypes.STRING, (String)selectedText)))) {
            return null;
        }
        return selectedExpression;
    }

    @Nullable
    private static PhpPsiElement extractFromHeredoc(PsiFile file, int startOffset, int endOffset) {
        String selectedText = file.getText().substring(startOffset, endOffset);
        PhpPsiElement selectedExpression = PhpPsiElementFactory.createPhpPsiFromText(file.getProject(), PhpElementTypes.STRING, "\"" + StringUtil.escapeQuotes((String)selectedText) + "\"");
        if (PsiTreeUtil.hasErrorElements((PsiElement)selectedExpression)) {
            return null;
        }
        return selectedExpression;
    }

    @NotNull
    protected static ArrayList<RangeHighlighter> highlightOccurrences(PhpIntroduceContext introduceContext) {
        StatusBar bar;
        Project project = introduceContext.getProject();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        ArrayList<RangeHighlighter> result = new ArrayList<RangeHighlighter>();
        if (introduceContext.isPhysical()) {
            highlightManager.addOccurrenceHighlights(introduceContext.getEditor(), new PsiElement[]{introduceContext.getPhysicalElement()}, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, result);
        } else {
            TextRange range = introduceContext.getLogicalElementRange();
            highlightManager.addRangeHighlight(introduceContext.getEditor(), range.getStartOffset(), range.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, true, result);
        }
        if (!introduceContext.getOccurrences((OccurrencesChooser.BaseReplaceChoice)OccurrencesChooser.ReplaceChoice.ALL).isEmpty()) {
            highlightManager.addOccurrenceHighlights(introduceContext.getEditor(), PsiUtilCore.toPsiElementArray(introduceContext.getOccurrences((OccurrencesChooser.BaseReplaceChoice)OccurrencesChooser.ReplaceChoice.ALL)), EditorColors.SEARCH_RESULT_ATTRIBUTES, true, result);
        }
        if ((bar = WindowManager.getInstance().getStatusBar(project)) != null) {
            bar.setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
        }
        ArrayList<RangeHighlighter> arrayList = result;
        if (arrayList == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    protected static PhpPsiElement insertIntoBinaryExpression(BinaryExpression binaryExpression, TextRange insertionRange, String insertionText) {
        TextRange referencePointRange = binaryExpression.getTextRange();
        String referencePointText = binaryExpression.getText();
        int expressionRelativeStart = insertionRange.getStartOffset() - referencePointRange.getStartOffset();
        int expressionRelativeEnd = insertionRange.getEndOffset() - referencePointRange.getStartOffset();
        String expression = referencePointText.substring(0, expressionRelativeStart) + insertionText + referencePointText.substring(expressionRelativeEnd);
        return PhpPsiElementFactory.createPhpPsiFromText(binaryExpression.getProject(), PhpElementTypes.BINARY_EXPRESSIONS, expression);
    }

    protected static PhpPsiElement insertIntoHeredoc(StringLiteralExpression heredocExpression, TextRange embeddingRange, String embeddingText) {
        TextRange referencePointRange = heredocExpression.getTextRange();
        String referencePointText = heredocExpression.getText();
        int expressionRelativeStart = embeddingRange.getStartOffset() - referencePointRange.getStartOffset();
        int expressionRelativeEnd = embeddingRange.getEndOffset() - referencePointRange.getStartOffset();
        String expression = referencePointText.substring(0, expressionRelativeStart) + "{" + embeddingText + "}" + referencePointText.substring(expressionRelativeEnd);
        return (PhpPsiElement)PhpPsiElementFactory.createFromText(heredocExpression.getProject(), PhpElementTypes.HEREDOC, expression);
    }

    protected static PhpPsiElement insertIntoStringByConcatenation(StringLiteralExpression stringExpression, TextRange insertionRange, String insertionText) {
        TextRange referencePointRange = stringExpression.getTextRange();
        String referencePointText = stringExpression.getText();
        int expressionRelativeStart = insertionRange.getStartOffset() - referencePointRange.getStartOffset();
        int expressionRelativeEnd = insertionRange.getEndOffset() - referencePointRange.getStartOffset();
        StringBuilder expressionBuilder = new StringBuilder();
        char quote = stringExpression.getText().charAt(0);
        if (expressionRelativeStart > 0) {
            String expressionTextStart = referencePointText.substring(0, expressionRelativeStart);
            if (expressionTextStart.endsWith("\\") && !expressionTextStart.endsWith("\\\\")) {
                expressionBuilder.append(expressionTextStart).append("\\").append(quote).append(".");
            } else {
                expressionBuilder.append(expressionTextStart).append(quote).append(".");
            }
        }
        expressionBuilder.append(insertionText);
        if (referencePointText.length() - expressionRelativeEnd > 0) {
            expressionBuilder.append(".").append(quote).append(referencePointText.substring(expressionRelativeEnd));
        }
        return PhpPsiElementFactory.createPhpPsiFromText(stringExpression.getProject(), PhpElementTypes.CONCATENATION_EXPRESSION, expressionBuilder.toString());
    }

    protected static PhpPsiElement insertIntoStringByEmbeding(StringLiteralExpression stringExpression, TextRange embeddingRange, String embeddingText) {
        TextRange referencePointRange = stringExpression.getTextRange();
        String referencePointText = stringExpression.getText();
        int expressionRelativeStart = embeddingRange.getStartOffset() - referencePointRange.getStartOffset();
        int expressionRelativeEnd = embeddingRange.getEndOffset() - referencePointRange.getStartOffset();
        StringBuilder expressionBuilder = new StringBuilder();
        if (expressionRelativeStart > 1) {
            expressionBuilder.append(referencePointText, 0, expressionRelativeStart);
        } else {
            expressionBuilder.append("\"");
        }
        expressionBuilder.append("{");
        expressionBuilder.append(embeddingText);
        expressionBuilder.append("}");
        if (referencePointText.length() - expressionRelativeEnd > 1) {
            expressionBuilder.append(referencePointText.substring(expressionRelativeEnd));
        } else {
            expressionBuilder.append("\"");
        }
        return PhpPsiElementFactory.createPhpPsiFromText(stringExpression.getProject(), PhpElementTypes.STRING, expressionBuilder.toString());
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(3);
        }
        throw new RuntimeException("Not implemented");
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, DataContext dataContext) {
        if (project == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(5);
        }
        if (file == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(6);
        }
        try {
            this.invoke(project, editor, file);
        }
        catch (RefactoringErrorException e) {
            this.showErrorHint(project, editor, e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invoke(final @NotNull Project project, final @NotNull Editor editor, @NotNull PsiFile file) throws RefactoringErrorException {
        if (project == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(8);
        }
        if (file == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(9);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            this.showErrorHint(project, editor, CoreBundle.message((String)"editing.read.only.file.hint", (Object[])new Object[0]));
            return;
        }
        PhpIntroduceContext introduceContext = this.findIntroduceContext(editor, file);
        if (introduceContext == null) {
            throw new RefactoringErrorException(PhpBundle.message("refactoring.extract.base.handler.no.expression.selected", new Object[0]));
        }
        if (editor.getSelectionModel().hasSelection()) {
            if (!this.isSupported(introduceContext.getPhysicalElement())) throw new RefactoringErrorException(PhpBundle.message("refactoring.extract.base.handler.not.supported.expression", this.getRefactoringName()));
            this.invoke(introduceContext);
            return;
        } else {
            List<PsiElement> collectedExpressions = this.collectIntroducibleElements(introduceContext);
            if (collectedExpressions.size() == 1) {
                this.invoke(this.getIntroduceContext(editor, collectedExpressions.get(0)));
                return;
            } else {
                if (collectedExpressions.isEmpty()) {
                    throw new RefactoringErrorException(PhpBundle.message("refactoring.extract.base.handler.not.supported.expression", this.getRefactoringName()));
                }
                this.showChooser(editor, collectedExpressions, new Pass<PsiElement>(){

                    public void pass(PsiElement phpExpression) {
                        try {
                            PhpIntroduceBaseHandler.this.invoke(PhpIntroduceBaseHandler.this.getIntroduceContext(editor, phpExpression));
                        }
                        catch (RefactoringErrorException e) {
                            PhpIntroduceBaseHandler.this.showErrorHint(project, editor, e.getMessage());
                        }
                    }
                });
            }
        }
    }

    @Nullable
    public PhpIntroduceContext findIntroduceContext(@NotNull Editor editor, @NotNull PsiFile file) throws RefactoringErrorException {
        if (editor == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(10);
        }
        if (file == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(11);
        }
        PhpIntroduceContext introduceContext = null;
        if (!editor.getSelectionModel().hasSelection() && (introduceContext = this.findIntroduceContextByCaret(editor, file, editor.getCaretModel().getOffset())) == null) {
            editor.getSelectionModel().selectLineAtCaret();
        }
        if (editor.getSelectionModel().hasSelection() && (introduceContext = this.findIntroduceContextBySelection(editor, file, editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd())) != null) {
            TextRange selectionRange = introduceContext.isPhysical() ? introduceContext.getPhysicalElementRange() : introduceContext.getLogicalElementRange();
            editor.getSelectionModel().setSelection(selectionRange.getStartOffset(), selectionRange.getEndOffset());
        }
        return introduceContext;
    }

    public void invoke(@NotNull PhpIntroduceContext introduceContext) {
        if (introduceContext == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(12);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            assert (this.canPerformInplaceIntroduce(introduceContext));
            this.performInplaceIntroduce(introduceContext, (OccurrencesChooser.BaseReplaceChoice)OccurrencesChooser.ReplaceChoice.NO);
            return;
        }
        this.doInvoke(introduceContext);
    }

    protected void doInvoke(@NotNull PhpIntroduceContext introduceContext) {
        String featureId;
        if (introduceContext == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(13);
        }
        if ((featureId = this.getFeatureId()) != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(featureId);
        }
        PsiDocumentManager.getInstance((Project)introduceContext.getProject()).commitAllDocuments();
        if (!ApplicationManager.getApplication().isUnitTestMode() && introduceContext.getEditor().getSettings().isVariableInplaceRenameEnabled() && this.canPerformInplaceIntroduce(introduceContext) && !IntentionPreviewUtils.isPreviewElement((PsiElement)introduceContext.getPhysicalElement())) {
            this.performInplaceIntroduce(introduceContext);
            return;
        }
        this.chooseTargetBlockAndPerformIntroduce(introduceContext, updatedContext -> this.performIntroduceWithDialog((PhpIntroduceContext)updatedContext));
    }

    public void performIntroduceWithDialog(@NotNull PhpIntroduceContext introduceContext) {
        if (introduceContext == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(14);
        }
        ArrayList<RangeHighlighter> highlighters = PhpIntroduceBaseHandler.highlightOccurrences(introduceContext);
        P presenter = this.getPresenter(introduceContext);
        ((PhpIntroduceBasePresenter)presenter).show();
        for (RangeHighlighter highlighter : highlighters) {
            HighlightManager.getInstance((Project)introduceContext.getProject()).removeSegmentHighlighter(introduceContext.getEditor(), highlighter);
        }
        if (!((PhpIntroduceBasePresenter)presenter).isOkExit()) {
            return;
        }
        Object settings = ((PhpIntroduceBasePresenter)presenter).getSettings();
        if (settings == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)introduceContext.getProject()).withName(this.getRefactoringName()).run(() -> this.doRefactoring(introduceContext, settings));
    }

    private void performInplaceIntroduce(@NotNull PhpIntroduceContext context) {
        if (context == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(15);
        }
        if (!context.isToReplaceSourceElement() && context.getOccurrencesCount() > 1) {
            OccurrencesChooser.simpleChooser((Editor)context.getEditor()).showChooser(PhpIntroduceBaseHandler.getOccurrencesMap(context), RefactoringBundle.message((String)"replace.multiple.occurrences.found"), choice -> this.chooseTargetBlockAndPerformIntroduce(context, updatedContext -> this.performInplaceIntroduce((PhpIntroduceContext)updatedContext, (OccurrencesChooser.BaseReplaceChoice)choice)));
        } else {
            this.chooseTargetBlockAndPerformIntroduce(context, updatedContext -> this.performInplaceIntroduce((PhpIntroduceContext)updatedContext, (OccurrencesChooser.BaseReplaceChoice)(updatedContext.isToReplaceSourceElement() ? OccurrencesChooser.ReplaceChoice.ALL : OccurrencesChooser.ReplaceChoice.NO)));
        }
    }

    @NotNull
    private static Map<OccurrencesChooser.BaseReplaceChoice, List<PsiElement>> getOccurrencesMap(@NotNull PhpIntroduceContext context) {
        if (context == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(16);
        }
        LinkedHashMap<OccurrencesChooser.BaseReplaceChoice, List<PsiElement>> occurrencesMap = new LinkedHashMap<OccurrencesChooser.BaseReplaceChoice, List<PsiElement>>();
        occurrencesMap.put((OccurrencesChooser.BaseReplaceChoice)OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(context.getLogicalElement()));
        SmartList allOccurrences = new SmartList((Object[])context.getOccurrencesWithLogicalElement());
        occurrencesMap.put((OccurrencesChooser.BaseReplaceChoice)OccurrencesChooser.ReplaceChoice.ALL, (List<PsiElement>)allOccurrences);
        Collection<PsiElement> nonModifyingElementOccurrences = context.getNonModifyingElementOccurrences();
        if (nonModifyingElementOccurrences.size() != allOccurrences.size()) {
            occurrencesMap.put(WITHOUT_SIDE_EFFECTS_REPLACE_CHOICE, (List<PsiElement>)new SmartList(nonModifyingElementOccurrences));
        }
        LinkedHashMap<OccurrencesChooser.BaseReplaceChoice, List<PsiElement>> linkedHashMap = occurrencesMap;
        if (linkedHashMap == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(17);
        }
        return linkedHashMap;
    }

    protected void chooseTargetBlockAndPerformIntroduce(PhpIntroduceContext introduceContext, Consumer<PhpIntroduceContext> performIntroduceCallback) {
        performIntroduceCallback.accept(introduceContext);
    }

    public void performInplaceIntroduce(PhpIntroduceContext context, OccurrencesChooser.BaseReplaceChoice choice) {
        this.getInplaceIntroducer(context, this.getInplaceIntroduceSettings(context, choice)).startInplaceIntroduceTemplate();
    }

    @NotNull
    protected abstract PhpBaseInplaceIntroducer<? extends PhpNamedElement, S> getInplaceIntroducer(@NotNull PhpIntroduceContext var1, @NotNull S var2);

    @NotNull
    protected abstract S getInplaceIntroduceSettings(@NotNull PhpIntroduceContext var1, OccurrencesChooser.BaseReplaceChoice var2);

    protected abstract boolean canPerformInplaceIntroduce(@NotNull PhpIntroduceContext var1);

    @Nullable
    protected String getFeatureId() {
        return null;
    }

    @Nls
    public abstract String getRefactoringName();

    @NotNull
    protected abstract P getPresenter(PhpIntroduceContext var1);

    private boolean isSupported(@NotNull PsiElement expression) {
        PhpPsiElement assignedValue;
        PhpPsiElement variable;
        AssignmentExpression assignmentExpression;
        PhpReturnType returnType;
        PsiElement parent;
        if (expression == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(18);
        }
        if ((parent = expression.getParent().getParent()) instanceof Function && (returnType = (PhpReturnType)((Function)parent).getTypeDeclaration()) != null && returnType.getClassReferences().stream().anyMatch(r -> r == expression)) {
            return false;
        }
        if (expression instanceof ArrayAccessExpression && (assignmentExpression = PhpPsiUtil.getParentOfClass(expression, false, AssignmentExpression.class)) != null && (variable = assignmentExpression.getVariable()) != null && variable.getTextRange().contains(expression.getTextRange())) {
            return false;
        }
        if (expression.getChildren().length == 1 && expression.getFirstChild() instanceof PhpExpression && expression.getTextRange().equals((Object)expression.getFirstChild().getTextRange())) {
            return false;
        }
        MultiassignmentExpression multiassignment = PhpPsiUtil.getParentOfClass(expression, false, MultiassignmentExpression.class);
        if (multiassignment != null && (assignedValue = multiassignment.getValue()) != null && !assignedValue.getTextRange().contains(expression.getTextRange().getStartOffset())) {
            return false;
        }
        if (expression instanceof AssignmentExpression) {
            return false;
        }
        if (expression instanceof Function && ((Function)expression).isClosure()) {
            return false;
        }
        if (expression instanceof PhpDocType || PhpPsiUtil.isOfType(expression.getParent(), (IElementType)PhpDocElementTypes.phpDocMethodType)) {
            return false;
        }
        return this.isSupportedExpression(expression);
    }

    protected abstract boolean isSupportedExpression(@NotNull PsiElement var1);

    protected abstract boolean isSupportedScope(@Nullable PsiElement var1, @NotNull PsiElement var2);

    protected abstract boolean isSupportedContext(@NotNull PsiElement var1, @NotNull PsiElement var2, PsiElement var3);

    @Nullable
    public PhpIntroduceResult doRefactoring(@NotNull PhpIntroduceContext introduceContext, @NotNull S settings) {
        Editor editor;
        if (introduceContext == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(19);
        }
        if (settings == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(20);
        }
        if ((editor = introduceContext.getEditor()) != null && editor.getSelectionModel().hasSelection()) {
            editor.getSelectionModel().removeSelection();
        }
        return null;
    }

    @Nullable
    protected abstract PsiElement findScope(@NotNull PsiElement var1);

    @NotNull
    public PhpIntroduceContext getIntroduceContext(Editor editor, PsiElement element) throws RefactoringErrorException {
        if (element instanceof ParenthesizedExpression) {
            PhpPsiElement unparenthesized = ((ParenthesizedExpression)element).extract();
            if (unparenthesized == null) {
                throw new RefactoringErrorException(PhpBundle.message("refactoring.common.not.supported.expression.in.scope", this.getRefactoringName()));
            }
            return this.getIntroduceContext(editor, element, (PsiElement)unparenthesized, unparenthesized.getTextRange());
        }
        return this.getIntroduceContext(editor, element, element, element.getTextRange());
    }

    @NotNull
    private PhpIntroduceContext getIntroduceContext(Editor editor, @NotNull PsiElement physicalElement, @NotNull PsiElement logicalElement, @NotNull TextRange elementRange) throws RefactoringErrorException {
        PsiElement scope;
        if (physicalElement == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(21);
        }
        if (logicalElement == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(22);
        }
        if (elementRange == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(23);
        }
        if ((scope = this.findScope(physicalElement)) == null) {
            throw new RefactoringErrorException(PhpBundle.message("refactoring.extract.base.handler.not.supported.scope", this.getRefactoringName()));
        }
        if (!this.isSupportedScope(scope, logicalElement)) {
            throw new RefactoringErrorException(PhpBundle.message("refactoring.common.not.supported.expression.in.scope", this.getRefactoringName()));
        }
        PsiElement context = PhpIntroduceBaseHandler.findContext(physicalElement);
        if (!this.isSupportedContext(context, logicalElement, physicalElement)) {
            throw new RefactoringErrorException(PhpBundle.message("refactoring.common.not.supported.context", this.getRefactoringName()));
        }
        PhpIntroduceContext introduceContext = new PhpIntroduceContext(editor, physicalElement, logicalElement, elementRange, scope, context, physicalElement.getContainingFile(), this.replaceSourceElementIfPossible());
        Collection<PsiElement> occurrences = this.getOccurrences(scope, logicalElement, introduceContext.isPhysical(), context, elementRange, introduceContext);
        introduceContext.setOccurrences(occurrences);
        introduceContext.setNonModifyingElementOccurrences(this.filterOccurrencesWithDifferentDependencies(introduceContext));
        PhpIntroduceContext phpIntroduceContext = introduceContext;
        if (phpIntroduceContext == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(24);
        }
        return phpIntroduceContext;
    }

    @NotNull
    private Collection<PsiElement> filterOccurrencesWithDifferentDependencies(@NotNull PhpIntroduceContext introduceContext) {
        if (introduceContext == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(25);
        }
        PsiElement logicalElement = introduceContext.getLogicalElement();
        Collection<PsiElement> occurrences = introduceContext.getOccurrences((OccurrencesChooser.BaseReplaceChoice)OccurrencesChooser.ReplaceChoice.ALL);
        Collection<PhpPsiElement> dependencies = PhpIntroduceBaseHandler.findDependencies(logicalElement);
        if (occurrences.isEmpty() || dependencies.isEmpty()) {
            Collection<PsiElement> collection = occurrences;
            if (collection == null) {
                PhpIntroduceBaseHandler.$$$reportNull$$$0(26);
            }
            return collection;
        }
        boolean hasDependencyWithSideEffects = StreamEx.of(dependencies).select(FunctionReference.class).anyMatch(call -> PhpSideEffectDetector.canContainSideEffect((PsiElement)call));
        if (hasDependencyWithSideEffects) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PhpIntroduceBaseHandler.$$$reportNull$$$0(27);
            }
            return list;
        }
        Collection<PhpInstruction> dependenciesChanges = this.getDependenciesChanges(dependencies, false);
        ArrayList<PsiElement> filteredOccurrences = new ArrayList<PsiElement>();
        for (PsiElement occurrence : occurrences) {
            Collection occurrencesDependenciesChanges;
            Collection<PhpPsiElement> occurrenceDependencies = PhpIntroduceBaseHandler.findDependencies(occurrence);
            if (dependencies.size() != occurrenceDependencies.size() || !dependenciesChanges.equals(occurrencesDependenciesChanges = (Collection)this.getDependenciesChanges(occurrenceDependencies, true).stream().filter(accessVariableInstruction -> !PhpIntroduceBaseHandler.accessRangeContainsElement(accessVariableInstruction, logicalElement)).collect(Collectors.toSet())) || ContainerUtil.exists((Iterable)occurrencesDependenciesChanges, depChange -> PhpIntroduceBaseHandler.accessRangeContainsElement(depChange, occurrence))) continue;
            filteredOccurrences.add(occurrence);
        }
        ArrayList<PsiElement> arrayList = filteredOccurrences;
        if (arrayList == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<PhpPsiElement> findDependencies(@NotNull PsiElement logicalElement) {
        if (logicalElement == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(29);
        }
        Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)logicalElement, (boolean)false, (Class[])new Class[]{Variable.class, FieldReference.class, FunctionReference.class, ArrayAccessExpression.class});
        if (collection == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(30);
        }
        return collection;
    }

    private static boolean accessRangeContainsElement(@NotNull PhpInstruction accessInstruction, @NotNull PsiElement element) {
        if (accessInstruction == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(31);
        }
        if (element == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(32);
        }
        TextRange instructionRange = Objects.requireNonNull(accessInstruction.getAnchor()).getTextRange();
        return instructionRange.contains(element.getTextRange().getStartOffset());
    }

    private Collection<PhpInstruction> getDependenciesChanges(Collection<PhpPsiElement> dependencies, boolean visitSelf) {
        final HashSet<PhpInstruction> changeInstructions = new HashSet<PhpInstruction>();
        for (PhpPsiElement dependency : dependencies) {
            final PhpAccessInstruction dependencyAccess = PhpControlFlowUtil.getAccessInstruction(dependency, PhpAccessInstruction.class);
            if (dependencyAccess == null) continue;
            final PhpAccessVariableInstruction variableDependencyAccess = (PhpAccessVariableInstruction)ObjectUtils.tryCast((Object)dependencyAccess, PhpAccessVariableInstruction.class);
            PhpControlFlowUtil.processPredecessors((PhpInstruction)dependencyAccess, visitSelf, new PhpInstructionProcessor(this){

                public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                    CharSequence variableName;
                    FieldReference fieldReference;
                    FunctionReference reference = instruction.getFunctionReference();
                    if (dependencyAccess instanceof PhpAccessFieldByVariableInstruction && (fieldReference = ((PhpAccessFieldByVariableInstruction)dependencyAccess).getFieldReference()) != null && (variableName = ((PhpAccessFieldByVariableInstruction)dependencyAccess).getVariableName()) != null && PhpFieldNamesAssignedByTheConstructorIndex.canAffectTheInstanceStateByVariableName(instruction, variableName) && PhpSideEffectDetector.canContainSideEffect((PsiElement)reference)) {
                        changeInstructions.add(instruction);
                        return true;
                    }
                    return super.processPhpCallInstruction(instruction);
                }

                public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                    if (dependencyAccess instanceof PhpAccessFieldByVariableInstruction && instruction.isSameFieldReference((PhpAccessFieldByVariableInstruction)dependencyAccess)) {
                        return this.processDependencyAccess((PhpAccessInstruction)instruction);
                    }
                    return super.processAccessFieldByVariableInstruction(instruction);
                }

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    CharSequence name;
                    if (variableDependencyAccess != null && PhpLangUtil.equalsVariableNames(variableDependencyAccess.getVariableName(), instruction.getVariableName())) {
                        return this.processDependencyAccess((PhpAccessInstruction)instruction);
                    }
                    if (dependencyAccess instanceof PhpAccessFieldByVariableInstruction && (name = ((PhpAccessFieldByVariableInstruction)dependencyAccess).getVariableName()) != null && PhpFieldNamesAssignedByTheConstructorIndex.isSameInstanceReference((PsiElement)instruction.getAnchor(), name) && PhpPsiUtil.getParentByCondition((PsiElement)instruction.getAnchor(), true, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpElementTypes.CLOSURE))) != null) {
                        changeInstructions.add(instruction);
                        return true;
                    }
                    return super.processAccessVariableInstruction(instruction);
                }

                public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                    if (dependencyAccess instanceof PhpArrayAccessInstruction && 2.sameArrayAccesses((PhpArrayAccessInstruction)dependencyAccess, instruction)) {
                        return this.processDependencyAccess((PhpAccessInstruction)instruction);
                    }
                    return super.processArrayAccessInstruction(instruction);
                }

                private static boolean sameArrayAccesses(PhpArrayAccessInstruction dependencyAccess2, PhpArrayAccessInstruction instruction) {
                    return PhpLangUtil.equalsVariableNames(dependencyAccess2.getVariableName(), instruction.getVariableName()) && PhpArrayAccessTypeAnalyzer.sameArrayKeys(dependencyAccess2.getKey(), instruction.getKey());
                }

                private boolean processDependencyAccess(PhpAccessInstruction instruction) {
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    if (access.isRead() || access.isLightRead()) {
                        return true;
                    }
                    changeInstructions.add(instruction);
                    return true;
                }
            });
        }
        return changeInstructions;
    }

    protected boolean replaceSourceElementIfPossible() {
        return false;
    }

    protected abstract Collection<PsiElement> getOccurrences(@NotNull PsiElement var1, @NotNull PsiElement var2, boolean var3, @NotNull PsiElement var4, @NotNull TextRange var5, @NotNull PhpIntroduceContext var6);

    @NotNull
    protected List<PsiElement> collectIntroducibleElements(PhpIntroduceContext introduceContext) {
        ArrayList<PsiElement> collectedElements = new ArrayList<PsiElement>();
        PsiElement physicalElement = introduceContext.getPhysicalElement();
        PhpPsiElement outerElement = this.getParentIntroducibleElement(physicalElement, true);
        if (this.isSupported(physicalElement) && !PhpIntroduceBaseHandler.isThisReferenceInMemberContext(physicalElement, (PsiElement)outerElement)) {
            collectedElements.add(physicalElement);
        }
        while (outerElement != null) {
            if (this.isSupportedScope(introduceContext.getScope(), (PsiElement)outerElement) && this.isSupported((PsiElement)outerElement)) {
                collectedElements.add((PsiElement)outerElement);
            }
            outerElement = this.getParentIntroducibleElement((PsiElement)outerElement, true);
        }
        ArrayList<PsiElement> arrayList = collectedElements;
        if (arrayList == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    public static boolean isThisReferenceInMemberContext(PsiElement physicalElement, PsiElement outerElement) {
        return PhpLangUtil.isThisReference(physicalElement) && outerElement instanceof MemberReference;
    }

    @Nullable
    protected PhpPsiElement getParentIntroducibleElement(@NotNull PsiElement element, boolean strict) {
        if (element == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(34);
        }
        boolean statementPassed = false;
        for (PsiElement curElement = strict ? element.getParent() : element; curElement != null; curElement = curElement.getParent()) {
            if (curElement instanceof Statement) {
                statementPassed = true;
            } else if (!statementPassed && curElement instanceof PhpExpression && PhpRefactoringUtil.canBeAssignmentValue(curElement)) {
                if (strict && curElement instanceof ParenthesizedExpression) {
                    return (PhpPsiElement)PhpPsiUtil.getOuterParentOfType((ParenthesizedExpression)curElement, ParenthesizedExpression.class);
                }
                return (PhpPsiElement)curElement;
            }
            if (!(curElement instanceof Function) || !PhpRefactoringUtil.canBeAssignmentValue(curElement)) continue;
            return (PhpPsiElement)curElement;
        }
        return null;
    }

    @Nullable
    private PhpIntroduceContext findIntroduceContextByCaret(@NotNull Editor editor, @NotNull PsiFile file, int offset) throws RefactoringErrorException {
        PsiElement elementAtOffset;
        if (editor == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(35);
        }
        if (file == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(36);
        }
        if ((elementAtOffset = file.findElementAt(offset)) == null || elementAtOffset instanceof PsiWhiteSpace) {
            elementAtOffset = file.findElementAt(offset - 1);
        }
        if ((elementAtOffset == null || PhpPsiUtil.isOfType(elementAtOffset, PhpTokenTypes.opSEMICOLON)) && PhpPsiUtil.isOfType(elementAtOffset = file.findElementAt(offset - 1), PhpTokenTypes.opSEMICOLON)) {
            elementAtOffset = file.findElementAt(offset - 2);
        }
        if (elementAtOffset == null) {
            return null;
        }
        PhpPsiElement element = this.getParentIntroducibleElement(elementAtOffset, false);
        if (element == null) {
            return null;
        }
        return this.getIntroduceContext(editor, (PsiElement)element);
    }

    @Nullable
    private PhpIntroduceContext findIntroduceContextBySelection(@NotNull Editor editor, @NotNull PsiFile file, int startOffset, int endOffset) throws RefactoringErrorException {
        PhpPsiElement element;
        if (editor == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(37);
        }
        if (file == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(38);
        }
        PsiElement startElement = file.findElementAt(startOffset);
        PsiElement endElement = file.findElementAt(endOffset - 1);
        if (PhpIntroduceBaseHandler.isSkipStartElement(startElement)) {
            startOffset = startElement.getTextRange().getEndOffset();
            startElement = file.findElementAt(startOffset);
        }
        if (PhpIntroduceBaseHandler.isSkipEndElement(endElement)) {
            assert (endElement != null);
            endOffset = endElement.getTextRange().getStartOffset();
            endElement = file.findElementAt(endOffset - 1);
        }
        if ((element = PhpIntroduceBaseHandler.findIntroducibleElementAtRange(file, startOffset, endOffset)) != null) {
            return this.getIntroduceContext(editor, (PsiElement)element);
        }
        if (startElement == null || endElement == null) {
            return null;
        }
        int startElementStartOffset = startElement.getTextRange().getStartOffset();
        IElementType startElementType = startElement.getNode().getElementType();
        int endElementEndOffset = endElement.getTextRange().getEndOffset();
        IElementType endElementType = endElement.getNode().getElementType();
        if (startElement == endElement) {
            PsiElement context = startElement.getParent();
            IElementType contextType = context.getNode().getElementType();
            PhpPsiElement extractedExpression = null;
            if (PhpElementTypes.HEREDOC.equals(contextType)) {
                extractedExpression = PhpIntroduceBaseHandler.extractFromHeredoc(file, startOffset, endOffset);
            } else if (PhpElementTypes.STRING.equals(contextType)) {
                extractedExpression = context.getText().charAt(0) == '\"' ? PhpIntroduceBaseHandler.extractFromDoubleQuotedString(file, (StringLiteralExpression)context, startOffset, endOffset) : PhpIntroduceBaseHandler.extractFromSingleQuotedString(file, (StringLiteralExpression)context, startOffset, endOffset);
            }
            if (extractedExpression != null) {
                return this.getIntroduceContext(editor, context, (PsiElement)extractedExpression, new TextRange(startOffset, endOffset));
            }
        } else {
            PsiElement context = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
            if (!(context instanceof PhpExpression)) {
                return null;
            }
            IElementType contextType = context.getNode().getElementType();
            PhpPsiElement extractedExpression = null;
            if (PhpElementTypes.BINARY_EXPRESSIONS.contains(contextType)) {
                if (startElementStartOffset == startOffset && endElementEndOffset == endOffset && !PhpTokenTypes.tsBINARY_OPS.contains(startElementType) && !PhpTokenTypes.tsBINARY_OPS.contains(endElementType)) {
                    extractedExpression = PhpIntroduceBaseHandler.extractFromBinaryExpression(file, startOffset, endOffset);
                }
            } else if (PhpElementTypes.HEREDOC.equals(contextType) && (PhpTokenTypes.HEREDOC_CONTENTS.equals(startElementType) || PhpTokenTypes.ESCAPE_SEQUENCE.equals(startElementType)) && (PhpTokenTypes.HEREDOC_CONTENTS.equals(endElementType) || PhpTokenTypes.ESCAPE_SEQUENCE.equals(endElementType))) {
                extractedExpression = PhpIntroduceBaseHandler.extractFromHeredoc(file, startOffset, endOffset);
            } else if (PhpElementTypes.STRING.equals(contextType)) {
                if (PhpIntroduceBaseHandler.isDoubleQuotedString(startElementType, endElementType)) {
                    extractedExpression = PhpIntroduceBaseHandler.extractFromDoubleQuotedString(file, (StringLiteralExpression)context, startOffset, endOffset);
                } else if (PhpIntroduceBaseHandler.isSingleQuotedString(startElementType, endElementType)) {
                    extractedExpression = PhpIntroduceBaseHandler.extractFromSingleQuotedString(file, (StringLiteralExpression)context, startOffset, endOffset);
                }
            }
            if (extractedExpression != null) {
                return this.getIntroduceContext(editor, context, (PsiElement)extractedExpression, new TextRange(startOffset, endOffset));
            }
        }
        return null;
    }

    protected void showChooser(@NotNull Editor editor, @NotNull List<PsiElement> expressions, @NotNull Pass<PsiElement> callback) {
        if (editor == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(39);
        }
        if (expressions == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(40);
        }
        if (callback == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(41);
        }
        IntroduceTargetChooser.showChooser((Editor)editor, expressions, callback, PhpIntroduceBaseHandler::getTrimmedText);
    }

    @NotNull
    public static String getTrimmedText(@NotNull PsiElement element) {
        if (element == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(42);
        }
        String string = PhpTrimRendererVisitor.getTrimmedText(element, 80, 4);
        if (string == null) {
            PhpIntroduceBaseHandler.$$$reportNull$$$0(43);
        }
        return string;
    }

    protected void showErrorHint(Project project, Editor editor, @Nls String errorHint) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)errorHint, (String)this.getRefactoringName(), null);
    }

    @Override
    public int reportConflicts(MultiMap<PsiElement, String> conflicts, Project project) {
        ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts);
        conflictsDialog.show();
        if (conflictsDialog.isShowConflicts()) {
            return 4;
        }
        return conflictsDialog.getExitCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 25, 29, 31, 32, 34, 35, 36, 37, 38, 39, 40, 41, 42 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/PhpIntroduceBaseHandler";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "physicalElement";
                break;
            }
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalElement";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementRange";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessInstruction";
                break;
            }
            case 32: 
            case 34: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightOccurrences";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/PhpIntroduceBaseHandler";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrencesMap";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntroduceContext";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOccurrencesWithDifferentDependencies";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependencies";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "collectIntroducibleElements";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrimmedText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findIntroduceContext";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "performIntroduceWithDialog";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "performInplaceIntroduce";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrencesMap";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getIntroduceContext";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "filterOccurrencesWithDifferentDependencies";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findDependencies";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "accessRangeContainsElement";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getParentIntroducibleElement";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findIntroduceContextByCaret";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findIntroduceContextBySelection";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "showChooser";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getTrimmedText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 25, 29, 31, 32, 34, 35, 36, 37, 38, 39, 40, 41, 42 -> new IllegalArgumentException(string);
        };
    }

    public static class RefactoringErrorException
    extends Exception {
        RefactoringErrorException(String errorHint) {
            super(errorHint);
        }
    }

    @ApiStatus.Internal
    public static final class PhpWithoutSideEffectsReplaceChoice
    implements OccurrencesChooser.BaseReplaceChoice {
        public boolean isAll() {
            return true;
        }

        @Nls
        public String formatDescription(int occurrencesCount) {
            return PhpBundle.message("replace.all.occurrences.without.side.effects", new Object[0]);
        }
    }

    public static class PhpIntroduceResult {
        @NotNull
        private final SmartPsiElementPointer<PsiElement> myIntroducedElement;
        @Nullable
        private final SmartPsiElementPointer<PsiElement> myInitStatement;
        @Nullable
        private final SmartPsiElementPointer<PsiElement> myExpressionForOriginalElement;
        @NotNull
        private final PhpIntroduceContext myContext;

        public PhpIntroduceResult(@NotNull PhpIntroduceContext context, @NotNull PsiElement introducedElement, @Nullable PsiElement expressionForOriginalElement, @Nullable PsiElement initStatement) {
            if (context == null) {
                PhpIntroduceResult.$$$reportNull$$$0(0);
            }
            if (introducedElement == null) {
                PhpIntroduceResult.$$$reportNull$$$0(1);
            }
            this.myContext = context;
            this.myIntroducedElement = SmartPointerManager.createPointer((PsiElement)introducedElement);
            this.myExpressionForOriginalElement = expressionForOriginalElement != null ? SmartPointerManager.createPointer((PsiElement)expressionForOriginalElement) : null;
            this.myInitStatement = initStatement != null ? SmartPointerManager.createPointer((PsiElement)initStatement) : null;
        }

        @NotNull
        public PhpIntroduceContext getContext() {
            PhpIntroduceContext phpIntroduceContext = this.myContext;
            if (phpIntroduceContext == null) {
                PhpIntroduceResult.$$$reportNull$$$0(2);
            }
            return phpIntroduceContext;
        }

        @Nullable
        public PsiElement getIntroducedElement() {
            return this.myIntroducedElement.getElement();
        }

        @Nullable
        public PsiElement getExpressionForOriginalElement() {
            if (this.myExpressionForOriginalElement == null) {
                return null;
            }
            return this.myExpressionForOriginalElement.getElement();
        }

        @Nullable
        public PsiElement getInitStatement() {
            if (this.myInitStatement == null) {
                return null;
            }
            return this.myInitStatement.getElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "introducedElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/refactoring/introduce/PhpIntroduceBaseHandler$PhpIntroduceResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/refactoring/introduce/PhpIntroduceBaseHandler$PhpIntroduceResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    protected abstract class OccurrencesCollector
    extends PhpRecursiveElementVisitor {
        protected PsiElement myScope;
        protected PsiElement mySample;
        protected PsiElement mySampleContext;
        protected boolean isPhysical;
        protected TextRange myRange;
        protected Stack<PsiElement> contextStack;
        private final List<PsiElement> myOccurrences;
        protected boolean skip;

        protected OccurrencesCollector(@NotNull PsiElement scope, PsiElement sample, @NotNull boolean isPhysical, @NotNull PsiElement sampleContext, TextRange elementRange) {
            if (scope == null) {
                OccurrencesCollector.$$$reportNull$$$0(0);
            }
            if (sample == null) {
                OccurrencesCollector.$$$reportNull$$$0(1);
            }
            if (sampleContext == null) {
                OccurrencesCollector.$$$reportNull$$$0(2);
            }
            if (elementRange == null) {
                OccurrencesCollector.$$$reportNull$$$0(3);
            }
            this.skip = false;
            this.myScope = scope;
            this.mySample = sample;
            this.mySampleContext = sampleContext;
            this.isPhysical = isPhysical;
            this.myRange = elementRange;
            this.myOccurrences = new SmartList();
            this.contextStack = new Stack();
            this.contextStack.push((Object)scope);
            this.init();
            scope.acceptChildren((PsiElementVisitor)this);
        }

        protected void init() {
        }

        protected abstract boolean processContext(PsiElement var1);

        public final void visitPhpElement(PhpPsiElement element) {
            boolean addedToStack = false;
            if (PhpIntroduceBaseHandler.isContext((PsiElement)element)) {
                this.contextStack.push((Object)element);
                addedToStack = true;
                if (!this.processContext((PsiElement)element)) {
                    this.contextStack.pop();
                    return;
                }
            } else if (!this.skip && this.isEquivalent((PsiElement)element)) {
                if (PhpIntroduceBaseHandler.this.isSupportedContext((PsiElement)this.contextStack.peek(), (PsiElement)element, (PsiElement)element)) {
                    this.myOccurrences.add((PsiElement)element);
                }
                return;
            }
            element.acceptChildren((PsiElementVisitor)this);
            if (addedToStack) {
                this.contextStack.pop();
                this.processContext((PsiElement)this.contextStack.peek());
            }
        }

        private boolean isEquivalent(@NotNull PsiElement element) {
            if (element == null) {
                OccurrencesCollector.$$$reportNull$$$0(4);
            }
            if (element != this.mySample && PhpRefactoringUtil.isExpression(element) && PhpCodeEditUtil.isEquivalent(this.mySample, element)) {
                if (!this.isPhysical) {
                    if (!this.myRange.intersects(element.getTextRange())) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }

        public final Collection<PsiElement> getOccurrences() {
            return this.myOccurrences;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sample";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sampleContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementRange";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/introduce/PhpIntroduceBaseHandler$OccurrencesCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEquivalent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

