/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceParameter;

import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.introduce.introduceParameter.PhpIntroduceParameterHandler;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFunctionCallReferenceReplacer {
    @NotNull
    private final Function myFunction;
    @NotNull
    private final FunctionReference myFunctionReference;

    public PhpFunctionCallReferenceReplacer(@NotNull Function function, @NotNull FunctionReference reference) {
        if (function == null) {
            PhpFunctionCallReferenceReplacer.$$$reportNull$$$0(0);
        }
        if (reference == null) {
            PhpFunctionCallReferenceReplacer.$$$reportNull$$$0(1);
        }
        this.myFunction = function;
        this.myFunctionReference = reference;
    }

    public void replaceReferences(@NotNull PsiElement newParameter, @NotNull PsiElement sourceExpression) {
        if (newParameter == null) {
            PhpFunctionCallReferenceReplacer.$$$reportNull$$$0(2);
        }
        if (sourceExpression == null) {
            PhpFunctionCallReferenceReplacer.$$$reportNull$$$0(3);
        }
        ArrayDeque<ExpressionMapping> toProcess = new ArrayDeque<ExpressionMapping>();
        toProcess.addLast(new ExpressionMapping(newParameter, sourceExpression));
        while (!toProcess.isEmpty()) {
            PsiElement argumentForParameter;
            Variable variable;
            PsiElement resolvedValue;
            ExpressionMapping mapping = (ExpressionMapping)toProcess.removeFirst();
            PsiElement oldExpression = mapping.myOldExpression;
            PsiElement newExpression = mapping.myNewExpression;
            if (oldExpression instanceof Variable && (resolvedValue = (variable = (Variable)oldExpression).resolve()) instanceof Parameter && !((Parameter)resolvedValue).isVariadic() && (argumentForParameter = PhpFunctionCallReferenceReplacer.getArgumentByParameter(this.myFunction, this.myFunctionReference, resolvedValue)) != null) {
                newExpression.replace(argumentForParameter);
            }
            PsiElement[] newChildren = newExpression.getChildren();
            PsiElement[] oldChildren = oldExpression.getChildren();
            if (oldChildren.length != newChildren.length) continue;
            for (int i = 0; i < oldChildren.length; ++i) {
                toProcess.addLast(new ExpressionMapping(newChildren[i], oldChildren[i]));
            }
        }
    }

    @Nullable
    private static PsiElement getArgumentByParameter(@NotNull Function function, @NotNull FunctionReference functionReference, @NotNull PsiElement parameter) {
        Object[] parameters;
        int index;
        if (function == null) {
            PhpFunctionCallReferenceReplacer.$$$reportNull$$$0(4);
        }
        if (functionReference == null) {
            PhpFunctionCallReferenceReplacer.$$$reportNull$$$0(5);
        }
        if (parameter == null) {
            PhpFunctionCallReferenceReplacer.$$$reportNull$$$0(6);
        }
        if ((index = ArrayUtil.find((Object[])(parameters = function.getParameters()), (Object)parameter)) == -1) {
            return null;
        }
        return PhpIntroduceParameterHandler.getArgumentByParameterIndex((Parameter[])parameters, functionReference.getParameters(), index);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceExpression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/introduce/introduceParameter/PhpFunctionCallReferenceReplacer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceReferences";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getArgumentByParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ExpressionMapping {
        @NotNull
        final PsiElement myNewExpression;
        @NotNull
        final PsiElement myOldExpression;

        ExpressionMapping(@NotNull PsiElement newExpression, @NotNull PsiElement oldExpression) {
            if (newExpression == null) {
                ExpressionMapping.$$$reportNull$$$0(0);
            }
            if (oldExpression == null) {
                ExpressionMapping.$$$reportNull$$$0(1);
            }
            this.myNewExpression = newExpression;
            this.myOldExpression = oldExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldExpression";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/introduce/introduceParameter/PhpFunctionCallReferenceReplacer$ExpressionMapping";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

