/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceVariable;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.introduce.PhpBaseInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableHandler;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableNameSuggestionProvider;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpVariableInplaceIntroducer
extends PhpBaseInplaceIntroducer<Variable, PhpIntroduceVariableSettings> {
    private static final int DOLLAR_PREFIX_LEN = 1;
    private Variable myIntroducedVariable;

    public PhpVariableInplaceIntroducer(@NotNull PhpIntroduceVariableHandler handler, @NotNull PhpIntroduceContext context, @NotNull PhpIntroduceVariableSettings settings) {
        if (handler == null) {
            PhpVariableInplaceIntroducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpVariableInplaceIntroducer.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            PhpVariableInplaceIntroducer.$$$reportNull$$$0(2);
        }
        super(handler, context, settings);
    }

    @Nullable
    protected Variable createFieldToStartTemplateOn(boolean replaceAll, String @NotNull [] names) {
        if (names == null) {
            PhpVariableInplaceIntroducer.$$$reportNull$$$0(3);
        }
        AssignmentExpression assignment = (AssignmentExpression)PsiTreeUtil.getChildOfType((PsiElement)this.runRefactoring().getIntroducedElement(), AssignmentExpression.class);
        assert (assignment != null);
        Variable variable = (Variable)ObjectUtils.tryCast((Object)assignment.getVariable(), Variable.class);
        assert (variable != null);
        this.myIntroducedVariable = variable;
        return variable;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        if (element == null) {
            PhpVariableInplaceIntroducer.$$$reportNull$$$0(4);
        }
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(new TextRange(0, element.getTextLength()), element);
        if (textRange == null) {
            PhpVariableInplaceIntroducer.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiReference reference) {
        if (reference == null) {
            PhpVariableInplaceIntroducer.$$$reportNull$$$0(6);
        }
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(reference.getRangeInElement(), reference.getElement());
        if (textRange == null) {
            PhpVariableInplaceIntroducer.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    protected int adjustHighlightsStartOffset(int offset) {
        return offset + 1;
    }

    @Override
    protected String @NotNull [] suggestNames(boolean replaceAll, @Nullable Variable variable) {
        String[] stringArray = new PhpIntroduceVariableNameSuggestionProvider(this.myContext, PhpIntroduceVariableHandler.getOccupiedElements(this.myContext)).getSuggestedNames();
        if (stringArray == null) {
            PhpVariableInplaceIntroducer.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    protected int getCaretOffset() {
        return this.myIntroducedVariable.getTextOffset() + 1;
    }

    @Override
    @Nullable
    protected Variable getVariable() {
        return this.myIntroducedVariable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/introduceVariable/PhpVariableInplaceIntroducer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/introduceVariable/PhpVariableInplaceIntroducer";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToRename";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFieldToStartTemplateOn";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToRename";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

