/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move;

import com.intellij.core.CoreBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.php.lang.PhpLanguage;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpMoveDelegateBase
extends MoveHandlerDelegate {
    @NlsContexts.DialogTitle
    @Nls
    public abstract String getRefactoringName();

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        PsiFile file = element.getContainingFile();
        PsiElement[] elements = new PsiElement[]{element};
        if (this.canMove(elements, null, reference)) {
            if (!file.isWritable()) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)CoreBundle.message((String)"editing.read.only.file.hint", (Object[])new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getRefactoringName(), null);
                return true;
            }
            this.doMove(project, elements, null, null);
            return true;
        }
        return false;
    }

    public boolean supportsLanguage(@NotNull Language language) {
        if (language == null) {
            PhpMoveDelegateBase.$$$reportNull$$$0(0);
        }
        return language == PhpLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/jetbrains/php/refactoring/move/PhpMoveDelegateBase", "supportsLanguage"));
    }
}

