/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.inspections.PhpUndefinedFieldInspection;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDynamicFieldRenameHandler
extends PsiElementRenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PhpDynamicFieldRenameHandler.$$$reportNull$$$0(0);
        }
        PsiElement element = PsiElementRenameHandler.getElement((DataContext)dataContext);
        return PhpDynamicFieldRenameHandler.canExtractDynamicField(element, (Editor)CommonDataKeys.EDITOR.getData(dataContext));
    }

    public static boolean canExtractDynamicField(@Nullable PsiElement element, @Nullable Editor editor) {
        if (element == null && editor != null) {
            FieldReference reference = (FieldReference)ObjectUtils.tryCast((Object)TargetElementUtil.findReference((Editor)editor), FieldReference.class);
            return reference != null && PhpUndefinedFieldInspection.allFieldsDynamicallyInitialized(reference.multiResolveStrict(Field.class));
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, @NotNull DataContext dataContext) {
        Field dynamicFieldTarget;
        if (project == null) {
            PhpDynamicFieldRenameHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            PhpDynamicFieldRenameHandler.$$$reportNull$$$0(2);
        }
        if ((dynamicFieldTarget = PhpDynamicFieldRenameHandler.getAdjustedDynamicFieldTarget(editor, dataContext)) != null) {
            String newName;
            if (ApplicationManager.getApplication().isUnitTestMode() && (newName = (String)DEFAULT_NAME.getData(dataContext)) != null) {
                PhpDynamicFieldRenameHandler.rename((PsiElement)dynamicFieldTarget, (Project)project, (PsiElement)dynamicFieldTarget, (Editor)editor, (String)newName);
                return;
            }
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            PhpDynamicFieldRenameHandler.invoke((PsiElement)dynamicFieldTarget, (Project)project, (PsiElement)dynamicFieldTarget, (Editor)editor);
            return;
        }
        super.invoke(project, editor, file, dataContext);
    }

    @Nullable
    public static Field getAdjustedDynamicFieldTarget(Editor editor, DataContext dataContext) {
        Collection fields;
        FieldReference reference;
        PsiElement element;
        PsiElement psiElement = element = dataContext != null ? PsiElementRenameHandler.getElement((DataContext)dataContext) : null;
        if (element == null && (reference = (FieldReference)ObjectUtils.tryCast((Object)TargetElementUtil.findReference((Editor)editor), FieldReference.class)) != null && PhpUndefinedFieldInspection.allFieldsDynamicallyInitialized(fields = reference.multiResolveStrict(Field.class))) {
            return (Field)ContainerUtil.getFirstItem((Collection)fields);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/rename/PhpDynamicFieldRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

