/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename.inplace;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.rename.inplace.PhpVariableInplaceRenamer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMemberInplaceRenamer
extends MemberInplaceRenamer {
    public PhpMemberInplaceRenamer(@NotNull PsiNamedElement elementToRename, PsiElement substituted, Editor editor) {
        if (elementToRename == null) {
            PhpMemberInplaceRenamer.$$$reportNull$$$0(0);
        }
        super(elementToRename, substituted, editor);
    }

    public PhpMemberInplaceRenamer(@NotNull PsiNamedElement elementToRename, PsiElement substituted, Editor editor, String initialName, String oldName) {
        if (elementToRename == null) {
            PhpMemberInplaceRenamer.$$$reportNull$$$0(1);
        }
        super(elementToRename, substituted, editor, initialName, oldName);
    }

    protected boolean isIdentifier(String newName, Language language) {
        if (this.myElementToRename instanceof Method) {
            return PhpNameUtil.isValidMethodName(newName);
        }
        if (this.myElementToRename instanceof Field) {
            return PhpNameUtil.isValidFieldName(newName);
        }
        if (this.myElementToRename instanceof Function) {
            return PhpNameUtil.isValidFunctionName(newName);
        }
        if (this.myElementToRename instanceof Constant) {
            return PhpNameUtil.isValidConstantName(newName);
        }
        if (this.myElementToRename instanceof PhpEnumCase) {
            return PhpLangUtil.isPhpIdentifier(newName);
        }
        return PhpLangUtil.isPhpIdentifier(newName) && !PhpLangUtil.isPhpReservedKeyword(newName);
    }

    protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
        PsiElement substituted;
        CommonProcessors.CollectProcessor<PsiReference> mainProcessor = new CommonProcessors.CollectProcessor<PsiReference>(){

            protected boolean accept(PsiReference reference) {
                return PhpMemberInplaceRenamer.this.acceptReference(reference);
            }
        };
        ReferencesSearch.search((PsiElement)this.myElementToRename, (SearchScope)referencesSearchScope, (boolean)false).forEach((Processor)mainProcessor);
        ArrayList<PsiReference> references = new ArrayList<PsiReference>(mainProcessor.getResults());
        PsiNamedElement variable = this.getVariable();
        if (variable != null && (substituted = this.getSubstituted()) != null && substituted != variable) {
            CommonProcessors.CollectProcessor<PsiReference> processor2 = new CommonProcessors.CollectProcessor<PsiReference>(this){

                protected boolean accept(PsiReference reference) {
                    if (reference instanceof ClassReference) {
                        return !PhpLangUtil.isClassNameSpecial(((ClassReference)reference).getName());
                    }
                    return true;
                }
            };
            ReferencesSearch.search((PsiElement)substituted, (SearchScope)referencesSearchScope, (boolean)false).forEach((Processor)processor2);
            references.addAll(processor2.getResults());
        }
        return references;
    }

    protected void performOnInvalidIdentifier(String newName, LinkedHashSet<String> nameSuggestions) {
        PsiNamedElement variable = this.getVariable();
        if (variable != null) {
            PsiReference caret = PhpRefactoringUtil.getReferenceAtCaret((PsiElement)variable, this.myEditor);
            if (caret == null || !caret.isReferenceTo((PsiElement)variable)) {
                CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)this.myEditor, (String)PhpBundle.message("validation.invalid.identifier.with.no.identifier", new Object[0]), (String)"", null);
                return;
            }
            super.performOnInvalidIdentifier(newName, nameSuggestions);
        }
    }

    @NotNull
    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        return new PhpMemberInplaceRenamer(variable, this.getSubstituted(), editor, initialName, this.myOldName);
    }

    protected PsiElement getSelectedInEditorElement(@Nullable PsiElement nameIdentifier, @NotNull Collection<? extends PsiReference> refs, @NotNull Collection<? extends Pair<PsiElement, TextRange>> stringUsages, int offset) {
        PsiElement element;
        if (refs == null) {
            PhpMemberInplaceRenamer.$$$reportNull$$$0(2);
        }
        if (stringUsages == null) {
            PhpMemberInplaceRenamer.$$$reportNull$$$0(3);
        }
        if ((element = PhpVariableInplaceRenamer.getSelectedInEditorElementInternal(nameIdentifier, refs, stringUsages, offset)) == null) {
            LOG.error(String.valueOf(nameIdentifier) + " by " + ((Object)((Object)this)).getClass().getName());
        }
        return element;
    }

    protected boolean checkRangeContainsOffset(int offset, TextRange textRange, PsiElement element, int shiftOffset) {
        return PhpVariableInplaceRenamer.checkRangeContainsOffset(offset, textRange, element, shiftOffset, this.getNameIdentifier());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringUsages";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/rename/inplace/PhpMemberInplaceRenamer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedInEditorElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

