/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.roots.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorComboBoxEditor;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.StringComboboxEditor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.lang.PhpFileType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNamespaceComboBox
extends ComboBox {
    private final Project myProject;
    @NlsSafe
    private String myInitialNamespaceItem;
    @NlsSafe
    private String myEditedNamespace;
    private final ArrayList<@NlsSafe String> mySuggestionsByDirectory;
    private PopupMenuListener myTargetNamespaceListener;

    public PhpNamespaceComboBox(@NotNull Project project, @NotNull String initNamespace, @NotNull Disposable disposable) {
        if (project == null) {
            PhpNamespaceComboBox.$$$reportNull$$$0(0);
        }
        if (initNamespace == null) {
            PhpNamespaceComboBox.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            PhpNamespaceComboBox.$$$reportNull$$$0(2);
        }
        this.myEditedNamespace = null;
        this.mySuggestionsByDirectory = new ArrayList();
        this.myTargetNamespaceListener = null;
        this.myProject = project;
        this.setInitialNamespace(initNamespace, disposable);
    }

    public void updateItems() {
        this.removeAllItems();
        this.addItem(this.myInitialNamespaceItem);
        if (this.myEditedNamespace != null) {
            this.addItem(this.myEditedNamespace);
        }
        for (String s : this.mySuggestionsByDirectory) {
            this.addItem(s);
        }
    }

    public void updateItems(@NotNull String selectedItem, @Nullable List<String> newItems) {
        if (selectedItem == null) {
            PhpNamespaceComboBox.$$$reportNull$$$0(3);
        }
        this.mySuggestionsByDirectory.clear();
        this.myInitialNamespaceItem = selectedItem;
        if (newItems != null) {
            this.mySuggestionsByDirectory.addAll(newItems);
        }
        this.updateItems();
    }

    private void setInitialNamespace(@NotNull String initialNamespace, @NotNull Disposable disposable) {
        if (initialNamespace == null) {
            PhpNamespaceComboBox.$$$reportNull$$$0(4);
        }
        if (disposable == null) {
            PhpNamespaceComboBox.$$$reportNull$$$0(5);
        }
        this.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            if (value instanceof String && StringUtil.isEmpty((String)((String)value))) {
                label.setText(PhpBundle.message("label.global.namespace", new Object[0]));
            }
        }));
        this.myInitialNamespaceItem = initialNamespace;
        StringComboboxEditor comboEditor = new StringComboboxEditor(this.myProject, (FileType)PhpFileType.INSTANCE, (ComboBox)this);
        comboEditor.setItem((Object)this.myInitialNamespaceItem);
        this.myTargetNamespaceListener = new PopupMenuListener(){
            final /* synthetic */ EditorComboBoxEditor val$comboEditor;
            {
                this.val$comboEditor = editorComboBoxEditor;
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                String newItem = (String)this.val$comboEditor.getItem();
                if (!StringUtil.equals((CharSequence)PhpNamespaceComboBox.this.myInitialNamespaceItem, (CharSequence)newItem) && !StringUtil.equals((CharSequence)PhpNamespaceComboBox.this.myEditedNamespace, (CharSequence)newItem)) {
                    PhpNamespaceComboBox.this.myEditedNamespace = newItem;
                    PhpNamespaceComboBox.this.updateItems();
                    PhpNamespaceComboBox.this.setSelectedItem(PhpNamespaceComboBox.this.myEditedNamespace);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
        this.addPopupMenuListener(this.myTargetNamespaceListener);
        PhpCompletionUtil.installNamespaceCompletion(comboEditor.getEditorComponent(), initialNamespace, disposable);
        this.setEditor((ComboBoxEditor)comboEditor);
        this.updateItems();
        this.setSelectedItem(this.myInitialNamespaceItem);
    }

    public EditorTextField getEditorTextField() {
        return (EditorTextField)this.getEditor().getEditorComponent();
    }

    public String getSelectedNamespace() {
        return this.getEditorTextField().getText();
    }

    public void removeDocumentListeners() {
        if (this.myTargetNamespaceListener != null) {
            this.removePopupMenuListener(this.myTargetNamespaceListener);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initNamespace";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedItem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialNamespace";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/roots/ui/PhpNamespaceComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateItems";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setInitialNamespace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

