/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.roots.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.roots.ui.PhpNamespaceComboBox;
import com.jetbrains.php.roots.ui.PhpPsrDirectoryComboBox;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPsrNamespacePanel
extends JPanel
implements Disposable {
    private final Alarm myAlarm;
    private final String myInitialNamespace;
    protected JComponent myNamespacePanel;
    protected JComponent myDirectoryPanel;
    protected PhpNamespaceComboBox myNamespaceField;
    protected PhpPsrDirectoryComboBox myDirectoryField;
    private DocumentListener myTargetDirectoryListener;
    private boolean myDisposed;
    private final Project myProject;

    public PhpPsrNamespacePanel(@NotNull Project project, @NotNull String namespace, @NotNull PsiFileSystemItem fileOrDir, @NotNull JBInsets insets) {
        if (project == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(1);
        }
        if (fileOrDir == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(2);
        }
        if (insets == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(3);
        }
        this.myAlarm = new Alarm();
        this.myProject = project;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = insets;
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 2;
        gbConstraints.anchor = 17;
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                PhpPsrNamespacePanel.this.myAlarm.cancelAllRequests();
                PhpPsrNamespacePanel.this.myDisposed = true;
            }
        });
        this.myInitialNamespace = StringUtil.trimEnd((String)PhpLangUtil.toPresentableFQN(namespace), (String)"\\");
        this.myNamespacePanel = this.createNamespacePanel(project, this.myInitialNamespace);
        this.add((Component)this.myNamespacePanel, gbConstraints);
        ++gbConstraints.gridy;
        this.myDirectoryPanel = this.createDirectoryPanel(project, fileOrDir);
        this.add((Component)this.myDirectoryPanel, gbConstraints);
        this.customizePanel();
    }

    @NotNull
    @Nls
    public String getNamespaceLabelText() {
        String string = PhpBundle.message("refactoring.common.ui.target.namespace.label", new Object[0]);
        if (string == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    public PhpNamespaceComboBox getNamespaceField() {
        return this.myNamespaceField;
    }

    public void customizePanel() {
    }

    @NotNull
    private JComponent createNamespacePanel(@NotNull Project project, @NotNull String namespace) {
        if (project == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(5);
        }
        if (namespace == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(6);
        }
        this.myNamespaceField = new PhpNamespaceComboBox(project, namespace, this);
        this.myNamespaceField.setEditable(true);
        JPanel subPanel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel(this.getNamespaceLabelText());
        label.setLabelFor((Component)((Object)this.myNamespaceField));
        subPanel.add((Component)label, "North");
        subPanel.add((Component)((Object)this.myNamespaceField), "Center");
        JBLabel editKeyLabel = new JBLabel(PhpBundle.message("0.completion.shortcut", "namespace", PhpUiUtil.getShortcutTextByActionName("CodeCompletion")));
        editKeyLabel.setComponentStyle(UIUtil.ComponentStyle.MINI);
        subPanel.add((Component)editKeyLabel, "South");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)subPanel, "Center");
        JPanel jPanel = panel;
        if (jPanel == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @NotNull
    protected JComponent createDirectoryPanel(@NotNull Project project, @NotNull PsiFileSystemItem fileOrDir) {
        PsiDirectory directory;
        if (project == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(8);
        }
        if (fileOrDir == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(9);
        }
        PsiDirectory psiDirectory = directory = fileOrDir instanceof PsiDirectory ? (PsiDirectory)fileOrDir : ((PsiFile)fileOrDir).getContainingDirectory();
        assert (directory != null);
        this.myDirectoryField = new PhpPsrDirectoryComboBox(project);
        this.myDirectoryField.init(directory.getVirtualFile(), this.myInitialNamespace);
        this.myDirectoryField.updateDirectories(this.getNamespaceName());
        this.myTargetDirectoryListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpPsrNamespacePanel.this.addUpdateRequest(() -> PhpPsrNamespacePanel.this.myDirectoryField.updateDirectories(PhpPsrNamespacePanel.this.getNamespaceName()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/roots/ui/PhpPsrNamespacePanel$2", "documentChanged"));
            }
        };
        this.myNamespaceField.getEditorTextField().addDocumentListener(this.myTargetDirectoryListener);
        JPanel subPanel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel(PhpBundle.message("refactoring.common.ui.target.directory.label", new Object[0]));
        label.setLabelFor((Component)((Object)this.myDirectoryField));
        subPanel.add((Component)label, "North");
        subPanel.add((Component)((Object)this.myDirectoryField), "Center");
        JBLabel completionLabel = new JBLabel(PhpBundle.message("refactoring.common.ui.target.directory.edit", new Object[0]), UIUtil.ComponentStyle.MINI);
        subPanel.add((Component)completionLabel, "South");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)subPanel, "Center");
        JPanel jPanel = panel;
        if (jPanel == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    private void addUpdateRequest(@NotNull Runnable runnable) {
        if (runnable == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(11);
        }
        SwingUtilities.invokeLater(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(runnable, 100);
        });
    }

    @NotNull
    public String getNamespaceName() {
        String string = PhpLangUtil.toName(this.myNamespaceField.getSelectedNamespace());
        if (string == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getSelectedDirectory() {
        String string = this.myDirectoryField.getSelectedPath();
        if (string == null) {
            PhpPsrNamespacePanel.$$$reportNull$$$0(13);
        }
        return string;
    }

    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.myNamespaceField.getEditor().getEditorComponent();
    }

    public void dispose() {
        if (this.myTargetDirectoryListener != null) {
            this.myNamespaceField.getEditorTextField().removeDocumentListener(this.myTargetDirectoryListener);
        }
        this.myNamespaceField.removeDocumentListeners();
    }

    @Nullable
    public ValidationInfo getValidationInfo() {
        String namespaceName = this.getNamespaceName();
        if (StringUtil.isNotEmpty((String)namespaceName) && !PhpNameUtil.isValidNamespaceFullName(namespaceName, PhpLanguageLevel.current((Project)this.myProject))) {
            String message = PhpBundle.message("refactoring.common.validation.namespace.name", namespaceName);
            return new ValidationInfo(message, (JComponent)((Object)this.getNamespaceField()));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 10, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/roots/ui/PhpPsrNamespacePanel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/roots/ui/PhpPsrNamespacePanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceLabelText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamespacePanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectoryPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNamespacePanel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryPanel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addUpdateRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 10, 12, 13 -> new IllegalStateException(string);
        };
    }
}

