/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.script;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpDebugProcessFactory;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import com.jetbrains.php.run.PhpCommandLineSettings;
import com.jetbrains.php.run.PhpDebugRunner;
import com.jetbrains.php.run.script.PhpScriptRunConfiguration;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionServer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpScriptDebugRunner
extends PhpDebugRunner<PhpScriptRunConfiguration> {
    public PhpScriptDebugRunner() {
        super(PhpScriptRunConfiguration.class);
    }

    @NotNull
    public String getRunnerId() {
        return "PhpScriptDebugRunner";
    }

    @Override
    protected RunContentDescriptor doExecute(@NotNull PhpScriptRunConfiguration runConfiguration, @NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (runConfiguration == null) {
            PhpScriptDebugRunner.$$$reportNull$$$0(0);
        }
        if (state == null) {
            PhpScriptDebugRunner.$$$reportNull$$$0(1);
        }
        if (env == null) {
            PhpScriptDebugRunner.$$$reportNull$$$0(2);
        }
        final Project project = runConfiguration.getProject();
        PhpProjectDebugConfiguration.State debugConfiguration = PhpProjectDebugConfiguration.getInstance(project).getState();
        boolean breakAtFirstLine = debugConfiguration.isBreakAtFirstLine();
        final PhpInterpreter interpreter = PhpScriptDebugRunner.getInterpreter(project, ((PhpScriptRunConfiguration.Settings)runConfiguration.getSettings()).getCommandLineSettings());
        if (interpreter == null) {
            throw new ExecutionException(PhpCommandSettingsBuilder.getInterpreterNotFoundError());
        }
        final PhpDebugExtension debugExtension = PhpProjectConfigurationFacade.getInstance(runConfiguration.getProject()).getInterpreterDebugExtension(interpreter);
        if (debugExtension == null) {
            throw new ExecutionException(PhpBundle.message("debug.error.unknown.debugger.id", new Object[0]));
        }
        final PhpIncomingDebugConnectionServer debugServer = debugExtension.startLocalDebugServer(project, interpreter);
        if (debugServer == null) {
            return null;
        }
        final PhpDebugConnectionManager connectionsManager = debugExtension.createDebugConnectionManager();
        final String sessionId = debugServer.registerSessionHandler(false, connectionsManager).getSessionId();
        try {
            final PhpCommandSettings command = new PhpCommandSettingsBuilder(project, interpreter).loadAndStartDebug().build();
            Map<String, String> commandLineEnv = debugExtension.getDebugEnv(project, breakAtFirstLine, sessionId);
            runConfiguration.fillCommandSettings(commandLineEnv, command);
            final ProcessHandler processHandler = runConfiguration.createProcessHandler(project, command, PtyCommandLine.isEnabled());
            ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)project);
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)project).startSession(env, new XDebugProcessStarter(this){

                @NotNull
                public XDebugProcess start(@NotNull XDebugSession session) {
                    if (session == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PhpScriptDebugRunner.onSessionStart(session, debugServer, sessionId, connectionsManager, project, interpreter, processHandler);
                    PhpDebugDriver driver = debugExtension.getDebugDriver();
                    PhpDebugProcess phpDebugProcess = PhpDebugProcessFactory.forPhpScript(project, session, sessionId, connectionsManager, driver, command.getPathProcessor());
                    if (phpDebugProcess == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return phpDebugProcess;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "session";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/php/run/script/PhpScriptDebugRunner$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/php/run/script/PhpScriptDebugRunner$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "start";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "start";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            });
            debugSession.getConsoleView().attachToProcess(processHandler);
            processHandler.startNotify();
            return debugSession.getRunContentDescriptor();
        }
        catch (ExecutionException e) {
            debugServer.unregisterSessionHandler(sessionId);
            throw e;
        }
    }

    @Nullable
    static PhpInterpreter getInterpreter(@NotNull Project project, @NotNull PhpCommandLineSettings settings) {
        String interpreterName;
        if (project == null) {
            PhpScriptDebugRunner.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            PhpScriptDebugRunner.$$$reportNull$$$0(4);
        }
        if ((interpreterName = settings.getInterpreterSettings().getInterpreterName()) != null) {
            return PhpInterpretersManagerImpl.getInstance(project).findInterpreter(interpreterName);
        }
        return PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/run/script/PhpScriptDebugRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getInterpreter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

