/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.script;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.run.PhpRunConfigurationExtensionsManager;
import com.jetbrains.php.run.script.PhpScriptRunConfiguration;
import com.jetbrains.php.run.script.PhpScriptRunConfigurationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpScriptRuntimeConfigurationProducer
extends LazyRunConfigurationProducer<PhpScriptRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = PhpScriptRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            PhpScriptRuntimeConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull PhpScriptRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        VirtualFile root;
        Location location;
        if (configuration == null) {
            PhpScriptRuntimeConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PhpScriptRuntimeConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            PhpScriptRuntimeConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (!((location = context.getLocation()) instanceof PsiLocation)) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        if (PhpScriptRuntimeConfigurationProducer.inTest(element)) {
            return false;
        }
        PsiFile containingFile = element.getContainingFile();
        if (!PhpScriptRuntimeConfigurationProducer.isValid(containingFile)) {
            return false;
        }
        VirtualFile file = containingFile.getVirtualFile();
        sourceElement.set((Object)containingFile);
        if (!ScratchUtil.isScratch((VirtualFile)file) && (root = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().getContentRootForFile(file)) == null) {
            return false;
        }
        PhpScriptRunConfiguration.Settings params = (PhpScriptRunConfiguration.Settings)configuration.getSettings();
        params.setPath(file.getPresentableUrl());
        configuration.setName(configuration.suggestedName());
        PhpRunConfigurationExtensionsManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location);
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull PhpScriptRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Location location;
        if (configuration == null) {
            PhpScriptRuntimeConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PhpScriptRuntimeConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        PsiElement anchor = location.getPsiElement();
        if (PhpScriptRuntimeConfigurationProducer.inTest(anchor)) {
            return false;
        }
        PsiFile containingFile = anchor.getContainingFile();
        if (PhpScriptRuntimeConfigurationProducer.isValid(containingFile)) {
            VirtualFile configurationFile;
            VirtualFile containingVirtualFile = containingFile.getVirtualFile();
            PhpScriptRunConfiguration.Settings params = (PhpScriptRunConfiguration.Settings)configuration.getSettings();
            String path = params.getPath();
            if (path != null && (configurationFile = LocalFileSystem.getInstance().findFileByPath(path)) != null) {
                return StringUtil.equals((CharSequence)containingVirtualFile.getPath(), (CharSequence)configurationFile.getPath());
            }
        }
        return false;
    }

    private static boolean inTest(@Nullable PsiElement anchor) {
        PhpClass parentClass = PhpPsiUtil.getParentOfClass(anchor, PhpClass.class);
        return parentClass != null && PhpUnitUtil.isRunnableTestClass(parentClass);
    }

    private static boolean isValid(@Nullable PsiFile containingFile) {
        return containingFile != null && containingFile.getFileType() == PhpFileType.INSTANCE && containingFile.getVirtualFile() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/script/PhpScriptRuntimeConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/script/PhpScriptRuntimeConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

