/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.MoreCollectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDefaultNameInterpretersCollectorHelper {
    private static final PhpDefaultNameInterpretersCollectorHelper ourDefaultNameCollector = new PhpDefaultNameInterpretersCollectorHelper();
    private static final String LOCAL = "local";
    private static final StringEventField INTERPRETER_TYPE_FIELD = EventFields.String((String)"interpreter_type", List.of("third.party", "local", "vagrant", "docker", "docker-compose", "ssh-credentials", "web-deployment"));
    private static final EventLogGroup GROUP = new EventLogGroup("php.interpreters.default.name", 3);
    private static final StringEventField LEVEL = EventFields.String((String)"level", List.of("ide", "project"));
    private static final VarargEventId DEFAULT_NAME_METRIC = GROUP.registerVarargEvent("default.name", new EventField[]{EventFields.Count, LEVEL, INTERPRETER_TYPE_FIELD});
    private static final VarargEventId EXTENDED_NAME_METRIC = GROUP.registerVarargEvent("extended.name", new EventField[]{EventFields.Count, LEVEL, INTERPRETER_TYPE_FIELD});
    private static final VarargEventId CUSTOM_NAME_METRIC = GROUP.registerVarargEvent("custom.name", new EventField[]{EventFields.Count, LEVEL, INTERPRETER_TYPE_FIELD});

    @NotNull
    public Set<MetricEvent> collectMetrics(@Nullable Project project) {
        boolean isProjectLevel = project != null;
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance(project);
        if (manager == null) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(0);
            }
            return set;
        }
        HashSet<MetricEvent> metrics = new HashSet<MetricEvent>();
        List<PhpInterpreter> localInterpreters = manager.getInterpreters().stream().filter(interpreter -> interpreter.isProjectLevel() == isProjectLevel).filter(interpreter -> !interpreter.isRemote()).collect(Collectors.toList());
        PhpDefaultNameInterpretersCollectorHelper.collectMetrics(project, null, localInterpreters, metrics);
        Map remoteInterpreters = manager.getInterpreters().stream().filter(interpreter -> interpreter.isProjectLevel() == isProjectLevel).filter(interpreter -> interpreter.getPhpSdkAdditionalData() instanceof RemoteSdkAdditionalData).collect(Collectors.groupingBy(interpreter -> ((RemoteSdkAdditionalData)interpreter.getPhpSdkAdditionalData()).getRemoteConnectionType(), Collectors.mapping(Function.identity(), Collectors.toList())));
        for (Map.Entry entry : remoteInterpreters.entrySet()) {
            PhpDefaultNameInterpretersCollectorHelper.collectMetrics(project, entry.getKey(), entry.getValue(), metrics);
        }
        HashSet<MetricEvent> hashSet = metrics;
        if (hashSet == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static void collectMetrics(@Nullable Project project, @Nullable CredentialsType type, @NotNull List<PhpInterpreter> interpreters, @NotNull Set<MetricEvent> metrics) {
        boolean byJB;
        if (interpreters == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(2);
        }
        if (metrics == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(3);
        }
        List notDefault = ContainerUtil.filter(interpreters, interpreter -> !PhpDefaultNameInterpretersCollectorHelper.isDefaultName(project, interpreter));
        int numNotDefault = notDefault.size();
        int numExtendedDefault = (Integer)notDefault.stream().filter(interpreter -> PhpDefaultNameInterpretersCollectorHelper.isExtendedDefaultName(project, interpreter)).collect(MoreCollectors.countingInt());
        boolean bl = byJB = type == null || PluginInfoDetectorKt.getPluginInfo(type.getClass()).isDevelopedByJetBrains();
        String typeName = type != null ? (byJB ? PhpDefaultNameInterpretersCollectorHelper.escapeUsageKey(type.getName()) : "third.party") : LOCAL;
        ArrayList<EventPair> data = new ArrayList<EventPair>();
        data.add(LEVEL.with((Object)(project == null ? "ide" : "project")));
        data.add(INTERPRETER_TYPE_FIELD.with((Object)typeName));
        MetricEventUtilKt.addCounterIfNotZero(metrics, (VarargEventId)DEFAULT_NAME_METRIC, (int)(interpreters.size() - numNotDefault), data);
        MetricEventUtilKt.addCounterIfNotZero(metrics, (VarargEventId)EXTENDED_NAME_METRIC, (int)numExtendedDefault, data);
        MetricEventUtilKt.addCounterIfNotZero(metrics, (VarargEventId)CUSTOM_NAME_METRIC, (int)(numNotDefault - numExtendedDefault), data);
    }

    @NotNull
    private static String escapeUsageKey(@NotNull String key) {
        if (key == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(4);
        }
        String string = StringUtil.replace((String)StringUtil.toLowerCase((String)key), (String)" ", (String)"-");
        if (string == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static boolean isDefaultName(@Nullable Project project, @NotNull PhpInterpreter interpreter) {
        if (interpreter == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(6);
        }
        String name = interpreter.getName();
        PhpInfo info = PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(name);
        String suggested = interpreter.getPhpSdkAdditionalData().suggestName(info);
        if (StringUtil.equals((CharSequence)suggested, (CharSequence)name)) {
            return true;
        }
        return StringUtil.startsWith((CharSequence)name, (CharSequence)suggested) && PhpDefaultNameInterpretersCollectorHelper.isCounterPrefix(name, suggested.length());
    }

    private static boolean isCounterPrefix(@NotNull String name, int prefixStart) {
        int nameLength;
        if (name == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(7);
        }
        if ((nameLength = name.length()) <= prefixStart + 3) {
            return false;
        }
        if (name.charAt(nameLength - 1) == ')' && name.charAt(prefixStart) == ' ' && name.charAt(prefixStart + 1) == '(') {
            String count = name.substring(prefixStart + 2, nameLength - 1);
            try {
                return Integer.parseInt(count) > 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isExtendedDefaultName(@Nullable Project project, @NotNull PhpInterpreter interpreter) {
        if (interpreter == null) {
            PhpDefaultNameInterpretersCollectorHelper.$$$reportNull$$$0(8);
        }
        PhpInfo info = PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(interpreter.getName());
        String suggested = interpreter.getPhpSdkAdditionalData().suggestName(info);
        return StringUtil.containsIgnoreCase((String)interpreter.getName(), (String)suggested);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/statistics/PhpDefaultNameInterpretersCollectorHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMetrics";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/statistics/PhpDefaultNameInterpretersCollectorHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeUsageKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectMetrics";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapeUsageKey";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCounterPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isExtendedDefaultName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    public static final class ApplicationUsageCollector
    extends ApplicationUsagesCollector {
        @NotNull
        public Set<MetricEvent> getMetrics() {
            Set<MetricEvent> set = ourDefaultNameCollector.collectMetrics(null);
            if (set == null) {
                ApplicationUsageCollector.$$$reportNull$$$0(0);
            }
            return set;
        }

        public EventLogGroup getGroup() {
            return GROUP;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/statistics/PhpDefaultNameInterpretersCollectorHelper$ApplicationUsageCollector", "getMetrics"));
        }
    }

    public static final class ProjectUsageCollector
    extends ProjectUsagesCollector {
        @NotNull
        public Set<MetricEvent> getMetrics(@NotNull Project project) {
            if (project == null) {
                ProjectUsageCollector.$$$reportNull$$$0(0);
            }
            Set<MetricEvent> set = ourDefaultNameCollector.collectMetrics(project);
            if (set == null) {
                ProjectUsageCollector.$$$reportNull$$$0(1);
            }
            return set;
        }

        public EventLogGroup getGroup() {
            return GROUP;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/statistics/PhpDefaultNameInterpretersCollectorHelper$ProjectUsageCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/statistics/PhpDefaultNameInterpretersCollectorHelper$ProjectUsageCollector";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetrics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetrics";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

