/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PhpTestCreateInfo {
    @NotNull
    @NlsSafe
    public String getName();

    @NotNull
    public String getTemplateName();

    @Nullable
    public Icon getIcon();

    @NotNull
    @NlsSafe
    public String getDefaultTestName(@NotNull String var1);

    @Nullable
    public String getTestNamespace(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull String var3, @NotNull String var4, @NotNull String var5);

    @Nullable
    public String getTestDirectory(@NotNull Project var1, @NotNull SourceFolder var2, @NotNull String var3, @NotNull String var4);

    public boolean isConfiguredFolder(@NotNull Project var1, @Nullable VirtualFile var2);

    @NotNull
    default public String getNamespaceWithoutPrefix(@NotNull Project project, @NotNull String namespace, @NotNull String fromNamespace, @Nullable VirtualFile file) {
        if (project == null) {
            PhpTestCreateInfo.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            PhpTestCreateInfo.$$$reportNull$$$0(1);
        }
        if (fromNamespace == null) {
            PhpTestCreateInfo.$$$reportNull$$$0(2);
        }
        String string = namespace;
        if (string == null) {
            PhpTestCreateInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    default public String getTestMethodText(@NotNull Project project, @NotNull String classFqn, @NotNull String methodName) {
        if (project == null) {
            PhpTestCreateInfo.$$$reportNull$$$0(4);
        }
        if (classFqn == null) {
            PhpTestCreateInfo.$$$reportNull$$$0(5);
        }
        if (methodName == null) {
            PhpTestCreateInfo.$$$reportNull$$$0(6);
        }
        String string = "public function test" + StringUtil.capitalize((String)methodName) + "(){}";
        if (string == null) {
            PhpTestCreateInfo.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    default public Properties getDefaultProperties(@NotNull String methodName, @NotNull String classFqn) {
        if (methodName == null) {
            PhpTestCreateInfo.$$$reportNull$$$0(8);
        }
        if (classFqn == null) {
            PhpTestCreateInfo.$$$reportNull$$$0(9);
        }
        Properties properties = new Properties();
        properties.setProperty("NAME", methodName);
        properties.setProperty("CAPITALIZED_NAME", StringUtil.capitalize((String)methodName));
        properties.setProperty("TESTED_NAME", PhpLangUtil.toShortName(classFqn));
        Properties properties2 = properties;
        if (properties2 == null) {
            PhpTestCreateInfo.$$$reportNull$$$0(10);
        }
        return properties2;
    }

    public boolean canCreateTestFor(@NotNull PhpClass var1);

    default public boolean shouldPostprocessTemplateFile() {
        return false;
    }

    default public void postprocessTemplateFile(@NotNull PsiFile file) {
        if (file == null) {
            PhpTestCreateInfo.$$$reportNull$$$0(11);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromNamespace";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestCreateInfo";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestCreateInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceWithoutPrefix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMethodText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceWithoutPrefix";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethodText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultProperties";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "postprocessTemplateFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 10 -> new IllegalStateException(string);
        };
    }
}

