/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.testFramework.PhpEmptyTestDescriptor;
import com.jetbrains.php.testFramework.PhpInvalidTestFrameworkException;
import com.jetbrains.php.testFramework.PhpTestDescriptor;
import com.jetbrains.php.testFramework.PhpTestFrameworkBySdkFactory;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfigurationFactory;
import com.jetbrains.php.testFramework.PhpTestFrameworkFormDecorator;
import com.jetbrains.php.testFramework.PhpTestFrameworkLocalFactory;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTestFrameworkType
implements Comparable<PhpTestFrameworkType> {
    static final ExtensionPointName<PhpTestFrameworkType> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.php.testFrameworkType");

    public static PhpTestFrameworkType @NotNull [] getTestFrameworkTypes() {
        PhpTestFrameworkType[] phpTestFrameworkTypeArray = (PhpTestFrameworkType[])EP_NAME.getExtensions();
        if (phpTestFrameworkTypeArray == null) {
            PhpTestFrameworkType.$$$reportNull$$$0(0);
        }
        return phpTestFrameworkTypeArray;
    }

    @NotNull
    public static PhpTestFrameworkType getTestFrameworkType(@NotNull String id) throws PhpInvalidTestFrameworkException {
        if (id == null) {
            PhpTestFrameworkType.$$$reportNull$$$0(1);
        }
        for (PhpTestFrameworkType extension : (PhpTestFrameworkType[])EP_NAME.getExtensions()) {
            if (!StringUtil.equals((CharSequence)id, (CharSequence)extension.getID())) continue;
            PhpTestFrameworkType phpTestFrameworkType = extension;
            if (phpTestFrameworkType == null) {
                PhpTestFrameworkType.$$$reportNull$$$0(2);
            }
            return phpTestFrameworkType;
        }
        throw new PhpInvalidTestFrameworkException("Cannot find PHP Test Framework by ID: " + id);
    }

    @NotNull
    @Nls
    public abstract String getDisplayName();

    @NotNull
    public String[] getComposerPackageNames() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            PhpTestFrameworkType.$$$reportNull$$$0(3);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NonNls
    @NotNull
    public abstract String getID();

    @NotNull
    public abstract Icon getIcon();

    public void onEnable(@NotNull Project project, boolean enable) {
        if (project == null) {
            PhpTestFrameworkType.$$$reportNull$$$0(4);
        }
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public PhpTestFrameworkFormDecorator getDecorator() {
        return null;
    }

    @NotNull
    public List<PhpTestFrameworkConfigurationFactory> getFactories() {
        PhpTestFrameworkFormDecorator decorator = this.getDecorator();
        List<PhpTestFrameworkConfigurationFactory> list = List.of(new PhpTestFrameworkLocalFactory(this, decorator), new PhpTestFrameworkBySdkFactory(this, decorator));
        if (list == null) {
            PhpTestFrameworkType.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhpTestFrameworkType frameworkType = (PhpTestFrameworkType)o;
        return this.getID().equals(frameworkType.getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    @Override
    public final int compareTo(@NotNull PhpTestFrameworkType type) {
        if (type == null) {
            PhpTestFrameworkType.$$$reportNull$$$0(6);
        }
        boolean isPHPUnit1 = StringUtil.equals((CharSequence)this.getID(), (CharSequence)"PHPUnit");
        boolean isPHPUnit2 = StringUtil.equals((CharSequence)type.getID(), (CharSequence)"PHPUnit");
        if (!isPHPUnit1 && isPHPUnit2) {
            return 1;
        }
        if (isPHPUnit1 && !isPHPUnit2) {
            return -1;
        }
        return StringUtil.compare((String)this.getDisplayName(), (String)type.getDisplayName(), (boolean)false);
    }

    @NotNull
    public PhpTestDescriptor getDescriptor() {
        PhpEmptyTestDescriptor phpEmptyTestDescriptor = PhpEmptyTestDescriptor.INSTANCE;
        if (phpEmptyTestDescriptor == null) {
            PhpTestFrameworkType.$$$reportNull$$$0(7);
        }
        return phpEmptyTestDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFrameworkTypes";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFrameworkType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposerPackageNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactories";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTestFrameworkType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onEnable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 6 -> new IllegalArgumentException(string);
        };
    }
}

