/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpDebugProcessFactory;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import com.jetbrains.php.run.PhpDebugRunner;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.run.PhpRunConfiguration;
import com.jetbrains.php.testFramework.run.PhpTestRunConfiguration;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionServer;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class PhpTestDebugRunner<C extends PhpTestRunConfiguration>
extends PhpDebugRunner<C> {
    protected PhpTestDebugRunner(@NotNull Class<C> runConfigurationClass) {
        if (runConfigurationClass == null) {
            PhpTestDebugRunner.$$$reportNull$$$0(0);
        }
        super(runConfigurationClass);
    }

    @Override
    protected RunContentDescriptor doExecute(@NotNull PhpTestRunConfiguration runConfiguration, @NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (runConfiguration == null) {
            PhpTestDebugRunner.$$$reportNull$$$0(1);
        }
        if (state == null) {
            PhpTestDebugRunner.$$$reportNull$$$0(2);
        }
        if (env == null) {
            PhpTestDebugRunner.$$$reportNull$$$0(3);
        }
        final Project project = runConfiguration.getProject();
        final PhpInterpreter interpreter = runConfiguration.getInterpreter();
        if (interpreter == null) {
            throw new ExecutionException(PhpCommandSettingsBuilder.getInterpreterNotFoundError());
        }
        final PhpDebugExtension debugExtension = PhpProjectConfigurationFacade.getInstance(runConfiguration.getProject()).getInterpreterDebugExtension(interpreter);
        if (debugExtension == null) {
            throw new ExecutionException(PhpBundle.message("debug.error.unknown.debugger.id", new Object[0]));
        }
        final PhpIncomingDebugConnectionServer debugServer = debugExtension.startLocalDebugServer(project, interpreter);
        if (debugServer == null) {
            return null;
        }
        final PhpDebugConnectionManager connectionsManager = debugExtension.createDebugConnectionManager();
        final String sessionId = debugServer.registerSessionHandler(false, connectionsManager).getSessionId();
        try {
            Map<String, String> commandLineEnv = debugExtension.getDebugEnv(project, false, sessionId);
            PhpCommandSettings command = runConfiguration.createCommand(interpreter, commandLineEnv, (List<String>)new SmartList(), true);
            final ProcessHandler processHandler = runConfiguration.createProcessHandler(project, command, PtyCommandLine.isEnabled());
            ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)project);
            PhpPathMapper pathMapper = command.getPathProcessor().createPathMapper(project);
            SMTRunnerConsoleProperties properties = new SMTRunnerConsoleProperties((RunConfiguration)((PhpRunConfiguration)env.getRunProfile()), runConfiguration.getFrameworkName(), env.getExecutor());
            BaseTestsOutputConsoleView console = SMTestRunnerConnectionUtil.createAndAttachConsole((String)runConfiguration.getFrameworkName(), (ProcessHandler)processHandler, (TestConsoleProperties)properties);
            PhpExecutionUtil.addMessageFilters(project, (ConsoleView)console, pathMapper);
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)project).startSession(env, new XDebugProcessStarter(this, (ConsoleView)console, command){
                final /* synthetic */ ConsoleView val$console;
                final /* synthetic */ PhpCommandSettings val$command;
                {
                    this.val$console = consoleView;
                    this.val$command = phpCommandSettings;
                }

                @NotNull
                public XDebugProcess start(@NotNull XDebugSession session) {
                    if (session == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PhpTestDebugRunner.onSessionStart(session, debugServer, sessionId, connectionsManager, project, interpreter, processHandler);
                    PhpDebugDriver driver = debugExtension.getDebugDriver();
                    PhpDebugProcess phpDebugProcess = PhpDebugProcessFactory.forPhpTests(session, sessionId, connectionsManager, driver, this.val$console, this.val$command.getPathProcessor());
                    if (phpDebugProcess == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return phpDebugProcess;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "session";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/php/testFramework/run/PhpTestDebugRunner$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/php/testFramework/run/PhpTestDebugRunner$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "start";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "start";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            });
            processHandler.startNotify();
            return debugSession.getRunContentDescriptor();
        }
        catch (ExecutionException e) {
            debugServer.unregisterSessionHandler(sessionId);
            throw e;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurationClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/testFramework/run/PhpTestDebugRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

