/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpTestFrameworkVersionDetector;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.testFramework.ui.PhpTestAdditionalInfoComponent;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkConfigurableForm;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkVersionComponent;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.PhpConfigurationUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTestFrameworkBaseConfigurableForm<C extends PhpTestFrameworkConfiguration>
implements PhpTestFrameworkConfigurableForm<C>,
Iconable {
    private JPanel myMainPanel;
    protected JBCheckBox myUseConfigurationFileJBCheckBox;
    protected TextFieldWithBrowseButton myConfigurationFileTextField;
    protected TextFieldWithBrowseButton myExecutablePathTextField;
    protected JPanel myExecutablePathPanel;
    private JBLabel myPathToExeLabel;
    private JPanel myLibraryPanel;
    protected JPanel myInfoPanel;
    private JPanel myVersionPanel;
    private final List<PhpFilePathUpdateListener> myExecutionPathListeners;
    private final List<PhpFilePathUpdateListener> myConfigurationPathListeners;
    @Nullable
    private PhpTestFrameworkVersionComponent myVersionComponent;
    @Nullable
    private PhpTestAdditionalInfoComponent myInfoComponent;
    private HyperlinkLabel myDownloadHyperlinkLabel;
    @NotNull
    protected final Project myProject;
    protected C myConfiguration;
    private final PhpTestFrameworkType myFrameworkType;

    public PhpTestFrameworkBaseConfigurableForm(@NotNull Project project, @NotNull PhpTestFrameworkType frameworkType, @NotNull C configuration) {
        if (project == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(0);
        }
        if (frameworkType == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(2);
        }
        this.$$$setupUI$$$();
        this.myExecutionPathListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myConfigurationPathListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.myConfiguration = configuration;
        this.myFrameworkType = frameworkType;
        this.myPathToExeLabel.setText(PhpBundle.message("php.test.framework.configuration.ui.path.to.exe", frameworkType.getDisplayName()));
        String title = PhpBundle.message("php.test.framework.configuration.ui.library", frameworkType.getDisplayName());
        this.myLibraryPanel.setBorder(IdeBorderFactory.createTitledBorder((String)title));
        this.myExecutablePathTextField.setText(configuration.getExecutablePath());
        ActionListener updateStateActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpTestFrameworkBaseConfigurableForm.this.updateConfigurationFile();
            }
        };
        this.myUseConfigurationFileJBCheckBox.addActionListener(updateStateActionListener);
        this.myExecutablePathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter((PhpTestFrameworkConfiguration)configuration){
            final /* synthetic */ PhpTestFrameworkConfiguration val$configuration;
            {
                this.val$configuration = phpTestFrameworkConfiguration;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                String executable = PhpTestFrameworkBaseConfigurableForm.this.getPathToExecutable();
                this.val$configuration.setImmediateExecutablePath(executable);
                for (PhpFilePathUpdateListener listener : PhpTestFrameworkBaseConfigurableForm.this.myExecutionPathListeners) {
                    listener.onFileUpdated(executable);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/testFramework/ui/PhpTestFrameworkBaseConfigurableForm$2", "textChanged"));
            }
        });
        this.myConfigurationFileTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                for (PhpFilePathUpdateListener listener : PhpTestFrameworkBaseConfigurableForm.this.myConfigurationPathListeners) {
                    listener.onFileUpdated(PhpTestFrameworkBaseConfigurableForm.this.myConfigurationFileTextField.getText());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/testFramework/ui/PhpTestFrameworkBaseConfigurableForm$3", "textChanged"));
            }
        });
        this.myVersionPanel.setLayout(new BorderLayout());
        this.myVersionPanel.setVisible(false);
        this.myInfoPanel.setLayout(new BorderLayout());
        this.setAdditionalInfoComponent(null);
    }

    public void setActionsToolbar(AnAction ... actions) {
        if (actions == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(3);
        }
        this.myExecutablePathPanel.add((Component)PhpUiUtil.createHorizontalActionsToolbar("PhpTestFrameworksToolbar", actions), "East");
    }

    public void addExecutionPathListener(@NotNull PhpFilePathUpdateListener listener) {
        if (listener == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(4);
        }
        this.myExecutionPathListeners.add(listener);
    }

    public void addConfigurationPathListener(@NotNull PhpFilePathUpdateListener listener) {
        if (listener == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(5);
        }
        this.myConfigurationPathListeners.add(listener);
    }

    public String getPathToExecutable() {
        return this.myExecutablePathTextField.getText();
    }

    public void setPathToExecutable(@NotNull @NlsSafe String path) {
        if (path == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(6);
        }
        this.myExecutablePathTextField.setText(path);
    }

    public void setVersionDetector(@NotNull PhpTestFrameworkVersionDetector versionDetector) {
        if (versionDetector == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(7);
        }
        if (this.myVersionComponent != null) {
            this.myVersionPanel.removeAll();
        }
        this.myVersionComponent = new PhpTestFrameworkVersionComponent(this.myProject, this.myFrameworkType, versionDetector, this);
        this.myVersionPanel.setVisible(true);
        this.myVersionPanel.add((Component)this.myVersionComponent.getComponent(), "Center");
    }

    @Override
    @Nullable
    public String getExecutablePath() {
        return this.myExecutablePathTextField.getText();
    }

    @Override
    @Nullable
    public String getLastDetectedVersion() {
        if (this.myVersionComponent != null) {
            return this.myVersionComponent.getVersion();
        }
        return null;
    }

    public void setAdditionalInfoComponent(@Nullable PhpTestAdditionalInfoComponent info) {
        if (this.myInfoComponent != null) {
            this.myInfoPanel.removeAll();
        }
        this.myInfoComponent = info;
        this.myInfoPanel.setVisible(this.myInfoComponent != null);
        if (this.myInfoComponent != null) {
            this.myInfoPanel.add((Component)this.myInfoComponent.getComponent(), "Center");
        }
    }

    public void setDownloadLink(@Nullable @NlsSafe String downloadLink) {
        if (StringUtil.isNotEmpty((String)downloadLink)) {
            this.myDownloadHyperlinkLabel.setHtmlText(PhpBundle.message("php.test.framework.download.hyperlink", this.myFrameworkType.getDisplayName(), downloadLink));
            this.myDownloadHyperlinkLabel.setHyperlinkTarget(downloadLink);
        } else {
            this.myDownloadHyperlinkLabel.setVisible(false);
        }
    }

    @Override
    @NotNull
    public C getConfiguration() {
        C c = this.myConfiguration;
        if (c == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(8);
        }
        return c;
    }

    protected void addBrowseFolderListener(@NotNull Project project, @NotNull TextFieldWithBrowseButton textField, final @NotNull List<PhpFilePathUpdateListener> listeners, boolean folderAllowed) {
        if (project == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(9);
        }
        if (textField == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(10);
        }
        if (listeners == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(11);
        }
        FileChooserDescriptor descriptor = folderAllowed ? FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor() : FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        TextBrowseFolderListener listener = new TextBrowseFolderListener(descriptor, project){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    4.$$$reportNull$$$0(0);
                }
                super.onFileChosen(chosenFile);
                PhpTestFrameworkBaseConfigurableForm.this.onExecutablePathChosen(chosenFile.getPath(), listeners);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/php/testFramework/ui/PhpTestFrameworkBaseConfigurableForm$4", "onFileChosen"));
            }
        };
        textField.addBrowseFolderListener(listener);
    }

    protected void onExecutablePathChosen(@NotNull String path, @NotNull List<PhpFilePathUpdateListener> listeners) {
        if (path == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(12);
        }
        if (listeners == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(13);
        }
        for (PhpFilePathUpdateListener listener : listeners) {
            listener.onFileChosen(path);
        }
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(14);
        }
        return project;
    }

    @Nullable
    public JComponent createComponent() {
        this.addBrowseFolderListener(this.myProject, this.myExecutablePathTextField, this.myExecutionPathListeners, true);
        this.addBrowseFolderListener(this.myProject, this.myConfigurationFileTextField, this.myConfigurationPathListeners, false);
        return this.myMainPanel;
    }

    public boolean isModified() {
        return this.isModified(this.getConfiguration());
    }

    protected boolean isModified(@NotNull C state) {
        if (state == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(15);
        }
        if (PhpConfigurationUtil.isModified(this.myExecutablePathTextField, state.getExecutablePath())) {
            return true;
        }
        if (this.myUseConfigurationFileJBCheckBox.isSelected() != state.isUseConfigurationFile()) {
            return true;
        }
        if (PhpConfigurationUtil.isModified(this.myConfigurationFileTextField, state.getConfigurationFilePath())) {
            return true;
        }
        if (this.myVersionComponent != null && this.myVersionComponent.isModified((PhpTestFrameworkConfiguration)state)) {
            return true;
        }
        return this.myInfoComponent != null && this.myInfoComponent.isModified((PhpTestFrameworkConfiguration)state);
    }

    public void apply() {
        this.apply(this.getConfiguration());
    }

    protected void apply(@NotNull C state) {
        if (state == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(16);
        }
        state.setExecutablePath(this.myExecutablePathTextField.getText());
        state.setUseConfigurationFile(this.myUseConfigurationFileJBCheckBox.isSelected());
        state.setConfigurationFilePath(StringUtil.nullize((String)this.myConfigurationFileTextField.getText()));
        if (this.myVersionComponent != null) {
            this.myVersionComponent.apply((PhpTestFrameworkConfiguration)state);
        }
        if (this.myInfoComponent != null) {
            this.myInfoComponent.apply((PhpTestFrameworkConfiguration)state);
        }
    }

    public void reset() {
        this.reset(this.getConfiguration());
    }

    protected void reset(@NotNull C state) {
        if (state == null) {
            PhpTestFrameworkBaseConfigurableForm.$$$reportNull$$$0(17);
        }
        this.myExecutablePathTextField.setText(state.getExecutablePath());
        this.myUseConfigurationFileJBCheckBox.setSelected(state.isUseConfigurationFile());
        this.myConfigurationFileTextField.setText(state.getConfigurationFilePath());
        this.updateConfigurationFile();
        if (this.myVersionComponent != null) {
            this.myVersionComponent.reset((PhpTestFrameworkConfiguration)state);
        }
        if (this.myInfoComponent != null) {
            this.myInfoComponent.reset((PhpTestFrameworkConfiguration)state);
        }
    }

    private void updateConfigurationFile() {
        this.myConfigurationFileTextField.setEnabled(this.myUseConfigurationFileJBCheckBox.isSelected());
        String newPath = this.myUseConfigurationFileJBCheckBox.isSelected() ? this.myConfigurationFileTextField.getText() : "";
        for (PhpFilePathUpdateListener listener : this.myConfigurationPathListeners) {
            listener.onFileUpdated(newPath);
        }
    }

    public void disposeUIResources() {
        if (this.myVersionComponent != null) {
            this.myVersionComponent.disposeUIResources();
        }
        if (this.myInfoComponent != null) {
            this.myInfoComponent.disposeUIResources();
        }
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return this.myFrameworkType != null ? this.myFrameworkType.getIcon() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionDetector";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/ui/PhpTestFrameworkBaseConfigurableForm";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/ui/PhpTestFrameworkBaseConfigurableForm";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setActionsToolbar";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addExecutionPathListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addConfigurationPathListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPathToExecutable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setVersionDetector";
                break;
            }
            case 8: 
            case 14: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addBrowseFolderListener";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onExecutablePathChosen";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 14 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        HyperlinkLabel hyperlinkLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        JBLabel jBLabel;
        JPanel jPanel3;
        JPanel jPanel4;
        JBCheckBox jBCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel5;
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 5, 5, 5), -1, -1, false, false));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestFrameworkBaseConfigurableForm.class).getString("php.test.framework.configuration.ui.test.runner"), (int)0, (int)0, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myConfigurationFileTextField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myUseConfigurationFileJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestFrameworkBaseConfigurableForm.class).getString("php.test.framework.configuration.ui.use.configuration.file"));
        jPanel7.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInfoPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLibraryPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestFrameworkBaseConfigurableForm.class).getString("php.test.framework.configuration.ui.library"), (int)0, (int)0, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPathToExeLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpTestFrameworkBaseConfigurableForm.class).getString("php.test.framework.configuration.ui.path.to.exe"));
        jPanel8.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExecutablePathPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myExecutablePathTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, "Center");
        this.myDownloadHyperlinkLabel = hyperlinkLabel = new HyperlinkLabel();
        jPanel8.add((Component)hyperlinkLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myVersionPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface PhpFilePathUpdateListener {
        default public void onFileChosen(@NotNull String path) {
            if (path == null) {
                PhpFilePathUpdateListener.$$$reportNull$$$0(0);
            }
        }

        public void onFileUpdated(@NotNull String var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/php/testFramework/ui/PhpTestFrameworkBaseConfigurableForm$PhpFilePathUpdateListener", "onFileChosen"));
        }
    }
}

