/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.messDetector;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.tools.quality.QualityToolConfigurationComboBox;
import com.jetbrains.php.tools.quality.QualityToolsOptionsPanel;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorOptionsConfiguration;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorQualityToolType;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorRulesetAnalyzer;
import com.jetbrains.php.tools.quality.messDetector.RulesetDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessDetectorOptionsPanel
extends QualityToolsOptionsPanel {
    private JPanel myContentPane;
    private JBTable myCustomRulesetTable;
    private JPanel myToolBarPanel;
    private JBCheckBox myCodeSizeCheckBox;
    private JBCheckBox myControversialCheckBox;
    private JBCheckBox myDessignCheckBox;
    private JBCheckBox myNamingCheckBox;
    private JBCheckBox myUnusedCodeRulesJBCheckBox;
    private CustomRulesetTableModel myRulesetTableModelModel;
    private List<RulesetDescriptor> rulesets;
    private final QualityToolConfigurationComboBox myComboBox;

    public MessDetectorOptionsPanel(Project project, QualityToolConfigurationComboBox comboBox, Runnable validate) {
        super(project, validate, MessDetectorQualityToolType.INSTANCE);
        this.myComboBox = comboBox;
        this.$$$setupUI$$$();
        DefaultActionGroup group = new DefaultActionGroup();
        ActionToolbar detector = ActionManager.getInstance().createActionToolbar("PhpMessDetector", (ActionGroup)group, true);
        detector.setTargetComponent((JComponent)this.myCustomRulesetTable);
        JComponent toolBar = detector.getComponent();
        MessDetectorOptionsConfiguration instance = MessDetectorOptionsConfiguration.getInstance(project);
        this.rulesets = new ArrayList<RulesetDescriptor>(instance.getCustomRulesets());
        this.myRulesetTableModelModel = new CustomRulesetTableModel(this.rulesets);
        this.myCustomRulesetTable.setModel((TableModel)this.myRulesetTableModelModel);
        this.myCustomRulesetTable.addPropertyChangeListener(i -> validate.run());
        group.add(new AnAction(PhpBundle.message("add.rule", new Object[0]), null, AllIcons.General.Add){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                MessDetectorOptionsPanel.this.addCustomRule();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/messDetector/MessDetectorOptionsPanel$1", "actionPerformed"));
            }
        });
        group.add((AnAction)new DumbAwareAction(PhpBundle.message("remove.rule", new Object[0]), null, AllIcons.General.Remove){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                MessDetectorOptionsPanel.this.removeCustomRule();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(MessDetectorOptionsPanel.this.myCustomRulesetTable.getSelectedRows().length > 0);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/tools/quality/messDetector/MessDetectorOptionsPanel$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/tools/quality/messDetector/MessDetectorOptionsPanel$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
        this.myToolBarPanel.add((Component)toolBar, "Center");
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.myContentPane;
    }

    @Override
    public void reset() {
        MessDetectorOptionsConfiguration instance = MessDetectorOptionsConfiguration.getInstance(this.myProject);
        this.myControversialCheckBox.setSelected(instance.isControversial());
        this.myCodeSizeCheckBox.setSelected(instance.isCodeSize());
        this.myDessignCheckBox.setSelected(instance.isDesign());
        this.myNamingCheckBox.setSelected(instance.isNaming());
        this.myUnusedCodeRulesJBCheckBox.setSelected(instance.isUnusedCode());
        this.rulesets = new ArrayList<RulesetDescriptor>(instance.getCustomRulesets());
        this.myRulesetTableModelModel = new CustomRulesetTableModel(this.rulesets);
        this.myCustomRulesetTable.setModel((TableModel)this.myRulesetTableModelModel);
    }

    @Override
    public boolean isModified() {
        MessDetectorOptionsConfiguration instance = MessDetectorOptionsConfiguration.getInstance(this.myProject);
        if (this.myUnusedCodeRulesJBCheckBox.isSelected() != instance.isUnusedCode()) {
            return true;
        }
        if (this.myControversialCheckBox.isSelected() != instance.isControversial()) {
            return true;
        }
        if (this.myNamingCheckBox.isSelected() != instance.isNaming()) {
            return true;
        }
        if (this.myDessignCheckBox.isSelected() != instance.isDesign()) {
            return true;
        }
        if (this.myCodeSizeCheckBox.isSelected() != instance.isCodeSize()) {
            return true;
        }
        List<RulesetDescriptor> rulesets1 = instance.getCustomRulesets();
        ArrayList<RulesetDescriptor> rulesetDescriptors = new ArrayList<RulesetDescriptor>();
        for (int i = 0; i < this.myRulesetTableModelModel.getRowCount(); ++i) {
            rulesetDescriptors.add(this.myRulesetTableModelModel.getDescriptorAt(i));
        }
        return rulesets1.size() != rulesetDescriptors.size() || !MessDetectorOptionsPanel.listEqualsIgnoreOrder(rulesets1, rulesetDescriptors);
    }

    public static <T> boolean listEqualsIgnoreOrder(List<T> list1, List<T> list2) {
        return new HashSet<T>(list1).equals(new HashSet<T>(list2));
    }

    @Override
    public void apply() {
        MessDetectorOptionsConfiguration instance = MessDetectorOptionsConfiguration.getInstance(this.myProject);
        instance.setCodeSize(this.myCodeSizeCheckBox.isSelected());
        instance.setControversial(this.myControversialCheckBox.isSelected());
        instance.setDesign(this.myDessignCheckBox.isSelected());
        instance.setNaming(this.myNamingCheckBox.isSelected());
        instance.setUnusedCode(this.myUnusedCodeRulesJBCheckBox.isSelected());
        ArrayList<RulesetDescriptor> rulesetDescriptors = new ArrayList<RulesetDescriptor>();
        for (int i = 0; i < this.myRulesetTableModelModel.getRowCount(); ++i) {
            rulesetDescriptors.add(this.myRulesetTableModelModel.getDescriptorAt(i));
        }
        instance.setCustomRulesets(rulesetDescriptors);
    }

    private void createUIComponents() {
    }

    private void addCustomRule() {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withExtensionFilter(IdeCoreBundle.message((String)"file.chooser.files.label", (Object[])new Object[]{"XML|DIST"}), new String[]{"xml", "dist"});
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Component)this.myContentPane, null, (VirtualFile)this.getPreselectedFile());
        if (file != null) {
            this.addRuleDescriptor(file.getPath(), file);
        }
    }

    void addRuleDescriptor(@NotNull String originalPath, @NotNull VirtualFile file) {
        RulesetDescriptor descriptor;
        if (originalPath == null) {
            MessDetectorOptionsPanel.$$$reportNull$$$0(0);
        }
        if (file == null) {
            MessDetectorOptionsPanel.$$$reportNull$$$0(1);
        }
        if ((descriptor = MessDetectorRulesetAnalyzer.readRulesetFile(originalPath, file)) != null) {
            int row = this.myRulesetTableModelModel.addDescriptor(descriptor);
            this.myCustomRulesetTable.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    @Nullable
    private VirtualFile getPreselectedFile() {
        File file;
        RulesetDescriptor descriptor;
        int[] selectedRows = this.myCustomRulesetTable.getSelectedRows();
        if (selectedRows.length > 0 && (descriptor = this.myRulesetTableModelModel.getDescriptorAt(selectedRows[0])) != null && descriptor.isValid(false) && (file = new File(descriptor.getPath())).exists()) {
            return VfsUtil.findFileByIoFile((File)file, (boolean)true);
        }
        return null;
    }

    @Override
    protected boolean containsRulesetXml(VirtualFile file) {
        return MessDetectorRulesetAnalyzer.readRulesetFile(file) != null;
    }

    @Override
    @Nullable
    protected String validatePath() {
        PhpInterpreter interpreter = this.getSelectedInterpreter(this.myProject, this.myComboBox);
        if (interpreter != null && interpreter.isRemote()) {
            return null;
        }
        for (RulesetDescriptor descriptor : this.myRulesetTableModelModel.myRulesetDescriptors) {
            URL url = VfsUtilCore.convertToURL((String)VfsUtilCore.pathToUrl((String)descriptor.getPath()));
            if (url != null && VfsUtil.findFileByURL((URL)url) != null) continue;
            return PhpBundle.message("config.file.doesnt.exist", new Object[0]);
        }
        return null;
    }

    private void removeCustomRule() {
        int[] selectedRows = this.myCustomRulesetTable.getSelectedRows();
        if (selectedRows.length > 0) {
            this.myRulesetTableModelModel.removeDescriptors(selectedRows);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "originalPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/tools/quality/messDetector/MessDetectorOptionsPanel";
        objectArray[2] = "addRuleDescriptor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTable jBTable;
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JPanel jPanel2;
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCodeSizeCheckBox = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/PhpBundle", MessDetectorOptionsPanel.class).getString("code.size.rules"));
        jPanel3.add((Component)jBCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myControversialCheckBox = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/PhpBundle", MessDetectorOptionsPanel.class).getString("controversial.rules"));
        jPanel3.add((Component)jBCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDessignCheckBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/PhpBundle", MessDetectorOptionsPanel.class).getString("design.rules"));
        jPanel3.add((Component)jBCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNamingCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", MessDetectorOptionsPanel.class).getString("naming.rules"));
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUnusedCodeRulesJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", MessDetectorOptionsPanel.class).getString("unused.code.rules"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", MessDetectorOptionsPanel.class).getString("quality.tool.label.custom.rulesets"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myToolBarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 7, new Dimension(-1, 70), null, null));
        this.myCustomRulesetTable = jBTable = new JBTable();
        jBTable.setAutoCreateRowSorter(false);
        jBTable.setFillsViewportHeight(true);
        jBScrollPane.setViewportView((Component)jBTable);
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class CustomRulesetTableModel
    extends AbstractTableModel {
        private final List<RulesetDescriptor> myRulesetDescriptors;

        CustomRulesetTableModel(List<RulesetDescriptor> rulesetDescriptors) {
            this.myRulesetDescriptors = rulesetDescriptors;
        }

        @Override
        public int getRowCount() {
            return this.myRulesetDescriptors == null ? 0 : this.myRulesetDescriptors.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return switch (columnIndex) {
                case 0 -> PhpBundle.message("name", new Object[0]);
                case 1 -> PhpBundle.message("file", new Object[0]);
                default -> null;
            };
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return switch (columnIndex) {
                case 0 -> this.myRulesetDescriptors.get(rowIndex).getName();
                case 1 -> {
                    boolean remote;
                    RulesetDescriptor descriptor = this.myRulesetDescriptors.get(rowIndex);
                    PhpInterpreter interpreter = MessDetectorOptionsPanel.this.getSelectedInterpreter(MessDetectorOptionsPanel.this.myProject, MessDetectorOptionsPanel.this.myComboBox);
                    boolean v1 = remote = interpreter != null && interpreter.isRemote();
                    if (descriptor.isValid(remote)) {
                        yield descriptor.getPath();
                    }
                    yield "<does not exist>";
                }
                default -> null;
            };
        }

        public int addDescriptor(RulesetDescriptor rulesetDescriptor) {
            this.myRulesetDescriptors.add(rulesetDescriptor);
            this.fireTableDataChanged();
            return this.myRulesetDescriptors.size() - 1;
        }

        public void removeDescriptors(int[] rowIndices) {
            ArrayList<RulesetDescriptor> toRemove = new ArrayList<RulesetDescriptor>();
            for (int rowIndex : rowIndices) {
                toRemove.add(this.myRulesetDescriptors.get(rowIndex));
            }
            this.myRulesetDescriptors.removeAll(toRemove);
            this.fireTableDataChanged();
        }

        public RulesetDescriptor getDescriptorAt(int rowIndex) {
            return rowIndex < 0 || rowIndex >= this.myRulesetDescriptors.size() ? null : this.myRulesetDescriptors.get(rowIndex);
        }
    }
}

