/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.ui;

import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpParameterHintManager {
    public static final String PASS_BY_REF_FOR_NAMED_ARGUMENT = "&&";
    @NotNull
    private final List<InlayInfo> myDescriptors;

    public PhpParameterHintManager(@NotNull ParameterListOwner callExpression, boolean showForAll, boolean passByRef) {
        if (callExpression == null) {
            PhpParameterHintManager.$$$reportNull$$$0(0);
        }
        PsiElement[] callArguments = callExpression.getParameters();
        PsiElement resolveResult = null;
        List<Object> descriptors = Collections.emptyList();
        if (callExpression instanceof NewExpression) {
            ClassReference classReference = ((NewExpression)callExpression).getClassReference();
            if (classReference != null) {
                resolveResult = classReference.resolve();
            }
            if (resolveResult instanceof PhpClass) {
                resolveResult = ((PhpClass)resolveResult).getConstructor();
            }
        } else if (callExpression instanceof FunctionReference) {
            resolveResult = ((FunctionReference)callExpression).resolve();
        }
        if (resolveResult instanceof Function) {
            Function method = (Function)resolveResult;
            if (showForAll || passByRef || PhpParameterHintManager.isMethodToShowParams(resolveResult) && PhpParameterHintManager.hasUnclearExpressions(callArguments)) {
                Parameter[] parameters = method.getParameters();
                descriptors = PhpParameterHintManager.buildDescriptors(callArguments, parameters, showForAll, passByRef);
            }
        }
        this.myDescriptors = descriptors;
    }

    private static boolean isMethodToShowParams(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            PhpParameterHintManager.$$$reportNull$$$0(1);
        }
        if (resolveResult instanceof Function) {
            Function method = (Function)resolveResult;
            return !PhpParameterHintManager.isSetter(method);
        }
        return false;
    }

    private static boolean hasSingleParameter(Function method) {
        return method.getParameters().length == 1;
    }

    private static boolean isSetter(Function method) {
        String methodName = method.getName();
        return PhpParameterHintManager.hasSingleParameter(method) && methodName.startsWith("set") && (methodName.length() == 3 || Character.isUpperCase(methodName.charAt(3)));
    }

    static boolean isUnclearExpression(@Nullable PsiElement callArgument) {
        if (PhpPsiUtil.isOfType(callArgument, PhpElementTypes.NUMBER, PhpElementTypes.STRING)) {
            return true;
        }
        if (callArgument instanceof UnaryExpression) {
            UnaryExpression expr = (UnaryExpression)callArgument;
            PsiElement operation = expr.getOperation();
            return PhpPsiUtil.isOfType(operation, PhpTokenTypes.opMINUS, PhpTokenTypes.opPLUS) && PhpPsiUtil.isOfType((PsiElement)expr.getValue(), PhpElementTypes.NUMBER);
        }
        return callArgument instanceof ConstantReference || callArgument instanceof ClassConstantReference || callArgument instanceof BinaryExpression || callArgument instanceof TernaryExpression;
    }

    @NotNull
    public List<InlayInfo> getDescriptors() {
        List<InlayInfo> list = this.myDescriptors;
        if (list == null) {
            PhpParameterHintManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private static List<InlayInfo> buildDescriptors(PsiElement @NotNull [] callArguments, Parameter @NotNull [] parameters, boolean showForAll, boolean passByRef) {
        if (callArguments == null) {
            PhpParameterHintManager.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            PhpParameterHintManager.$$$reportNull$$$0(4);
        }
        ArrayList<InlayInfo> descriptors = new ArrayList<InlayInfo>();
        for (int i = 0; i < Math.min(callArguments.length, parameters.length); ++i) {
            PsiElement arg = callArguments[i];
            Parameter param = PhpParamsInspection.getMappedParam(Arrays.asList(callArguments), Arrays.asList(parameters), i);
            if (param == null || !(showForAll || passByRef && param.isPassByRef() || param.isVariadic() && PhpParameterHintManager.hasUnclearExpressionStartingFrom(i, callArguments)) && !PhpParameterHintManager.shouldInlineParameterName(arg, param)) continue;
            PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(arg);
            if (nameIdentifier != null) {
                if (!param.isPassByRef()) continue;
                descriptors.add(new InlayInfo(PASS_BY_REF_FOR_NAMED_ARGUMENT, nameIdentifier.getTextRange().getStartOffset()));
                continue;
            }
            descriptors.add(PhpParameterHintManager.createInlayInfo(arg, param, showForAll, passByRef));
        }
        ArrayList<InlayInfo> arrayList = descriptors;
        if (arrayList == null) {
            PhpParameterHintManager.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static InlayInfo createInlayInfo(@NotNull PsiElement callArgument, @NotNull Parameter methodParam, boolean showForAll, boolean passByRef) {
        if (callArgument == null) {
            PhpParameterHintManager.$$$reportNull$$$0(6);
        }
        if (methodParam == null) {
            PhpParameterHintManager.$$$reportNull$$$0(7);
        }
        String paramName = methodParam.getName();
        String shownName = passByRef && !showForAll && callArgument instanceof PhpNamedElement && paramName.equals(((PhpNamedElement)callArgument).getName()) ? "" : paramName;
        String text = (methodParam.isPassByRef() ? "&" : "") + (methodParam.isVariadic() ? "..." : "") + shownName;
        return new InlayInfo(text, callArgument.getTextRange().getStartOffset());
    }

    private static boolean shouldInlineParameterName(@NotNull PsiElement argument, @NotNull Parameter parameter) {
        if (argument == null) {
            PhpParameterHintManager.$$$reportNull$$$0(8);
        }
        if (parameter == null) {
            PhpParameterHintManager.$$$reportNull$$$0(9);
        }
        if (parameter instanceof ConstantReference) {
            return false;
        }
        if (parameter.isPassByRef()) {
            return false;
        }
        if (argument instanceof Variable && PhpLangUtil.equalsVariableNames(parameter.getName(), ((Variable)argument).getName())) {
            return false;
        }
        return PhpParameterHintManager.isUnclearExpression(argument);
    }

    private static boolean hasUnclearExpressionStartingFrom(int index, PsiElement[] callArguments) {
        for (int i = index; i < callArguments.length; ++i) {
            PsiElement arg = callArguments[i];
            if (!PhpParameterHintManager.isUnclearExpression(arg)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasUnclearExpressions(PsiElement @NotNull [] arguments) {
        if (arguments == null) {
            PhpParameterHintManager.$$$reportNull$$$0(10);
        }
        for (PsiElement argument : arguments) {
            if (!PhpParameterHintManager.isUnclearExpression(argument)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/ui/PhpParameterHintManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callArguments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callArgument";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodParam";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/ui/PhpParameterHintManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMethodToShowParams";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildDescriptors";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createInlayInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldInlineParameterName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasUnclearExpressions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

