/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.util;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.php.lang.intentions.PhpReplaceQuotesIntention;
import com.jetbrains.php.lang.lexer.PhpStringLiteralLexer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpStringUtil {
    private static final BidirectionalMap<Character, String> escapeMapDQ = new BidirectionalMap();
    private static final BidirectionalMap<Character, String> escapeMapSQ = new BidirectionalMap();

    public static String @NotNull [] intersectFromBegin(String[] arr1, String[] arr2, boolean caseSensitive) {
        int i;
        for (i = 0; i < arr1.length && i < arr2.length && (caseSensitive ? arr1[i].equals(arr2[i]) : arr1[i].equalsIgnoreCase(arr2[i])); ++i) {
        }
        String[] stringArray = Arrays.copyOf(arr1, i);
        if (stringArray == null) {
            PhpStringUtil.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    public static String @NotNull [] intersectFromEnd(String[] arr1, String[] arr2, boolean caseSensitive) {
        int i1 = arr1.length - 1;
        for (int i2 = arr2.length - 1; i1 > -1 && i2 > -1 && (caseSensitive ? arr1[i1].equals(arr2[i2]) : arr1[i1].equalsIgnoreCase(arr2[i2])); --i1, --i2) {
        }
        String[] stringArray = Arrays.copyOfRange(arr1, i1 + 1, arr1.length);
        if (stringArray == null) {
            PhpStringUtil.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    public static String @NotNull [] subtractFromBegin(String[] where, String[] what, boolean caseSensitive) {
        int i;
        for (i = 0; i < where.length && i < what.length && PhpStringUtil.isEquals(what[i], where[i], caseSensitive); ++i) {
        }
        String[] stringArray = i == 0 ? where : Arrays.copyOfRange(where, i, where.length);
        if (stringArray == null) {
            PhpStringUtil.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    public static String @NotNull [] subtractFromEnd(String[] where, String[] what, boolean caseSensitive) {
        int iWhere = where.length - 1;
        for (int iWhat = what.length - 1; iWhere > -1 && iWhat > -1 && (caseSensitive ? where[iWhere].equals(what[iWhat]) : where[iWhere].equalsIgnoreCase(what[iWhat])); --iWhere, --iWhat) {
        }
        String[] stringArray = Arrays.copyOf(where, iWhere + 1);
        if (stringArray == null) {
            PhpStringUtil.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    public static boolean isPrefix(String[] where, String[] what, boolean caseSensitive) {
        for (int i = 0; i < what.length; ++i) {
            if (i < where.length && PhpStringUtil.isEquals(what[i], where[i], caseSensitive)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrefix(String[] where, String[] what) {
        return PhpStringUtil.isPrefix(where, what, false);
    }

    public static boolean isSuffix(String[] where, String[] what) {
        int iR = where.length - 1;
        for (int iL = what.length - 1; iR > -1 && iL > -1; --iR, --iL) {
            if (what[iL].equalsIgnoreCase(where[iR])) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquals(String[] a, String[] b, boolean caseSensitive) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (!(caseSensitive ? !a[i].equals(b[i]) : !a[i].equalsIgnoreCase(b[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquals(@NotNull String a, @NotNull String b, boolean caseSensitive) {
        if (a == null) {
            PhpStringUtil.$$$reportNull$$$0(4);
        }
        if (b == null) {
            PhpStringUtil.$$$reportNull$$$0(5);
        }
        return caseSensitive ? a.equals(b) : a.equalsIgnoreCase(b);
    }

    private static void escapeStringCharacters(int length, @NotNull String str, @NotNull @NonNls StringBuilder buffer, boolean isSingleLiteral, Set<Character> filter, BidirectionalMap<Character, String> escapeMap) {
        if (str == null) {
            PhpStringUtil.$$$reportNull$$$0(6);
        }
        if (buffer == null) {
            PhpStringUtil.$$$reportNull$$$0(7);
        }
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            String escapedChar = PhpStringUtil.getEscapedChar(filter, escapeMap, ch);
            if (isSingleLiteral && ch == '\\' && str.substring(idx).length() > 1 && !escapeMapSQ.containsKey((Object)Character.valueOf(str.charAt(idx + 1))) || escapedChar == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(escapedChar);
        }
    }

    @Nullable
    private static String getEscapedChar(Set<Character> filter, BidirectionalMap<Character, String> escapeMap, char ch) {
        return filter.contains(Character.valueOf(ch)) ? null : (String)escapeMap.get((Object)Character.valueOf(ch));
    }

    public static String escapeText(String arg, boolean isSingleLiteral) {
        return PhpStringUtil.escapeText(arg, isSingleLiteral, Collections.emptySet());
    }

    @Deprecated
    public static String escapeText(String arg, boolean isSingleLiteral, Character ... exceptedEscapeSymbols) {
        return PhpStringUtil.escapeText(arg, isSingleLiteral, Set.of(exceptedEscapeSymbols));
    }

    public static String escapeText(String arg, boolean isSingleLiteral, Set<Character> exceptedEscapeSymbols) {
        BidirectionalMap<Character, String> escapeMap = isSingleLiteral ? escapeMapSQ : escapeMapDQ;
        for (int c = 0; c < arg.length(); ++c) {
            if (PhpStringUtil.getEscapedChar(exceptedEscapeSymbols, escapeMap, arg.charAt(c)) == null) continue;
            StringBuilder buffer = new StringBuilder(arg.length());
            PhpStringUtil.escapeStringCharacters(arg.length(), arg, buffer, isSingleLiteral, exceptedEscapeSymbols, escapeMap);
            return buffer.toString();
        }
        return arg;
    }

    public static String unescapeText(String arg, boolean isSingleLiteral, Set<String> exceptedSet) {
        return StreamSupport.stream(new StringLiteralSpliterator(arg, isSingleLiteral), false).reduce("", (result, pair) -> result + PhpStringUtil.tryUnescapeChar((Pair<TextRange, IElementType>)pair, arg, isSingleLiteral, exceptedSet), String::concat);
    }

    public static String unescapeText(String arg, boolean isSingleLiteral) {
        return PhpStringUtil.unescapeText(arg, isSingleLiteral, Collections.emptySet());
    }

    @Deprecated
    public static String unescapeText(String arg, boolean isSingleLiteral, String ... exceptedEscapeSymbols) {
        return PhpStringUtil.unescapeText(arg, isSingleLiteral, Set.of(exceptedEscapeSymbols));
    }

    private static String tryUnescapeChar(Pair<TextRange, IElementType> pair, String text, boolean isSingleLiteral, Set<String> exceptedSet) {
        String tokenText = ((TextRange)pair.first).substring(text);
        return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN.equals(pair.second) && !exceptedSet.contains(tokenText) ? PhpStringUtil.unescapeChar(tokenText, isSingleLiteral) : tokenText;
    }

    public static boolean isUnescapableText(String arg, boolean isSingleLiteral) {
        return StreamSupport.stream(new StringLiteralSpliterator(arg, isSingleLiteral), false).noneMatch(pair -> StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN.equals(pair.second) || PhpStringUtil.isBadEscapeSymbol((IElementType)pair.second, ((TextRange)pair.first).substring(arg)));
    }

    private static boolean isBadEscapeSymbol(IElementType type, String tokenText) {
        return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN.equals(type) && tokenText.equals("\\r");
    }

    @NotNull
    private static String unescapeChar(String token, boolean isSingleLiteral) {
        List unescapedChar;
        List list = unescapedChar = isSingleLiteral ? escapeMapSQ.getKeysByValue((Object)token) : escapeMapDQ.getKeysByValue((Object)token);
        if (unescapedChar != null) {
            String string = String.valueOf(unescapedChar.get(0));
            if (string == null) {
                PhpStringUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (token.startsWith("\\")) {
            if (token.startsWith("\\x")) {
                return PhpStringUtil.isHex(token = token.substring(2)) ? String.valueOf((char)Integer.parseInt(token, 16)) : "";
            }
            if (token.startsWith("\\u")) {
                return PhpStringUtil.isHex(token = token.substring(3, token.length() - 1)) ? String.valueOf((char)Integer.parseInt(token, 16)) : "";
            }
            return PhpStringUtil.isOct(token = token.substring(1)) ? String.valueOf((char)Integer.parseInt(token, 8)) : "";
        }
        String string = token;
        if (string == null) {
            PhpStringUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static boolean isHex(String token) {
        if (token.isEmpty()) {
            return false;
        }
        for (char c : token.toCharArray()) {
            if (StringUtil.isHexDigit((char)c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isOct(String token) {
        for (char c : token.toCharArray()) {
            if (StringUtil.isOctalDigit((char)c)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static String unescapeText(@NotNull StringLiteralExpression string) {
        if (string == null) {
            PhpStringUtil.$$$reportNull$$$0(10);
        }
        String string2 = PhpStringUtil.unescapeText(string.getContents(), string.isSingleQuote());
        if (string2 == null) {
            PhpStringUtil.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @Nullable
    public static String createTextWithChangedQuotes(String text, boolean singleQuote) {
        return PhpStringUtil.isUnescapableText(text, singleQuote) ? PhpReplaceQuotesIntention.createTextWithChangedQuotes(text, singleQuote) : null;
    }

    @NotNull
    public static Set<String> createCaseInsensitiveSet() {
        Set set = CollectionFactory.createCaseInsensitiveStringSet();
        if (set == null) {
            PhpStringUtil.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public static Collector<String, ?, Set<String>> toCaseInsensitiveSet() {
        Collector collector = Collectors.toCollection(PhpStringUtil::createCaseInsensitiveSet);
        if (collector == null) {
            PhpStringUtil.$$$reportNull$$$0(13);
        }
        return collector;
    }

    static {
        escapeMapDQ.put((Object)Character.valueOf('\b'), (Object)"\\b");
        escapeMapDQ.put((Object)Character.valueOf('\t'), (Object)"\\t");
        escapeMapDQ.put((Object)Character.valueOf('\n'), (Object)"\\n");
        escapeMapDQ.put((Object)Character.valueOf('\f'), (Object)"\\f");
        escapeMapDQ.put((Object)Character.valueOf('\u001b'), (Object)"\\e");
        escapeMapDQ.put((Object)Character.valueOf('\u000b'), (Object)"\\v");
        escapeMapDQ.put((Object)Character.valueOf('\"'), (Object)"\\\"");
        escapeMapDQ.put((Object)Character.valueOf('$'), (Object)"\\$");
        escapeMapDQ.put((Object)Character.valueOf('\\'), (Object)"\\\\");
        escapeMapSQ.put((Object)Character.valueOf('\''), (Object)"\\'");
        escapeMapSQ.put((Object)Character.valueOf('\\'), (Object)"\\\\");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/util/PhpStringUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectFromBegin";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectFromEnd";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "subtractFromBegin";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "subtractFromEnd";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/util/PhpStringUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeChar";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createCaseInsensitiveSet";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toCaseInsensitiveSet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEquals";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "escapeStringCharacters";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unescapeText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7, 10 -> new IllegalArgumentException(string);
        };
    }

    public static class StringLiteralSpliterator
    extends Spliterators.AbstractSpliterator<Pair<TextRange, IElementType>> {
        private final String myText;
        private final PhpStringLiteralLexer myLexer;

        public StringLiteralSpliterator(String text, boolean isSingleLiteral) {
            super(Long.MAX_VALUE, 0);
            this.myText = text;
            this.myLexer = isSingleLiteral ? new PhpStringLiteralLexer(PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE, 1) : new PhpStringLiteralLexer(PhpTokenTypes.STRING_LITERAL, 2);
            this.myLexer.start((CharSequence)text);
        }

        @Override
        public boolean tryAdvance(Consumer<? super Pair<TextRange, IElementType>> consumer) {
            if (this.myLexer.getTokenEnd() <= this.myText.length()) {
                TextRange token = new TextRange(this.myLexer.getTokenStart(), this.myLexer.getTokenEnd());
                consumer.accept((Pair<TextRange, IElementType>)Pair.create((Object)token, (Object)this.myLexer.getTokenType()));
                if (this.myLexer.getTokenEnd() >= this.myText.length()) {
                    return false;
                }
                this.myLexer.advance();
                return true;
            }
            return false;
        }
    }
}

