/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataAnnotationsManager;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageDataSuitesManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuiteListener;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.ExternalCoverageWatchManager;
import com.intellij.coverage.SubCoverageManager;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewSuiteListener;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CoverageDataManagerImpl
extends CoverageDataManager
implements Disposable.Default {
    private final Project myProject;
    private final List<CoverageSuiteListener> myListeners;
    private final Object myLock;
    private final Map<CoverageEngine, CoverageSuitesBundle> myActiveBundles;
    private boolean myIsProjectClosing;

    public CoverageDataManagerImpl(@NotNull Project project) {
        if (project == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLock = new Object();
        this.myActiveBundles = new ConcurrentHashMap<CoverageEngine, CoverageSuitesBundle>();
        this.myIsProjectClosing = false;
        this.myProject = project;
        CoverageSuiteListener coverageViewListener = this.createCoverageViewListener();
        if (coverageViewListener != null) {
            this.addSuiteListener(coverageViewListener, (Disposable)this);
        }
        this.setUpOnSchemeChangeCallback(project);
        this.setUpRunnerEPRemovedCallback(project);
        this.setUpEngineEPRemovedCallback();
    }

    private void setUpOnSchemeChangeCallback(@NotNull Project project) {
        if (project == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(1);
        }
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                for (CoverageSuitesBundle bundle : CoverageDataManagerImpl.this.myActiveBundles.values()) {
                    CoverageDataManagerImpl.this.chooseSuitesBundle(bundle);
                }
            }
        });
    }

    private void setUpRunnerEPRemovedCallback(final @NotNull Project project) {
        if (project == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(2);
        }
        CoverageRunner.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CoverageRunner>(){

            public void extensionRemoved(@NotNull CoverageRunner coverageRunner, @NotNull PluginDescriptor pluginDescriptor) {
                if (coverageRunner == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                for (CoverageSuitesBundle suitesBundle : CoverageDataManagerImpl.this.myActiveBundles.values()) {
                    if (!ContainerUtil.exists((Object[])suitesBundle.getSuites(), suite -> coverageRunner == suite.getRunner())) continue;
                    CoverageDataManagerImpl.this.closeSuitesBundle(suitesBundle);
                }
                RunManager runManager = RunManager.getInstance((Project)project);
                List configurations = runManager.getAllConfigurationsList();
                for (RunConfiguration configuration : configurations) {
                    RunConfigurationBase runConfiguration;
                    CoverageEnabledConfiguration coverageConfiguration;
                    if (!(configuration instanceof RunConfigurationBase) || (coverageConfiguration = CoverageEnabledConfiguration.getOrNull(runConfiguration = (RunConfigurationBase)configuration)) == null) continue;
                    coverageConfiguration.coverageRunnerExtensionRemoved(coverageRunner);
                }
                ((RunManagerImpl)runManager).reloadSchemes();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "coverageRunner";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/coverage/CoverageDataManagerImpl$2";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    private void setUpEngineEPRemovedCallback() {
        CoverageEngine.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CoverageEngine>(){

            public void extensionRemoved(@NotNull CoverageEngine coverageEngine, @NotNull PluginDescriptor pluginDescriptor) {
                CoverageSuitesBundle suitesBundle;
                if (coverageEngine == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((suitesBundle = CoverageDataManagerImpl.this.myActiveBundles.get(coverageEngine)) != null) {
                    CoverageDataManagerImpl.this.closeSuitesBundle(suitesBundle);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "coverageEngine";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/coverage/CoverageDataManagerImpl$3";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    @Override
    public Collection<CoverageSuitesBundle> activeSuites() {
        return this.myActiveBundles.values();
    }

    @Override
    public CoverageSuitesBundle getCurrentSuitesBundle() {
        CoverageSuitesBundle openedSuite;
        CoverageViewManager manager = CoverageViewManager.getInstanceIfCreated(this.myProject);
        if (manager != null && (openedSuite = manager.getOpenedSuite()) != null) {
            return openedSuite;
        }
        return this.myActiveBundles.values().stream().findFirst().orElse(null);
    }

    @Nullable
    protected CoverageSuiteListener createCoverageViewListener() {
        return new CoverageViewSuiteListener(this.myProject);
    }

    @Override
    public CoverageSuite addCoverageSuite(String name, @NotNull CoverageFileProvider fileProvider, String[] filters, long lastCoverageTimeStamp, @Nullable String suiteToMergeWith, @NotNull CoverageRunner coverageRunner, boolean coverageByTestEnabled, boolean bl) {
        CoverageDataSuitesManager manager;
        CoverageSuite suite;
        if (fileProvider == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(3);
        }
        if (coverageRunner == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(4);
        }
        if ((suite = (manager = CoverageDataSuitesManager.getInstance(this.myProject)).createCoverageSuite(name, coverageRunner, fileProvider, lastCoverageTimeStamp)) != null) {
            manager.addSuite(suite, suiteToMergeWith);
        }
        return suite;
    }

    public void addCoverageSuite(CoverageSuite suite, @Nullable String suiteToMergeWith) {
        CoverageDataSuitesManager.getInstance(this.myProject).addSuite(suite, suiteToMergeWith);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CoverageSuite addExternalCoverageSuite(@NotNull String selectedFileName, long timeStamp, @NotNull CoverageRunner coverageRunner, @NotNull CoverageFileProvider coverageFileProvider) {
        void fileProvider;
        if (selectedFileName == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(5);
        }
        if (coverageRunner == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(6);
        }
        if (coverageFileProvider == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(7);
        }
        return CoverageDataSuitesManager.getInstance(this.myProject).addExternalCoverageSuite(selectedFileName, coverageRunner, (CoverageFileProvider)fileProvider, timeStamp);
    }

    @Override
    public CoverageSuite addCoverageSuite(CoverageEnabledConfiguration config) {
        return CoverageDataSuitesManager.getInstance(this.myProject).addSuite(config);
    }

    @Override
    public CoverageSuite @NotNull [] getSuites() {
        CoverageSuite[] coverageSuiteArray = CoverageDataSuitesManager.getInstance(this.myProject).getSuites();
        if (coverageSuiteArray == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(8);
        }
        return coverageSuiteArray;
    }

    @Override
    public void removeCoverageSuite(CoverageSuite suite) {
        CoverageDataSuitesManager.getInstance(this.myProject).deleteSuite(suite);
        this.removeFromCurrent(suite);
    }

    @Override
    public void unregisterCoverageSuite(CoverageSuite suite) {
        CoverageDataSuitesManager.getInstance(this.myProject).removeSuite(suite);
        this.removeFromCurrent(suite);
    }

    private void removeFromCurrent(CoverageSuite suite) {
        Optional<CoverageSuitesBundle> containingBundle = this.myActiveBundles.values().stream().filter(b -> b.contains(suite)).findFirst();
        if (containingBundle.isPresent()) {
            CoverageSuitesBundle bundle = containingBundle.get();
            Object[] suites = bundle.getSuites();
            if (suites.length > 1) {
                suites = (CoverageSuite[])ArrayUtil.remove((Object[])suites, (Object)suite);
                this.chooseSuitesBundle(new CoverageSuitesBundle((CoverageSuite[])suites));
            } else {
                this.closeSuitesBundle(bundle);
            }
        }
    }

    @Override
    public boolean isSubCoverageActive() {
        return SubCoverageManager.getInstance(this.myProject).isSubCoverageActive();
    }

    @Override
    public void selectSubCoverage(@NotNull CoverageSuitesBundle suite, List<String> testNames) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(9);
        }
        SubCoverageManager.getInstance(this.myProject).selectSubCoverage(suite, testNames);
        this.reloadSuite(suite);
    }

    @Override
    public void restoreMergedCoverage(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(10);
        }
        SubCoverageManager.getInstance(this.myProject).restoreMergedCoverage(suite);
        this.reloadSuite(suite);
    }

    private void reloadSuite(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(11);
        }
        if (!this.myActiveBundles.containsKey(suite.getCoverageEngine())) {
            return;
        }
        this.fireBeforeSuiteChosen();
        CoverageDataAnnotationsManager.getInstance(this.myProject).clearAnnotations();
        suite.getCoverageEngine().getCoverageAnnotator(this.myProject).onSuiteChosen(suite);
        this.renewCoverageData(suite);
    }

    @Override
    public void closeSuitesBundle(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(12);
        }
        this.closeSuitesBundle(suite, true);
    }

    private void closeSuitesBundle(@NotNull CoverageSuitesBundle suite, boolean removeWatches) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(13);
        }
        if (!this.myActiveBundles.remove(suite.getCoverageEngine(), suite)) {
            return;
        }
        CoverageViewManager.getInstance(this.myProject).closeView(suite);
        if (removeWatches) {
            ExternalCoverageWatchManager.getInstance(this.myProject).clearWatches();
        }
        CoverageDataAnnotationsManager.getInstance(this.myProject).clearAnnotations();
        suite.getCoverageEngine().getCoverageAnnotator(this.myProject).onSuiteChosen(suite);
        suite.setCoverageData(null);
        this.triggerPresentationUpdate();
    }

    @Override
    public void chooseSuitesBundle(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(14);
        }
        ExternalCoverageWatchManager.getInstance(this.myProject).clearWatches();
        this.updateCoverageData(suite);
    }

    void updateCoverageData(@NotNull CoverageSuitesBundle suite) {
        CoverageSuitesBundle currentSuite;
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(15);
        }
        if ((currentSuite = this.myActiveBundles.get(suite.getCoverageEngine())) != null) {
            SubCoverageManager.getInstance(this.myProject).restoreMergedCoverage(currentSuite);
            this.closeSuitesBundle(currentSuite, false);
        }
        CoverageDataAnnotationsManager.getInstance(this.myProject).clearAnnotations();
        if (suite.ensureReportFilesExist()) {
            this.myActiveBundles.put(suite.getCoverageEngine(), suite);
            this.fireBeforeSuiteChosen();
            this.renewCoverageData(suite);
            this.fireAfterSuiteChosen();
        } else {
            this.triggerPresentationUpdate();
        }
    }

    @Override
    public void coverageGathered(@NotNull CoverageSuite suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(16);
        }
        this.fireCoverageGathered(suite);
        CoverageSuitesBundle bundle = this.myActiveBundles.get(suite.getCoverageEngine());
        if (bundle == null) {
            this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
        } else {
            boolean shouldAsk;
            int replaceOption = CoverageOptionsProvider.getInstance(this.myProject).getOptionToReplace();
            boolean bl = shouldAsk = replaceOption == 3;
            if (shouldAsk) {
                ApplicationManager.getApplication().invokeLater(() -> this.openSuite(bundle, suite, this.askMergeOption(suite)));
            } else {
                this.openSuite(bundle, suite, replaceOption);
            }
        }
    }

    private void openSuite(CoverageSuitesBundle bundle, CoverageSuite suite, int option) {
        switch (option) {
            case 0: {
                this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
                break;
            }
            case 1: {
                this.chooseSuitesBundle(new CoverageSuitesBundle((CoverageSuite[])ArrayUtil.append((Object[])bundle.getSuites(), (Object)suite)));
            }
        }
    }

    private int askMergeOption(@NotNull CoverageSuite suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(17);
        }
        final CoverageOptionsProvider coverageOptionsProvider = CoverageOptionsProvider.getInstance(this.myProject);
        final Function<Integer, Integer> mapCode = exitCode -> switch (exitCode) {
            case 0 -> 0;
            case 1 -> 1;
            default -> 2;
        };
        DoNotAskOption.Adapter doNotAskOption = new DoNotAskOption.Adapter(this){

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected) {
                    coverageOptionsProvider.setOptionsToReplace((Integer)mapCode.apply(exitCode));
                }
            }
        };
        String title = CoverageBundle.message("code.coverage", new Object[0]);
        String message = CoverageBundle.message("display.coverage.prompt", suite.getPresentableName());
        int result = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)title, (String)message).yesText(CoverageBundle.message("coverage.replace.active.suites", new Object[0]))).noText(CoverageBundle.message("coverage.add.to.active.suites", new Object[0]))).cancelText(CoverageBundle.message("coverage.do.not.apply.collected.coverage", new Object[0])).doNotAsk((DoNotAskOption)doNotAskOption)).show(suite.getProject());
        return mapCode.apply(result);
    }

    @Override
    public void triggerPresentationUpdate() {
        CoverageDataAnnotationsManager.getInstance(this.myProject).update();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            ProjectView.getInstance((Project)this.myProject).refresh();
        });
    }

    public void attachToProcess(final @NotNull ProcessHandler handler, final @NotNull RunConfigurationBase configuration, final RunnerSettings runnerSettings) {
        if (handler == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(18);
        }
        if (configuration == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(19);
        }
        handler.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                CoverageDataManagerImpl.this.processGatheredCoverage(configuration, runnerSettings);
                handler.removeProcessListener((ProcessListener)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/coverage/CoverageDataManagerImpl$5", "processTerminated"));
            }
        });
    }

    public void processGatheredCoverage(@NotNull RunConfigurationBase configuration, RunnerSettings runnerSettings) {
        if (configuration == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(20);
        }
        if (runnerSettings instanceof CoverageRunnerData) {
            CoverageDataManagerImpl.processGatheredCoverage(configuration);
        }
    }

    public static void processGatheredCoverage(RunConfigurationBase<?> configuration) {
        Project project = configuration.getProject();
        if (project.isDisposed()) {
            return;
        }
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreateIfApplicable(configuration);
        if (coverageEnabledConfiguration == null) {
            return;
        }
        CoverageSuite coverageSuite = coverageEnabledConfiguration.getCurrentCoverageSuite();
        if (coverageSuite != null) {
            ((BaseCoverageSuite)coverageSuite).setConfiguration(configuration);
            CoverageDataManagerImpl.getInstance(project).coverageGathered(coverageSuite);
        }
    }

    protected void renewCoverageData(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(21);
        }
        suite.getCoverageEngine().getCoverageAnnotator(this.myProject).renewCoverageData(suite, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doInReadActionIfProjectOpen(Computable<T> computation) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIsProjectClosing) {
                return null;
            }
        }
        return (T)ApplicationManager.getApplication().runReadAction(computation);
    }

    @Override
    public void addSuiteListener(final @NotNull CoverageSuiteListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(22);
        }
        if (parentDisposable == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(23);
        }
        this.myListeners.add(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                CoverageDataManagerImpl.this.myListeners.remove(listener);
            }
        });
    }

    public void fireCoverageGathered(@NotNull CoverageSuite suite) {
        if (suite == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(24);
        }
        for (CoverageSuiteListener listener : this.myListeners) {
            listener.coverageGathered(suite);
        }
    }

    public void fireBeforeSuiteChosen() {
        for (CoverageSuiteListener listener : this.myListeners) {
            listener.beforeSuiteChosen();
        }
    }

    public void fireAfterSuiteChosen() {
        for (CoverageSuiteListener listener : this.myListeners) {
            listener.afterSuiteChosen();
        }
    }

    public void fireCoverageDataCalculated(@NotNull CoverageSuitesBundle suitesBundle) {
        if (suitesBundle == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(25);
        }
        for (CoverageSuiteListener listener : this.myListeners) {
            listener.coverageDataCalculated(suitesBundle);
        }
    }

    @Override
    public void coverageDataCalculated(@NotNull CoverageSuitesBundle suitesBundle) {
        if (suitesBundle == null) {
            CoverageDataManagerImpl.$$$reportNull$$$0(26);
        }
        this.fireCoverageDataCalculated(suitesBundle);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProvider";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageRunner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFileName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageDataManagerImpl";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suitesBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuites";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setUpOnSchemeChangeCallback";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setUpRunnerEPRemovedCallback";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addCoverageSuite";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addExternalCoverageSuite";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selectSubCoverage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "restoreMergedCoverage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reloadSuite";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "closeSuitesBundle";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "chooseSuitesBundle";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateCoverageData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "coverageGathered";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "askMergeOption";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processGatheredCoverage";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "renewCoverageData";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addSuiteListener";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fireCoverageGathered";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fireCoverageDataCalculated";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "coverageDataCalculated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    public static class CoverageProjectManagerListener
    implements ProjectCloseListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void projectClosing(@NotNull Project project) {
            if (project == null) {
                CoverageProjectManagerListener.$$$reportNull$$$0(0);
            }
            CoverageDataManagerImpl manager = (CoverageDataManagerImpl)CoverageDataManager.getInstance(project);
            Object object = manager.myLock;
            synchronized (object) {
                manager.myIsProjectClosing = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/CoverageDataManagerImpl$CoverageProjectManagerListener", "projectClosing"));
        }
    }
}

