// Copyright 2000-2020 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.elements;

import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;

public interface PhpAttributesOwner extends PhpPsiElement {
  @NotNull Collection<@NotNull PhpAttribute> getAttributes();

  default @NotNull Collection<@NotNull PhpAttribute> getAttributes(@NotNull String fqn) {
    return ContainerUtil.filter(getAttributes(), attr -> fqn.equalsIgnoreCase(attr.getFQN()));
  }
}
