// Copyright 2000-2021 JetBrains s.r.o. and contributors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.elements;

import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.psi.stubs.PhpEnumCaseStub;
import com.jetbrains.php.lang.psi.stubs.PhpStubBasedPsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public interface PhpEnumCase extends PhpNamedElement, PhpStubBasedPsiElement<PhpEnumCaseStub>, PhpAttributesOwner, PhpClassMember {
  @Nullable PhpExpression getExpression();

  @Nullable PhpDefaultValueDescriptor getDefaultValueDescriptor();

  abstract class PhpDefaultValueDescriptor {
    private final @NotNull String myValue;

    protected PhpDefaultValueDescriptor(@NotNull String value) {
      myValue = value;
    }

    public @NotNull String getValue() {
      return myValue;
    }

    public abstract @NotNull MatchResult match(@NotNull PsiElement element);

    @Override
    public boolean equals(Object o) {
      if (this == o) return true;
      if (o == null || getClass() != o.getClass()) return false;
      PhpDefaultValueDescriptor that = (PhpDefaultValueDescriptor)o;
      return myValue.equals(that.myValue);
    }

    @Override
    public int hashCode() {
      return Objects.hash(myValue);
    }
  }

  enum MatchResult {
    MATCHES, NOT_MATCHING, UNKNOWN
  }
}
