/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.injection;

import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.blade.psi.BladeTranslatableElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeDoubleInjectionInfo
extends BladeInjectionInfo {
    @NotNull
    private final String myMiddlePart;

    public BladeDoubleInjectionInfo(@NotNull String phpPrefix, @NotNull String phpMiddlePart, @NotNull String phpSuffix) {
        if (phpPrefix == null) {
            BladeDoubleInjectionInfo.$$$reportNull$$$0(0);
        }
        if (phpMiddlePart == null) {
            BladeDoubleInjectionInfo.$$$reportNull$$$0(1);
        }
        if (phpSuffix == null) {
            BladeDoubleInjectionInfo.$$$reportNull$$$0(2);
        }
        super(phpPrefix, phpSuffix, BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT);
        this.myMiddlePart = phpMiddlePart;
    }

    @Override
    public int getBladePrefixLength() {
        return "(".length();
    }

    @Override
    public int getBladeSuffixLength() {
        return ")".length();
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @Nullable
    public String getUnmodifiablePresentableDescription() {
        return "(\"" + this.getPhpPrefix() + "\", \"" + this.myMiddlePart + "\", \"" + this.getPhpSuffix() + "\")";
    }

    @Override
    @Nullable
    public TextRange convertInjectedRangeToInnerVisible(BladeTranslatableElement host, TextRange injected, int length, boolean showEmptyBorderIntersections) {
        int injectedTextLength = host.getTextLength() - this.getBladePrefixLength() - this.getBladeSuffixLength();
        if (injected.getEndOffset() < this.getPhpPrefix().length() || injected.getStartOffset() > this.getPhpPrefix().length() + injectedTextLength) {
            return null;
        }
        if (!(showEmptyBorderIntersections || injected.getEndOffset() != this.getPhpPrefix().length() && injected.getStartOffset() != this.getPhpPrefix().length() + injectedTextLength)) {
            return null;
        }
        int start = Math.max(injected.getStartOffset() - this.getPhpPrefix().length(), 0);
        int end = Math.min(injected.getEndOffset() - this.getPhpPrefix().length(), injected.getStartOffset() - this.getPhpPrefix().length() + injectedTextLength);
        return TextRange.create((int)(this.getBladePrefixLength() + start), (int)(this.getBladePrefixLength() + end));
    }

    @Override
    public void register(MultiHostRegistrar registrar, BladePsiLanguageInjectionHost host, PsiElement child, @NotNull String prefix) {
        if (prefix == null) {
            BladeDoubleInjectionInfo.$$$reportNull$$$0(3);
        }
        TextRange rangeInsideHost = this.getRangeInsideHost(host, child);
        String suffix = this.myMiddlePart + rangeInsideHost.substring(host.getText()) + this.getPhpSuffix();
        registrar.addPlace(prefix + this.getPhpPrefix(), suffix, (PsiLanguageInjectionHost)host, rangeInsideHost);
    }

    @Override
    @NonNls
    public String toString() {
        return "BIIInfo{prefix='" + this.getPhpPrefix() + "', middlePart='" + this.myMiddlePart + "', suffix='" + this.getPhpSuffix() + "\\}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpPrefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpMiddlePart";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpSuffix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/blade/injection/BladeDoubleInjectionInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

