/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.injection;

import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.blade.psi.BladeTranslatableElement;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class BladeInjectInjectionInfo
extends BladeInjectionInfo {
    public static final String MY_MIDDLE_PART = " = app('";
    private static final Key<CachedValue<InjectionDescription>> INJECTION_DESCRIPTION = Key.create((String)"BLADE_INJECT_INJECTION_DESCRIPTION");
    public static final int BLADE_PREFIX_LENGTH = "(".length();

    public BladeInjectInjectionInfo() {
        super("<?php\n$", "'); ?>", BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT);
    }

    @Override
    public int getBladePrefixLength() {
        return BLADE_PREFIX_LENGTH;
    }

    @Override
    public int getBladeSuffixLength() {
        return ")".length();
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @Nullable
    public String getUnmodifiablePresentableDescription() {
        return "(\"" + this.getPhpPrefix() + "\", \" = app('\", \"" + this.getPhpSuffix() + "\")";
    }

    @Override
    @Nullable
    public TextRange convertInjectedRangeToInnerVisible(BladeTranslatableElement host, TextRange injected, int length, boolean showEmptyBorderIntersections) {
        return BladeInjectInjectionInfo.doConvertInjectedRangeToInnerVisible(BladeInjectInjectionInfo.getInjectionDescription(host), this.getPhpPrefix(), MY_MIDDLE_PART, this.getPhpSuffix(), injected, length, showEmptyBorderIntersections);
    }

    @Nullable
    static TextRange doConvertInjectedRangeToInnerVisible(@NotNull InjectionDescription description, @NotNull String phpPrefix, @NotNull String middlePart, @NotNull String phpSuffix, TextRange injected, int length, boolean showEmptyBorderIntersections) {
        TextRange intersection;
        if (description == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(0);
        }
        if (phpPrefix == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(1);
        }
        if (middlePart == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(2);
        }
        if (phpSuffix == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(3);
        }
        if (injected.getEndOffset() < phpPrefix.length() || injected.getStartOffset() > length - phpSuffix.length()) {
            return null;
        }
        if (!(showEmptyBorderIntersections || injected.getEndOffset() != phpPrefix.length() && injected.getStartOffset() != length - phpSuffix.length())) {
            return null;
        }
        int injectedOffset = phpPrefix.length();
        for (TextRange range : description.getFirstPartRanges()) {
            intersection = BladeInjectInjectionInfo.findIntersection(injected, showEmptyBorderIntersections, injectedOffset, range);
            if (intersection != null) {
                return intersection;
            }
            injectedOffset += range.getLength();
        }
        if (injected.getEndOffset() < (injectedOffset += middlePart.length())) {
            return null;
        }
        if (!showEmptyBorderIntersections && injected.getEndOffset() == injectedOffset) {
            return null;
        }
        for (TextRange range : description.getSecondPartRanges()) {
            intersection = BladeInjectInjectionInfo.findIntersection(injected, showEmptyBorderIntersections, injectedOffset, range);
            if (intersection != null) {
                return intersection;
            }
            injectedOffset += range.getLength();
        }
        return null;
    }

    @Nullable
    private static TextRange findIntersection(TextRange injected, boolean showEmptyBorderIntersections, int injectedOffset, TextRange range) {
        if (showEmptyBorderIntersections && injectedOffset + range.getLength() == injected.getStartOffset()) {
            return new TextRange(range.getEndOffset(), range.getEndOffset());
        }
        if (injectedOffset + range.getLength() > injected.getStartOffset()) {
            return new TextRange(range.getStartOffset() + injected.getStartOffset() - injectedOffset, Math.min(range.getEndOffset(), range.getStartOffset() + injected.getEndOffset() - injectedOffset));
        }
        return null;
    }

    @Override
    public void handleContentChange(@NotNull LeafElement content, @NotNull TextRange changeRange, String newContent) {
        if (content == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(4);
        }
        if (changeRange == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(5);
        }
        super.handleContentChange(content, changeRange, newContent);
    }

    @Override
    public void register(MultiHostRegistrar registrar, BladePsiLanguageInjectionHost host, PsiElement child, @NotNull String prefix) {
        BladeTranslatableElement translatableElement;
        if (prefix == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(6);
        }
        if ((translatableElement = (BladeTranslatableElement)((Object)ObjectUtils.tryCast((Object)child, BladeTranslatableElement.class))) == null) {
            return;
        }
        InjectionDescription description = BladeInjectInjectionInfo.getInjectionDescription(translatableElement);
        this.doRegister(description, registrar, host, translatableElement, prefix);
    }

    void doRegister(@NotNull InjectionDescription description, MultiHostRegistrar registrar, BladePsiLanguageInjectionHost host, @NotNull BladeTranslatableElement translatableElement, @NotNull String additionalPrefix) {
        TextRange range;
        int i;
        if (description == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(7);
        }
        if (translatableElement == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(8);
        }
        if (additionalPrefix == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(9);
        }
        List<TextRange> firstPartRanges = description.getFirstPartRanges();
        List<TextRange> secondPartRanges = description.getSecondPartRanges();
        String prefix = additionalPrefix + this.getPhpPrefix();
        if (firstPartRanges.isEmpty() && secondPartRanges.isEmpty()) {
            registrar.addPlace(prefix, MY_MIDDLE_PART + this.getPhpSuffix(), (PsiLanguageInjectionHost)host, translatableElement.getTextRange());
            return;
        }
        if (!firstPartRanges.isEmpty()) {
            for (i = 0; i < firstPartRanges.size(); ++i) {
                range = firstPartRanges.get(i).shiftRight(translatableElement.getTextOffset());
                Object suffix = null;
                if (i == firstPartRanges.size() - 1) {
                    suffix = MY_MIDDLE_PART;
                    if (secondPartRanges.isEmpty()) {
                        suffix = (String)suffix + this.getPhpSuffix();
                    }
                }
                registrar.addPlace((String)((Object)(i == 0 ? prefix : null)), (String)suffix, (PsiLanguageInjectionHost)host, range);
            }
        }
        if (!secondPartRanges.isEmpty()) {
            for (i = 0; i < secondPartRanges.size(); ++i) {
                range = secondPartRanges.get(i).shiftRight(translatableElement.getTextOffset());
                registrar.addPlace(i == 0 && firstPartRanges.isEmpty() ? prefix + MY_MIDDLE_PART : null, i == secondPartRanges.size() - 1 ? this.getPhpSuffix() : null, (PsiLanguageInjectionHost)host, range);
            }
        }
    }

    @NotNull
    private static InjectionDescription getInjectionDescription(@NotNull BladeTranslatableElement host) {
        if (host == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(10);
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)host.getProject());
        InjectionDescription injectionDescription = (InjectionDescription)cachedValuesManager.getCachedValue((UserDataHolder)host, INJECTION_DESCRIPTION, () -> CachedValueProvider.Result.create((Object)BladeInjectInjectionInfo.createInjectionDescription(host), (Object[])new Object[]{host}), false);
        if (injectionDescription == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(11);
        }
        return injectionDescription;
    }

    static InjectionDescription createInjectionDescription(@NotNull BladeTranslatableElement host) {
        if (host == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(12);
        }
        return BladeInjectInjectionInfo.createFromText(host.getText());
    }

    @VisibleForTesting
    public static InjectionDescription createFromText(@NotNull String text) {
        if (text == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(13);
        }
        return new MyInjectionDescription(text);
    }

    private static boolean shouldIgnore(char c) {
        return c == '(' || c == ')' || c == '\'' || c == '\"';
    }

    @Override
    @NonNls
    public String toString() {
        return "BIInfo{prefix='" + this.getPhpPrefix() + "', middlePart=' = app('', suffix='" + this.getPhpSuffix() + "\\}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpPrefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "middlePart";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpSuffix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeRange";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "translatableElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalPrefix";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/injection/BladeInjectInjectionInfo";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/injection/BladeInjectInjectionInfo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectionDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doConvertInjectedRangeToInnerVisible";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doRegister";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionDescription";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createInjectionDescription";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFromText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }

    public static interface InjectionDescription {
        @NotNull
        public List<TextRange> getFirstPartRanges();

        @NotNull
        public List<TextRange> getSecondPartRanges();

        @Nullable
        default public TextRange intersect(TextRange rangeToIntersect) {
            TextRange range = this.getIntersectingRange(rangeToIntersect);
            return range == null ? null : range.intersection(rangeToIntersect);
        }

        @Nullable
        default public TextRange getIntersectingRange(TextRange rangeToIntersect) {
            for (TextRange range : this.getFirstPartRanges()) {
                if (!rangeToIntersect.intersects(range)) continue;
                return range;
            }
            for (TextRange range : this.getSecondPartRanges()) {
                if (!rangeToIntersect.intersects(range)) continue;
                return range;
            }
            return null;
        }
    }

    private static final class MyInjectionDescription
    implements InjectionDescription {
        @NotNull
        private final SmartList<TextRange> firstPartRanges = new SmartList();
        @NotNull
        private final SmartList<TextRange> secondPartRanges = new SmartList();

        private MyInjectionDescription(String text) {
            int firstComma = text.indexOf(44);
            int secondComma = firstComma == -1 ? -1 : text.indexOf(44, firstComma + 1);
            MyInjectionDescription.createRanges(this.firstPartRanges, text, 0, firstComma == -1 ? text.length() : firstComma);
            if (firstComma != -1) {
                MyInjectionDescription.createRanges(this.secondPartRanges, text, firstComma + 1, secondComma == -1 ? text.length() : secondComma);
            }
        }

        @Override
        @NotNull
        public List<TextRange> getFirstPartRanges() {
            SmartList<TextRange> smartList = this.firstPartRanges;
            if (smartList == null) {
                MyInjectionDescription.$$$reportNull$$$0(0);
            }
            return smartList;
        }

        @Override
        @NotNull
        public List<TextRange> getSecondPartRanges() {
            SmartList<TextRange> smartList = this.secondPartRanges;
            if (smartList == null) {
                MyInjectionDescription.$$$reportNull$$$0(1);
            }
            return smartList;
        }

        private static void createRanges(SmartList<TextRange> ranges, String text, int startOffset, int endOffset) {
            int index;
            int currentRangeIndex = -1;
            for (index = startOffset; index < endOffset; ++index) {
                char c = text.charAt(index);
                if (BladeInjectInjectionInfo.shouldIgnore(c)) {
                    MyInjectionDescription.tryCloseRange(ranges, currentRangeIndex, index);
                    currentRangeIndex = -1;
                    continue;
                }
                if (currentRangeIndex != -1) continue;
                currentRangeIndex = index;
            }
            MyInjectionDescription.tryCloseRange(ranges, currentRangeIndex, index);
        }

        private static void tryCloseRange(SmartList<TextRange> result, int currentRangeIndex, int index) {
            if (currentRangeIndex == -1) {
                return;
            }
            result.add((Object)new TextRange(currentRangeIndex, index));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/php/blade/injection/BladeInjectInjectionInfo$MyInjectionDescription";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFirstPartRanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSecondPartRanges";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

