/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.codeStyle;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.json.JsonFileType;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.PhpPredefinedCodeStyleBase;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class DrupalPredefinedCodeStyle
extends PhpPredefinedCodeStyleBase {
    @NlsSafe
    private static final String DRUPAL = "Drupal";

    public DrupalPredefinedCodeStyle() {
        super(DRUPAL);
    }

    public void apply(CodeStyleSettings settings) {
        super.apply(settings);
        settings.AUTODETECT_INDENTS = false;
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions();
        indentOptions.INDENT_SIZE = 2;
        indentOptions.CONTINUATION_INDENT_SIZE = 2;
        indentOptions.TAB_SIZE = 2;
        settings.setDefaultRightMargin(80);
        settings.setDefaultSoftMargins(Arrays.asList(80, 120));
        CommonCodeStyleSettings.IndentOptions cssIndentOptions = settings.getIndentOptions((FileType)CssFileType.INSTANCE);
        cssIndentOptions.INDENT_SIZE = 2;
        cssIndentOptions.CONTINUATION_INDENT_SIZE = 2;
        cssIndentOptions.TAB_SIZE = 2;
        CssCodeStyleSettings cssCodeStyleSettings = (CssCodeStyleSettings)settings.getCustomSettings(CssCodeStyleSettings.class);
        CommonCodeStyleSettings cssCommonSettings = settings.getCommonSettings((Language)CSSLanguage.INSTANCE);
        cssCommonSettings.RIGHT_MARGIN = 80;
        cssCodeStyleSettings.HEX_COLOR_LOWER_CASE = true;
        cssCodeStyleSettings.HEX_COLOR_SHORT_FORMAT = true;
        cssCodeStyleSettings.BLANK_LINES_BETWEEN_BLOCKS = 0;
        cssCodeStyleSettings.BLANK_LINES_AROUND_NESTED_SELECTOR = 0;
        cssCodeStyleSettings.KEEP_SINGLE_LINE_BLOCKS = true;
        CommonCodeStyleSettings.IndentOptions jsIndentOptions = settings.getIndentOptions((FileType)JavaScriptFileType.INSTANCE);
        jsIndentOptions.INDENT_SIZE = 2;
        jsIndentOptions.CONTINUATION_INDENT_SIZE = 2;
        jsIndentOptions.TAB_SIZE = 2;
        CommonCodeStyleSettings jsCommonSettings = settings.getCommonSettings((Language)JavascriptLanguage.INSTANCE);
        jsCommonSettings.RIGHT_MARGIN = 80;
        jsCommonSettings.KEEP_FIRST_COLUMN_COMMENT = false;
        jsCommonSettings.KEEP_BLANK_LINES_IN_CODE = 1;
        jsCommonSettings.ALIGN_MULTILINE_PARAMETERS = false;
        jsCommonSettings.ALIGN_MULTILINE_FOR = false;
        jsCommonSettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = true;
        jsCommonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE = true;
        jsCommonSettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = true;
        jsCommonSettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = true;
        jsCommonSettings.IF_BRACE_FORCE = 3;
        jsCommonSettings.DOWHILE_BRACE_FORCE = 3;
        jsCommonSettings.WHILE_BRACE_FORCE = 3;
        jsCommonSettings.FOR_BRACE_FORCE = 3;
        JSCodeStyleSettings jsCodeStyleSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class);
        jsCodeStyleSettings.FORCE_SEMICOLON_STYLE = true;
        jsCodeStyleSettings.USE_DOUBLE_QUOTES = false;
        jsCodeStyleSettings.FORCE_QUOTE_STYlE = true;
        jsCodeStyleSettings.ENFORCE_TRAILING_COMMA = JSCodeStyleSettings.TrailingCommaOption.WhenMultiline;
        jsCodeStyleSettings.OBJECT_LITERAL_WRAP = 0;
        jsCodeStyleSettings.SPACES_WITHIN_OBJECT_LITERAL_BRACES = true;
        jsCodeStyleSettings.SPACES_WITHIN_IMPORTS = true;
        CommonCodeStyleSettings.IndentOptions phpIndentOptions = settings.getIndentOptions((FileType)PhpFileType.INSTANCE);
        phpIndentOptions.INDENT_SIZE = 2;
        phpIndentOptions.CONTINUATION_INDENT_SIZE = 2;
        phpIndentOptions.TAB_SIZE = 2;
        CommonCodeStyleSettings phpCommonSettings = settings.getCommonSettings((Language)PhpLanguage.INSTANCE);
        phpCommonSettings.RIGHT_MARGIN = 80;
        phpCommonSettings.KEEP_FIRST_COLUMN_COMMENT = false;
        phpCommonSettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE = false;
        phpCommonSettings.KEEP_BLANK_LINES_IN_DECLARATIONS = 1;
        phpCommonSettings.KEEP_BLANK_LINES_IN_CODE = 1;
        phpCommonSettings.KEEP_BLANK_LINES_BEFORE_RBRACE = 0;
        phpCommonSettings.BLANK_LINES_BEFORE_PACKAGE = 0;
        phpCommonSettings.BLANK_LINES_AFTER_PACKAGE = 1;
        phpCommonSettings.BLANK_LINES_BEFORE_IMPORTS = 0;
        phpCommonSettings.BLANK_LINES_AROUND_FIELD = 1;
        phpCommonSettings.BLANK_LINES_AFTER_CLASS_HEADER = 1;
        phpCommonSettings.BLANK_LINES_BEFORE_CLASS_END = 1;
        phpCommonSettings.CLASS_BRACE_STYLE = 1;
        phpCommonSettings.METHOD_BRACE_STYLE = 1;
        phpCommonSettings.ELSE_ON_NEW_LINE = true;
        phpCommonSettings.WHILE_ON_NEW_LINE = true;
        phpCommonSettings.CATCH_ON_NEW_LINE = true;
        phpCommonSettings.FINALLY_ON_NEW_LINE = true;
        phpCommonSettings.ALIGN_MULTILINE_PARAMETERS = false;
        phpCommonSettings.ALIGN_MULTILINE_FOR = false;
        phpCommonSettings.SPACE_AFTER_TYPE_CAST = true;
        phpCommonSettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE = true;
        phpCommonSettings.METHOD_CALL_CHAIN_WRAP = 5;
        phpCommonSettings.ARRAY_INITIALIZER_WRAP = 5;
        phpCommonSettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = true;
        phpCommonSettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = true;
        phpCommonSettings.IF_BRACE_FORCE = 3;
        phpCommonSettings.DOWHILE_BRACE_FORCE = 3;
        phpCommonSettings.WHILE_BRACE_FORCE = 3;
        phpCommonSettings.FOR_BRACE_FORCE = 3;
        PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        phpSettings.COMMA_AFTER_LAST_ARRAY_ELEMENT = true;
        phpSettings.PHPDOC_BLANK_LINE_BEFORE_TAGS = true;
        phpSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS = true;
        phpSettings.PHPDOC_WRAP_LONG_LINES = true;
        phpSettings.THROWS_WEIGHT = 3;
        phpSettings.PARAM_WEIGHT = 1;
        phpSettings.RETURN_WEIGHT = 2;
        phpSettings.DEPRECATED_WEIGHT = 4;
        phpSettings.SEE_WEIGHT = 5;
        phpSettings.TODO_WEIGHT = 6;
        phpSettings.VAR_WEIGHT = 0;
        phpSettings.UPPER_CASE_BOOLEAN_CONST = true;
        phpSettings.UPPER_CASE_NULL_CONST = true;
        phpSettings.ELSE_IF_STYLE = PhpCodeStyleSettings.ElseIfStyle.COMBINE;
        phpSettings.KEEP_RPAREN_AND_LBRACE_ON_ONE_LINE = true;
        phpSettings.BLANK_LINES_AROUND_CONSTANTS = 1;
        phpSettings.BLANK_LINES_AFTER_OPENING_TAG = 1;
        phpSettings.KEEP_BLANK_LINES_AFTER_LBRACE = 0;
        phpSettings.SPACE_BEFORE_CLOSURE_LEFT_PARENTHESIS = false;
        phpSettings.FORCE_SHORT_DECLARATION_ARRAY_STYLE = true;
        phpSettings.FORCE_EMPTY_METHODS_IN_ONE_LINE = true;
        phpSettings.PHPDOC_USE_FQCN = true;
        phpSettings.PLACE_PARENS_FOR_CONSTRUCTOR = 1;
        CommonCodeStyleSettings.IndentOptions xmlIndentOptions = settings.getIndentOptions((FileType)XmlFileType.INSTANCE);
        xmlIndentOptions.INDENT_SIZE = 2;
        xmlIndentOptions.CONTINUATION_INDENT_SIZE = 2;
        xmlIndentOptions.TAB_SIZE = 2;
        CommonCodeStyleSettings.IndentOptions jsonIndentOptions = settings.getIndentOptions((FileType)JsonFileType.INSTANCE);
        settings.getCommonSettings((Language)JsonLanguage.INSTANCE).WRAP_LONG_LINES = true;
        jsonIndentOptions.CONTINUATION_INDENT_SIZE = 2;
        jsonIndentOptions.TAB_SIZE = 2;
        CommonCodeStyleSettings.IndentOptions htmlIndentOptions = settings.getIndentOptions((FileType)HtmlFileType.INSTANCE);
        htmlIndentOptions.INDENT_SIZE = 2;
        htmlIndentOptions.CONTINUATION_INDENT_SIZE = 2;
        htmlIndentOptions.TAB_SIZE = 2;
    }

    public boolean isApplicableToLanguage(@NotNull Language language) {
        if (language == null) {
            DrupalPredefinedCodeStyle.$$$reportNull$$$0(0);
        }
        return language.is((Language)PhpLanguage.INSTANCE) || language.is((Language)JavascriptLanguage.INSTANCE) || language.is((Language)CSSLanguage.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/jetbrains/php/drupal/codeStyle/DrupalPredefinedCodeStyle", "isApplicableToLanguage"));
    }
}

