/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.init;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import com.jetbrains.php.drupal.DrupalBundle;
import com.jetbrains.php.drupal.DrupalUtil;
import com.jetbrains.php.drupal.DrupalVersion;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import com.jetbrains.php.ui.PhpUiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class DrupalIncludePathsManager {
    private static final Logger LOG = Logger.getInstance(DrupalIncludePathsManager.class);
    private static final DrupalIncludePathsManager INSTANCE = new DrupalIncludePathsManager();

    public static DrupalIncludePathsManager getInstance() {
        return INSTANCE;
    }

    private DrupalIncludePathsManager() {
    }

    public void refreshIncludePaths(DrupalDataService.State newState, DrupalDataService.State oldState, Project project) {
        Collection<VirtualFile> contentRoots = DrupalIncludePathsManager.collectContentRoots(project);
        ArrayList<VirtualFile> rootsToErase = new ArrayList<VirtualFile>(DrupalIncludePathsManager.getIncludeRoots(oldState, contentRoots));
        ArrayList<VirtualFile> rootsToAdd = new ArrayList<VirtualFile>(DrupalIncludePathsManager.getIncludeRoots(newState, contentRoots));
        if (!rootsToErase.isEmpty()) {
            rootsToErase.removeAll(rootsToAdd);
        }
        if (rootsToAdd.isEmpty() && rootsToErase.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater((Runnable)new IncludePathApplier(project, rootsToAdd, rootsToErase), ModalityState.nonModal());
    }

    @NotNull
    private static Collection<VirtualFile> collectContentRoots(Project project) {
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                DrupalIncludePathsManager.$$$reportNull$$$0(0);
            }
            return list;
        }
        ModuleManager manager = ModuleManager.getInstance((Project)project);
        Module[] modules = manager.getModules();
        if (modules.length == 0) {
            Set<VirtualFile> set = Collections.singleton(baseDir);
            if (set == null) {
                DrupalIncludePathsManager.$$$reportNull$$$0(1);
            }
            return set;
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)modules[0]).getContentRoots();
        if (contentRoots.length == 0) {
            Set<VirtualFile> set = Collections.singleton(baseDir);
            if (set == null) {
                DrupalIncludePathsManager.$$$reportNull$$$0(2);
            }
            return set;
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        Collections.addAll(result, contentRoots);
        if (!result.contains(baseDir)) {
            result.add(baseDir);
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            DrupalIncludePathsManager.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<VirtualFile> getIncludeRoots(@NotNull DrupalDataService.State state, @NotNull Collection<VirtualFile> moduleRoots) {
        if (state == null) {
            DrupalIncludePathsManager.$$$reportNull$$$0(4);
        }
        if (moduleRoots == null) {
            DrupalIncludePathsManager.$$$reportNull$$$0(5);
        }
        if (!(state.isEnabled() && state.isUpdateIncludePath() && DrupalUtil.isValid(state))) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                DrupalIncludePathsManager.$$$reportNull$$$0(6);
            }
            return list;
        }
        DrupalVersion version = DrupalVersion.getFromNumber(state.getVersion());
        LOG.assertTrue(version != null);
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VirtualFile drupalRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(state.getDrupalPath());
        LOG.assertTrue(drupalRoot != null);
        switch (version) {
            case SIX: 
            case SEVEN: {
                DrupalIncludePathsManager.addIfExist(drupalRoot, result, moduleRoots, "includes");
                DrupalIncludePathsManager.addIfExist(drupalRoot, result, moduleRoots, "modules");
                DrupalIncludePathsManager.addIfExist(drupalRoot, result, moduleRoots, "sites", "all", "modules");
                break;
            }
            case EIGHT: 
            case NINE: {
                DrupalIncludePathsManager.addIfExist(drupalRoot, result, moduleRoots, "core");
                DrupalIncludePathsManager.addIfExist(drupalRoot, result, moduleRoots, "modules");
                DrupalIncludePathsManager.addIfExist(drupalRoot, result, moduleRoots, "sites", "all", "modules");
                DrupalIncludePathsManager.addIfExist(drupalRoot, result, moduleRoots, "sites", "all", "libraries");
                DrupalIncludePathsManager.addIfExist(drupalRoot, result, moduleRoots, "libraries");
                DrupalIncludePathsManager.addIfExist(drupalRoot, result, moduleRoots, "vendor");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown drupal version: " + String.valueOf((Object)version));
            }
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            DrupalIncludePathsManager.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static void addIfExist(VirtualFile root, final List<? super VirtualFile> collector, final @NotNull Collection<? extends VirtualFile> moduleRoots, String ... relativePath) {
        VirtualFile target;
        if (moduleRoots == null) {
            DrupalIncludePathsManager.$$$reportNull$$$0(8);
        }
        if ((target = VfsUtil.findRelativeFile((VirtualFile)root, (String[])relativePath)) != null && target.isDirectory()) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)target, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!file.isDirectory()) {
                        VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
                        if (result == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return result;
                    }
                    if (moduleRoots.contains(file)) {
                        VirtualFileVisitor.Result result = VirtualFileVisitor.SKIP_CHILDREN;
                        if (result == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return result;
                    }
                    boolean isAncestor = false;
                    for (VirtualFile moduleRoot : moduleRoots) {
                        if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)moduleRoot, (boolean)false) && !VfsUtilCore.isAncestor((VirtualFile)moduleRoot, (VirtualFile)file, (boolean)false)) continue;
                        isAncestor = true;
                        break;
                    }
                    if (!isAncestor) {
                        collector.add(file);
                        VirtualFileVisitor.Result result = VirtualFileVisitor.SKIP_CHILDREN;
                        if (result == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return result;
                    }
                    VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
                    if (result == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return result;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2, 3, 4 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/php/drupal/init/DrupalIncludePathsManager$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/php/drupal/init/DrupalIncludePathsManager$1";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visitFileEx";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visitFileEx";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2, 3, 4 -> new IllegalStateException(string);
                    };
                }
            });
        }
    }

    private static void reportResult(final Project project, @NotNull List<@NlsSafe String> removedPaths, @NotNull List<@NlsSafe String> addedPaths) {
        if (removedPaths == null) {
            DrupalIncludePathsManager.$$$reportNull$$$0(9);
        }
        if (addedPaths == null) {
            DrupalIncludePathsManager.$$$reportNull$$$0(10);
        }
        HtmlBuilder message = new HtmlBuilder().append(DrupalBundle.message("drupal.include.paths.changed.popup", new Object[0])).append((HtmlChunk)HtmlChunk.br());
        if (!removedPaths.isEmpty()) {
            message.append(DrupalBundle.message("drupal.removed.with.colon", new Object[0])).append((HtmlChunk)HtmlChunk.br());
            for (String path : removedPaths) {
                message.append(path).append((HtmlChunk)HtmlChunk.br());
            }
        }
        if (!addedPaths.isEmpty()) {
            message.append(DrupalBundle.message("drupal.added.with.colon", new Object[0])).append((HtmlChunk)HtmlChunk.br());
            for (String path : addedPaths) {
                message.append(path).append((HtmlChunk)HtmlChunk.br());
            }
        }
        Function<Notification, AnAction> viewAction = notification -> new DumbAwareAction(DrupalBundle.message("action.view.text", new Object[0]), (Notification)notification){
            final /* synthetic */ Notification val$notification;
            {
                this.val$notification = notification;
                super(arg0);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpUiUtil.editConfigurable((Project)project, (Configurable)new PhpProjectConfigurable(project));
                this.val$notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/drupal/init/DrupalIncludePathsManager$2", "actionPerformed"));
            }
        };
        DrupalUtil.notifyGlobally(project, DrupalBundle.message("plugin.title", new Object[0]), message.wrapWith("html").toString(), NotificationType.INFORMATION, viewAction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/drupal/init/DrupalIncludePathsManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoots";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedPaths";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectContentRoots";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/drupal/init/DrupalIncludePathsManager";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addIfExist";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    private static final class IncludePathApplier
    implements Runnable {
        private final Project myProject;
        private final Collection<? extends VirtualFile> myRootsToAdd;
        private final Collection<? extends VirtualFile> myRootsToErase;

        private IncludePathApplier(Project project, Collection<? extends VirtualFile> rootsToAdd, Collection<? extends VirtualFile> rootsToErase) {
            this.myProject = project;
            this.myRootsToAdd = rootsToAdd;
            this.myRootsToErase = rootsToErase;
        }

        @Override
        public void run() {
            PhpIncludePathManager facade = PhpIncludePathManager.getInstance((Project)this.myProject);
            List includePaths = facade.getIncludePath();
            ArrayList<String> newIncludePaths = new ArrayList<String>(includePaths.size() + this.myRootsToAdd.size());
            ArrayList<String> removedPathsReport = new ArrayList<String>(this.myRootsToErase.size());
            ArrayList<String> addedPathsReport = new ArrayList<String>(this.myRootsToErase.size());
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (String string : includePaths) {
                VirtualFile file = fileSystem.findFileByPath(string);
                if (file == null || !this.myRootsToErase.contains(file)) {
                    newIncludePaths.add(string);
                    if (file == null) continue;
                    this.myRootsToAdd.remove(file);
                    continue;
                }
                removedPathsReport.add(string);
            }
            for (VirtualFile virtualFile : this.myRootsToAdd) {
                String path = virtualFile.getPath();
                newIncludePaths.add(path);
                addedPathsReport.add(path);
            }
            facade.setIncludePath(newIncludePaths);
            DrupalIncludePathsManager.reportResult(this.myProject, removedPathsReport, addedPathsReport);
        }
    }
}

