/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.symfony.asset.mapper;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.modules.JSModuleVisitor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.symfony.SymfonyBundle;
import com.intellij.symfony.asset.mapper.SymfonyAssetMapperManager;
import com.intellij.symfony.asset.mapper.SymfonyAssetMapperReferenceContributorKt;
import com.intellij.symfony.asset.mapper.SymfonyImportModuleQuickFix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/symfony/asset/mapper/SymfonyImportMapModuleIsNotInstalledInspection;", "Lcom/intellij/lang/javascript/inspections/JSInspection;", "<init>", "()V", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getQuickFix", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "moduleName", "", "element", "Lcom/intellij/psi/PsiElement;", "isModuleInstalledInImportMap", "", "literalElement", "isModuleInstalledInVendorDir", "intellij.symfony"})
@SourceDebugExtension(value={"SMAP\nSymfonyImportMapModuleIsNotInstalledInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymfonyImportMapModuleIsNotInstalledInspection.kt\ncom/intellij/symfony/asset/mapper/SymfonyImportMapModuleIsNotInstalledInspection\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,160:1\n30#2,2:161\n30#2,2:167\n126#3:163\n153#3,3:164\n*S KotlinDebug\n*F\n+ 1 SymfonyImportMapModuleIsNotInstalledInspection.kt\ncom/intellij/symfony/asset/mapper/SymfonyImportMapModuleIsNotInstalledInspection\n*L\n80#1:161,2\n85#1:167,2\n80#1:163\n80#1:164,3\n*E\n"})
public final class SymfonyImportMapModuleIsNotInstalledInspection
extends JSInspection {
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)new JSModuleVisitor(this, holder){
            final /* synthetic */ SymfonyImportMapModuleIsNotInstalledInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            protected boolean isAvailable(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return SymfonyAssetMapperReferenceContributorKt.isSymfonyAssetMapperUsed(element);
            }

            protected void processImport(PsiElement literalElement, String quotedLiteralValue, PsiReference[] references, JSModuleVisitor.ImportResolver importResolver, JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                Intrinsics.checkNotNullParameter((Object)literalElement, (String)"literalElement");
                Intrinsics.checkNotNullParameter((Object)quotedLiteralValue, (String)"quotedLiteralValue");
                Intrinsics.checkNotNullParameter((Object)references, (String)"references");
                Intrinsics.checkNotNullParameter((Object)importResolver, (String)"importResolver");
                Intrinsics.checkNotNullParameter((Object)pointerBuilder, (String)"pointerBuilder");
                String string = StringUtil.unquoteString((String)quotedLiteralValue);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
                String moduleName = string;
                PsiUpdateModCommandQuickFix psiUpdateModCommandQuickFix = SymfonyImportMapModuleIsNotInstalledInspection.access$getQuickFix(this.this$0, moduleName, literalElement);
                if (psiUpdateModCommandQuickFix == null) {
                    return;
                }
                PsiUpdateModCommandQuickFix quickFix = psiUpdateModCommandQuickFix;
                Object[] objectArray = new Object[]{moduleName};
                String string2 = SymfonyBundle.INSTANCE.message("symfony.asset.mapper.module.is.not.installed", objectArray);
                objectArray = new LocalQuickFix[]{quickFix};
                this.$holder.registerProblem(literalElement, string2, (LocalQuickFix[])objectArray);
            }

            protected void processRequire(JSCallExpression element, JSLiteralExpression argument, JSModuleVisitor.ImportResolver importResolver, JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
                Intrinsics.checkNotNullParameter((Object)importResolver, (String)"importResolver");
                Intrinsics.checkNotNullParameter((Object)pointerBuilder, (String)"pointerBuilder");
                if (!argument.isStringLiteral()) {
                    return;
                }
                String moduleName = argument.getText();
                Intrinsics.checkNotNull((Object)moduleName);
                PsiUpdateModCommandQuickFix psiUpdateModCommandQuickFix = SymfonyImportMapModuleIsNotInstalledInspection.access$getQuickFix(this.this$0, moduleName, (PsiElement)argument);
                if (psiUpdateModCommandQuickFix == null) {
                    return;
                }
                PsiUpdateModCommandQuickFix quickFix = psiUpdateModCommandQuickFix;
                Object[] objectArray = new Object[]{moduleName};
                String string = SymfonyBundle.INSTANCE.message("symfony.asset.mapper.module.is.not.installed", objectArray);
                objectArray = new LocalQuickFix[]{quickFix};
                this.$holder.registerProblem((PsiElement)argument, string, (LocalQuickFix[])objectArray);
            }
        };
    }

    private final PsiUpdateModCommandQuickFix getQuickFix(String moduleName, PsiElement element) {
        if (!this.isModuleInstalledInImportMap(moduleName, element)) {
            Object[] objectArray = new Object[]{moduleName};
            String string = SymfonyBundle.INSTANCE.message("symfony.asset.mapper.run.import.map.require", objectArray);
            objectArray = new String[]{"importmap:require", moduleName};
            return new SymfonyImportModuleQuickFix(moduleName, string, CollectionsKt.mutableListOf((Object[])objectArray), (Function0<Unit>)((Function0)() -> SymfonyImportMapModuleIsNotInstalledInspection.getQuickFix$lambda$0(element)));
        }
        if (!this.isModuleInstalledInVendorDir(moduleName, element)) {
            Object[] objectArray = new String[]{"importmap:install"};
            return new SymfonyImportModuleQuickFix(moduleName, SymfonyBundle.INSTANCE.message("symfony.asset.mapper.run.import.map.install", new Object[0]), CollectionsKt.mutableListOf((Object[])objectArray), (Function0<Unit>)((Function0)() -> SymfonyImportMapModuleIsNotInstalledInspection.getQuickFix$lambda$1(element)));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isModuleInstalledInImportMap(String moduleName, PsiElement literalElement) {
        void $this$mapTo$iv$iv;
        Project project = literalElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Object serviceClass$iv = SymfonyAssetMapperManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Map<String, Map<String, Object>> $this$map$iv = ((SymfonyAssetMapperManager)object).getModules();
        boolean $i$f$map = false;
        serviceClass$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        List modulesNames = (List)destination$iv$iv;
        return modulesNames.contains(moduleName);
    }

    private final boolean isModuleInstalledInVendorDir(String moduleName, PsiElement literalElement) {
        Project project = literalElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<SymfonyAssetMapperManager> serviceClass$iv = SymfonyAssetMapperManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        VirtualFile vendor = ((SymfonyAssetMapperManager)object).getAssetsVendorDir();
        if (vendor == null || !vendor.exists()) {
            return false;
        }
        Project project2 = literalElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return SymfonyAssetMapperReferenceContributorKt.isModuleResolved(project2, moduleName);
    }

    private static final Unit getQuickFix$lambda$0(PsiElement $element) {
        block0: {
            Project project = $element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VirtualFile virtualFile = SymfonyAssetMapperManager.Companion.getInstance(project).getImportMap();
            if (virtualFile == null) break block0;
            virtualFile.refresh(false, true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getQuickFix$lambda$1(PsiElement $element) {
        block0: {
            Project project = $element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VirtualFile virtualFile = SymfonyAssetMapperManager.Companion.getInstance(project).getAssetsDir();
            if (virtualFile == null) break block0;
            virtualFile.refresh(false, true);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ PsiUpdateModCommandQuickFix access$getQuickFix(SymfonyImportMapModuleIsNotInstalledInspection $this, String moduleName, PsiElement element) {
        return $this.getQuickFix(moduleName, element);
    }
}

