/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.actions.PhpNewBaseAction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.roots.PhpNamespaceCompositeProvider;
import com.jetbrains.php.roots.ui.PhpNamespaceComboBox;
import com.jetbrains.php.roots.ui.PhpPsrDirectoryComboBox;
import com.jetbrains.php.templates.PhpCreateFileFromTemplateDataProvider;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpBaseNewClassDialog
extends DialogWrapper
implements PhpCreateFileFromTemplateDataProvider {
    private JPanel myMainPanel;
    private EditorTextField myNameTextField;
    @Nullable
    private PhpNamespaceComboBox myNamespaceCombobox;
    @Nullable
    private EditorTextField myFileNameTextField;
    private PhpPsrDirectoryComboBox myDirectoryCombobox;
    @Nullable
    protected DocumentListener myNameFieldListener;
    @NotNull
    protected final Project myProject;
    @Nullable
    protected final PsiDirectory myDirectory;
    private final Alarm myAlarm;
    private boolean myDisposed;
    public boolean myFileNameTextChangedUnderFocus;
    public boolean myNamespaceTextChangedUnderFocus;
    public boolean myDirectoryTextChangedUnderFocus;

    protected PhpBaseNewClassDialog(@NotNull Project project, @Nullable PsiDirectory directory) {
        if (project == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.myAlarm = new Alarm();
        this.myProject = project;
        this.myDirectory = directory;
        Disposer.register((Disposable)this.getDisposable(), (Disposable)new Disposable(){

            public void dispose() {
                PhpBaseNewClassDialog.this.myAlarm.cancelAllRequests();
                PhpBaseNewClassDialog.this.myDisposed = true;
            }
        });
    }

    protected final void init(@NotNull JPanel mainPanel, @NotNull EditorTextField nameTextField, @Nullable PhpNamespaceComboBox namespaceCombobox, @NotNull JBLabel namespaceCompletionHintLabel, @Nullable EditorTextField fileNameTextField, @NotNull PhpPsrDirectoryComboBox directoryCombobox, @NotNull JBLabel directoryCompletionHintLabel) {
        if (mainPanel == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(1);
        }
        if (nameTextField == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(2);
        }
        if (namespaceCompletionHintLabel == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(3);
        }
        if (directoryCombobox == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(4);
        }
        if (directoryCompletionHintLabel == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(5);
        }
        this.myMainPanel = mainPanel;
        this.myNameTextField = nameTextField;
        this.myNamespaceCombobox = namespaceCombobox;
        if (this.myNamespaceCombobox != null) {
            this.myNamespaceCombobox.setEditable(true);
        }
        this.myFileNameTextField = fileNameTextField;
        this.myDirectoryCombobox = directoryCombobox;
        if (this.myDirectory != null) {
            this.updateNamespacesSuggestions(PhpNamespaceCompositeProvider.INSTANCE.suggestNamespaces(this.myDirectory));
            this.myDirectoryCombobox.init(this.myDirectory.getVirtualFile(), this.getNamespace());
        } else {
            this.myDirectoryCombobox.init(this.myProject.getBaseDir(), "");
        }
        this.myDirectoryCombobox.getComboBox().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PhpBaseNewClassDialog.this.myDirectoryCombobox.getComboBox().setEditable(true);
            }
        });
        directoryCompletionHintLabel.setText(PhpBundle.message("0.completion.shortcut", "path", PhpUiUtil.getShortcutTextByActionName("CodeCompletion")));
        String shortcutText = PhpUiUtil.getShortcutTextByActionName("CodeCompletion");
        namespaceCompletionHintLabel.setText(PhpBundle.message("0.completion.shortcut", "namespace", shortcutText));
        if (this.isFileNameAutoUpdate() && this.myFileNameTextField != null && this.myNamespaceCombobox != null) {
            this.myNameFieldListener = new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    PhpBaseNewClassDialog.this.addUpdateRequest(() -> PhpBaseNewClassDialog.this.myFileNameTextField.setText(PhpBaseNewClassDialog.this.getName()), 10);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/actions/PhpBaseNewClassDialog$3", "documentChanged"));
                }
            };
            this.myNameTextField.getDocument().addDocumentListener(this.myNameFieldListener);
            this.myNamespaceCombobox.getEditorTextField().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    PhpBaseNewClassDialog.this.addUpdateRequest(() -> PhpBaseNewClassDialog.this.myDirectoryCombobox.updateDirectories(PhpBaseNewClassDialog.this.getNamespace()), 10);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/actions/PhpBaseNewClassDialog$4", "documentChanged"));
                }
            });
        }
    }

    protected void initChangeDetectors() {
        Component directoryEditorTextField;
        if (this.myFileNameTextField != null) {
            this.myFileNameTextField.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (!PhpBaseNewClassDialog.this.myFileNameTextField.isFocusOwner()) {
                        return;
                    }
                    PhpBaseNewClassDialog.this.myFileNameTextChangedUnderFocus = true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/actions/PhpBaseNewClassDialog$5", "documentChanged"));
                }
            });
        }
        if (this.myNamespaceCombobox != null) {
            final EditorTextField namespaceEditorTextField = this.myNamespaceCombobox.getEditorTextField();
            namespaceEditorTextField.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    if (!namespaceEditorTextField.isFocusOwner()) {
                        return;
                    }
                    PhpBaseNewClassDialog.this.myNamespaceTextChangedUnderFocus = true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/actions/PhpBaseNewClassDialog$6", "documentChanged"));
                }
            });
        }
        if ((directoryEditorTextField = this.myDirectoryCombobox.getComboBox().getEditor().getEditorComponent()) instanceof JTextField) {
            ((JTextField)directoryEditorTextField).getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                    if (e == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    if (!directoryEditorTextField.isFocusOwner()) {
                        return;
                    }
                    PhpBaseNewClassDialog.this.myDirectoryTextChangedUnderFocus = true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/actions/PhpBaseNewClassDialog$7", "textChanged"));
                }
            });
        }
    }

    protected void updateNamespacesSuggestions(@NotNull List<String> namespaces) {
        if (namespaces == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(6);
        }
        if (this.myNamespaceCombobox == null) {
            return;
        }
        String mainSuggestion = namespaces.isEmpty() ? "" : namespaces.get(0);
        List<String> suggestions = namespaces.size() > 1 ? namespaces.subList(1, namespaces.size()) : null;
        this.myNamespaceCombobox.updateItems(mainSuggestion, suggestions);
    }

    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(7);
        }
        return project;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameTextField;
    }

    @NotNull
    public String getFileName() {
        String string = this.getFileNameText().trim();
        if (string == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(8);
        }
        return string;
    }

    public String getFileNameText() {
        return this.myFileNameTextField != null ? this.myFileNameTextField.getText() : "";
    }

    @NotNull
    protected String getName() {
        String string = this.myNameTextField.getText().trim();
        if (string == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    protected String getNamespace() {
        return this.myNamespaceCombobox != null ? PhpLangUtil.toName(this.myNamespaceCombobox.getSelectedNamespace().trim()) : "";
    }

    @NotNull
    public String getExtension() {
        return "php";
    }

    protected boolean isFileNameAutoUpdate() {
        return true;
    }

    @Override
    @NotNull
    public PsiDirectory getBaseDirectory() {
        PsiDirectory psiDirectory = this.getDirectory();
        if (psiDirectory == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(10);
        }
        return psiDirectory;
    }

    @Override
    @NotNull
    public final String getFilePath() {
        String filename;
        String extension;
        String chosenExtension = this.getExtension();
        String fullFileName = chosenExtension.equals(extension = PhpNameUtil.getExtension(filename = PathUtil.toSystemIndependentName((String)this.getFileName()))) ? filename : PhpNameUtil.getFullFileName(filename, chosenExtension);
        String relativePath = this.myDirectoryCombobox.getRelativePath();
        Object object = StringUtil.isEmpty((String)relativePath) ? fullFileName : relativePath + "/" + StringUtil.trimEnd((String)fullFileName, (String)"/");
        if (object == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(11);
        }
        return object;
    }

    @Nullable
    protected PsiDirectory getDirectory() {
        PsiDirectory psiDirectory;
        VirtualFile directory = this.myDirectoryCombobox.getExistingParent();
        if (directory != null && (psiDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(directory)) != null) {
            return psiDirectory;
        }
        return null;
    }

    @Override
    @NotNull
    public Properties getProperties(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(12);
        }
        Properties properties = FileTemplateManager.getInstance((Project)this.myProject).getDefaultProperties();
        properties.setProperty("NAME", this.getName());
        String namespace = this.getNamespace();
        if (StringUtil.isNotEmpty((String)namespace)) {
            properties.setProperty("NAMESPACE", namespace);
        }
        Properties properties2 = properties;
        if (properties2 == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(13);
        }
        return properties2;
    }

    protected ValidationInfo doValidate() {
        ValidationInfo classValidation = PhpBaseNewClassDialog.validateClass(this.myProject, this.getName(), this.getNamespace(), (JComponent)this.myNameTextField, (JComponent)((Object)this.myNamespaceCombobox));
        if (classValidation != null) {
            return classValidation;
        }
        PsiDirectory directory = this.getDirectory();
        if (directory == null) {
            return new ValidationInfo(PhpBundle.message("validation.value.is.not.specified.or.invalid", "directory"));
        }
        String errorMessage = PhpNewBaseAction.isValidFilePath(this.getFilePath(), directory);
        if (errorMessage != null) {
            return new ValidationInfo(errorMessage, (JComponent)this.myFileNameTextField);
        }
        return null;
    }

    @Nullable
    protected static ValidationInfo validateClass(@NotNull Project project, @NotNull String name, @Nullable String namespace, @Nullable JComponent nameField, @Nullable JComponent namespaceField) {
        if (project == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(14);
        }
        if (name == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(15);
        }
        if (!PhpNameUtil.isValidClassName(name)) {
            return new ValidationInfo(PhpBundle.message("validation.class.not.valid.name", name), nameField);
        }
        if (StringUtil.isNotEmpty((String)namespace) && !PhpNameUtil.isValidNamespaceFullName(namespace, PhpLanguageLevel.current((Project)project))) {
            return new ValidationInfo(PhpBundle.message("validation.namespace.not.valid.name", namespace), namespaceField);
        }
        return null;
    }

    protected void addUpdateRequest(@NotNull Runnable runnable) {
        if (runnable == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(16);
        }
        this.addUpdateRequest(runnable, 100);
    }

    protected void addUpdateRequest(@NotNull Runnable runnable, int delay) {
        if (runnable == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(runnable, delay);
        }, ModalityState.any());
    }

    protected void dispose() {
        if (this.isFileNameAutoUpdate() && this.myNameFieldListener != null) {
            this.myNameTextField.getDocument().removeDocumentListener(this.myNameFieldListener);
        }
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameTextField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceCompletionHintLabel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryCombobox";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryCompletionHintLabel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaces";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/PhpBaseNewClassDialog";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/PhpBaseNewClassDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateNamespacesSuggestions";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "validateClass";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addUpdateRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10, 11, 13 -> new IllegalStateException(string);
        };
    }
}

