/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions.copyPaste;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDocCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        int firstNonWsLineOffset;
        boolean asteriskSelection;
        if (!(file instanceof PhpFile)) {
            String string = text;
            if (string == null) {
                PhpDocCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        int offset = editor.getSelectionModel().getSelectionStart();
        PsiElement element = file.findElementAt(offset);
        boolean insertedBeforeAsterisk = PhpDocCopyPasteProcessor.insertedBeforeAsterisk(element, offset, file);
        PhpDocComment docComment = (PhpDocComment)PsiTreeUtil.getParentOfType((PsiElement)element, PhpDocComment.class, (boolean)false);
        if (docComment == null) {
            String string = text;
            if (string == null) {
                PhpDocCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (editor.getSelectionModel().getSelectionEnd() >= docComment.getTextRange().getEndOffset()) {
            String string = text;
            if (string == null) {
                PhpDocCopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        String selectedText = editor.getSelectionModel().getSelectedText();
        boolean bl = asteriskSelection = selectedText != null && !selectedText.isEmpty() && StreamEx.of((Object[])((String)text).split("\n")).map(s -> StringUtil.trimLeading((String)s)).allMatch(s -> StringUtil.startsWith((CharSequence)s, (CharSequence)"*"));
        if (insertedBeforeAsterisk) {
            text = (String)text + "\n";
        }
        boolean endsWithLineBreak = ((String)text).endsWith("\n");
        text = (String)StreamEx.of((Object[])((String)text).split("\n")).map(l -> StringUtil.trimLeading((String)l)).map(l -> !insertedBeforeAsterisk && !asteriskSelection && StringUtil.startsWith((CharSequence)l, (CharSequence)"*") ? l.substring(1) : l).collect(Collectors.joining("\n"));
        Document document = editor.getDocument();
        int lineStartOffset = DocumentUtil.getLineStartOffset((int)offset, (Document)document);
        CharSequence chars = document.getImmutableCharSequence();
        if (chars.charAt(firstNonWsLineOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStartOffset, (String)" \t")) != '*') {
            Object object = text;
            if (object == null) {
                PhpDocCopyPasteProcessor.$$$reportNull$$$0(3);
            }
            return object;
        }
        String lineStartReplacement = "\n" + String.valueOf(chars.subSequence(lineStartOffset, firstNonWsLineOffset + 1)) + " ";
        text = StringUtil.trimTrailing((String)text, (char)'\n').replace("\n", lineStartReplacement);
        Object object = endsWithLineBreak ? (String)text + "\n" : text;
        if (object == null) {
            PhpDocCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        return object;
    }

    private static boolean insertedBeforeAsterisk(PsiElement element, int offset, PsiFile file) {
        PsiElement next = PhpPsiUtil.getNextSiblingIgnoreWhitespace(element, false);
        Document doc = file.getFileDocument();
        return PhpPsiUtil.isOfType(next, PhpDocTokenTypes.DOC_LEADING_ASTERISK) && doc.getLineNumber(next.getTextOffset()) == doc.getLineNumber(offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/actions/copyPaste/PhpDocCopyPasteProcessor", "preprocessOnPaste"));
    }
}

