/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.arrangement;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.arrangement.PhpArrangementGrouper;
import com.jetbrains.php.arrangement.PhpArrangementInfo;
import com.jetbrains.php.arrangement.PhpElementArrangementEntry;
import com.jetbrains.php.arrangement.PhpElementArrangementEntryBase;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.impl.MethodReferenceImpl;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMethodDependenciesGrouper
extends PhpArrangementGrouper {
    private final MultiMap<PsiElement, PsiElement> myDependencies = MultiMap.createLinked();
    private final Set<PsiElement> myDependenciesRoots = new LinkedHashSet<PsiElement>();
    private final MultiMap<PhpElementArrangementEntryBase, PhpElementArrangementEntryBase> myDependencyEntries = new MultiMap();
    private final List<PhpElementArrangementEntryBase> myDependencyEntryRoots = new ArrayList<PhpElementArrangementEntryBase>();
    private final ArrangementSettingsToken myOrderType;
    private boolean myRebuildDependencies = false;

    PhpMethodDependenciesGrouper(ArrangementSettingsToken orderType) {
        this.myOrderType = orderType;
    }

    public void addGroupingDependencies(@NotNull PhpArrangementInfo info) {
        block4: {
            block3: {
                if (info == null) {
                    PhpMethodDependenciesGrouper.$$$reportNull$$$0(0);
                }
                if (!StdArrangementTokens.Order.DEPTH_FIRST.equals((Object)this.myOrderType)) break block3;
                for (PhpElementArrangementEntryBase root : this.getDependencyRoots(info)) {
                    this.setupDepthFirstDependency(info, root);
                }
                break block4;
            }
            if (!StdArrangementTokens.Order.BREADTH_FIRST.equals((Object)this.myOrderType)) break block4;
            for (PhpElementArrangementEntryBase root : this.getDependencyRoots(info)) {
                this.setupBreadthFirstDependency(info, root);
            }
        }
    }

    public List<PhpElementArrangementEntryBase> getDependencyRoots(@NotNull PhpArrangementInfo info) {
        if (info == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(1);
        }
        if (this.myRebuildDependencies) {
            this.rebuildDependencies(info);
        }
        return this.myDependencyEntryRoots;
    }

    public Collection<PhpElementArrangementEntryBase> getDependencies(@NotNull PhpArrangementInfo info, @NotNull PhpElementArrangementEntryBase entry) {
        if (info == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(2);
        }
        if (entry == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(3);
        }
        if (this.myRebuildDependencies) {
            this.rebuildDependencies(info);
        }
        return this.myDependencyEntries.get((Object)entry);
    }

    private void rebuildDependencies(@NotNull PhpArrangementInfo info) {
        if (info == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(4);
        }
        this.myDependencyEntries.clear();
        this.myDependencyEntryRoots.clear();
        for (Map.Entry element : this.myDependencies.entrySet()) {
            PhpElementArrangementEntryBase rootEntry = info.getEntry((PsiElement)element.getKey());
            if (rootEntry == null) continue;
            List<PhpElementArrangementEntryBase> entries = this.convertElementsToEntries(info, (PsiElement)element.getKey());
            this.myDependencyEntries.put((Object)rootEntry, entries);
            if (!this.myDependenciesRoots.contains(element.getKey())) continue;
            this.myDependencyEntryRoots.add(rootEntry);
        }
        this.myRebuildDependencies = false;
    }

    private List<PhpElementArrangementEntryBase> convertElementsToEntries(@NotNull PhpArrangementInfo info, @NotNull PsiElement root) {
        if (info == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(5);
        }
        if (root == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(6);
        }
        ArrayList<PhpElementArrangementEntryBase> entries = new ArrayList<PhpElementArrangementEntryBase>();
        for (PsiElement element : this.myDependencies.get((Object)root)) {
            PhpElementArrangementEntryBase entry = info.getEntry(element);
            if (entry == null) continue;
            entries.add(entry);
        }
        return entries;
    }

    private PhpElementArrangementEntryBase setupDepthFirstDependency(@NotNull PhpArrangementInfo info, @NotNull PhpElementArrangementEntryBase entry) {
        if (info == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(7);
        }
        if (entry == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(8);
        }
        PhpElementArrangementEntryBase previous = entry;
        for (PhpElementArrangementEntryBase current : this.getDependencies(info, entry)) {
            if (!current.canUpdateDependence(previous) || PhpMethodDependenciesGrouper.hasCircularDependency(current, previous)) continue;
            current.addDependency((ArrangementEntry)previous);
            previous = this.setupDepthFirstDependency(info, current);
        }
        return previous;
    }

    private void setupBreadthFirstDependency(@NotNull PhpArrangementInfo info, @NotNull PhpElementArrangementEntryBase entry) {
        if (info == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(9);
        }
        if (entry == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(10);
        }
        PhpElementArrangementEntryBase previous = entry;
        ArrayDeque<PhpElementArrangementEntryBase> toProcess = new ArrayDeque<PhpElementArrangementEntryBase>();
        toProcess.add(entry);
        while (!toProcess.isEmpty()) {
            PhpElementArrangementEntryBase current = (PhpElementArrangementEntryBase)toProcess.removeFirst();
            for (PhpElementArrangementEntryBase dependency : this.getDependencies(info, current)) {
                if (!dependency.canUpdateDependence(previous) || PhpMethodDependenciesGrouper.hasCircularDependency(dependency, previous)) continue;
                dependency.addDependency((ArrangementEntry)previous);
                toProcess.addLast(dependency);
                previous = dependency;
            }
        }
    }

    private static boolean hasCircularDependency(@NotNull PhpElementArrangementEntryBase current, @Nullable PhpElementArrangementEntryBase previous) {
        List dependencies;
        if (current == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(11);
        }
        List list = dependencies = previous == null ? null : previous.getDependencies();
        if (dependencies != null) {
            for (ArrangementEntry entry : dependencies) {
                if (entry != current && !PhpMethodDependenciesGrouper.hasCircularDependency(current, (PhpElementArrangementEntryBase)((PhpElementArrangementEntry)entry))) continue;
                return true;
            }
        }
        return false;
    }

    public void registerMethod(@NotNull Method method, @NotNull PhpElementArrangementEntryBase entry) {
        if (method == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(12);
        }
        if (entry == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(13);
        }
        this.processMethodDependencies(method);
    }

    public void registerField(@NotNull Field field, @NotNull PhpElementArrangementEntryBase entry) {
        if (field == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(14);
        }
        if (entry == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(15);
        }
    }

    private void processMethodDependencies(final @NotNull Method method) {
        String fqn;
        if (method == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(16);
        }
        final Project project = method.getProject();
        final PhpClass clazz = method.getContainingClass();
        String string = fqn = clazz == null ? null : clazz.getFQN();
        if (fqn != null) {
            final LinkedHashSet dependent = new LinkedHashSet();
            method.acceptChildren((PsiElementVisitor)new PhpRecursiveElementVisitor(this){

                public void visitPhpMethodReference(MethodReference reference) {
                    if (!DumbService.isDumb((Project)project)) {
                        Set<PhpNamedElement> elements = ((MethodReferenceImpl)reference).resolveMember(clazz, true);
                        dependent.addAll(ContainerUtil.filter(elements, e -> e instanceof Method && e != method));
                    }
                    super.visitPhpMethodReference(reference);
                }
            });
            this.myRebuildDependencies = true;
            this.myDependencies.putValues((Object)method, dependent);
            if (this.shouldBeDependenceRoot(method)) {
                this.myDependenciesRoots.removeAll(dependent);
                this.myDependenciesRoots.add((PsiElement)method);
            }
        }
    }

    private boolean shouldBeDependenceRoot(@NotNull Method method) {
        if (method == null) {
            PhpMethodDependenciesGrouper.$$$reportNull$$$0(17);
        }
        for (PsiElement dependence : this.myDependencies.values()) {
            if (!dependence.equals((Object)method)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/arrangement/PhpMethodDependenciesGrouper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addGroupingDependencies";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDependencyRoots";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDependencies";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "rebuildDependencies";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "convertElementsToEntries";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setupDepthFirstDependency";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setupBreadthFirstDependency";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "hasCircularDependency";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "registerMethod";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "registerField";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "processMethodDependencies";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldBeDependenceRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

