/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.arrangement;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.arrangement.PhpArrangementGrouper;
import com.jetbrains.php.arrangement.PhpArrangementInfo;
import com.jetbrains.php.arrangement.PhpElementArrangementEntry;
import com.jetbrains.php.arrangement.PhpElementArrangementEntryBase;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class PhpOverriddenMethodGrouper
extends PhpArrangementGrouper {
    private final MultiMap<String, PhpElementArrangementEntryBase> myOverriddenMethods = MultiMap.createLinked();
    private final ArrangementSettingsToken myOrderType;
    public static final String NO_NAME = "No name";

    PhpOverriddenMethodGrouper(ArrangementSettingsToken orderType) {
        this.myOrderType = orderType;
    }

    public void addGroupingDependencies(@NotNull PhpArrangementInfo info) {
        if (info == null) {
            PhpOverriddenMethodGrouper.$$$reportNull$$$0(0);
        }
        for (Map.Entry overridden : this.myOverriddenMethods.entrySet()) {
            PhpElementArrangementEntryBase previous = null;
            ArrayList<PhpElementArrangementEntryBase> values = new ArrayList<PhpElementArrangementEntryBase>((Collection)overridden.getValue());
            this.sortByType(values);
            for (PhpElementArrangementEntryBase entry : values) {
                if (entry.canUpdateDependence(previous)) {
                    assert (previous != null);
                    entry.addDependency((ArrangementEntry)previous);
                }
                previous = entry;
            }
        }
    }

    public void registerMethod(@NotNull Method method, @NotNull PhpElementArrangementEntryBase entry) {
        if (method == null) {
            PhpOverriddenMethodGrouper.$$$reportNull$$$0(1);
        }
        if (entry == null) {
            PhpOverriddenMethodGrouper.$$$reportNull$$$0(2);
        }
        if (StdArrangementTokens.EntryType.METHOD.equals((Object)entry.getType())) {
            this.processOverriddenMethod(method, entry);
        }
    }

    public void registerField(@NotNull Field field, @NotNull PhpElementArrangementEntryBase entry) {
        if (field == null) {
            PhpOverriddenMethodGrouper.$$$reportNull$$$0(3);
        }
        if (entry == null) {
            PhpOverriddenMethodGrouper.$$$reportNull$$$0(4);
        }
    }

    private void sortByType(@NotNull List<PhpElementArrangementEntryBase> entries) {
        if (entries == null) {
            PhpOverriddenMethodGrouper.$$$reportNull$$$0(5);
        }
        if (StdArrangementTokens.Order.BY_NAME.equals((Object)this.myOrderType)) {
            entries.sort((entry1, entry2) -> {
                String name2;
                String name;
                String string = name = entry1 instanceof PhpElementArrangementEntry ? ((PhpElementArrangementEntry)entry1).getName() : NO_NAME;
                if (name == null) {
                    return -1;
                }
                String string2 = name2 = entry2 instanceof PhpElementArrangementEntry ? ((PhpElementArrangementEntry)entry2).getName() : NO_NAME;
                assert (name2 != null);
                return name.compareTo(name2);
            });
        }
    }

    private void processOverriddenMethod(@NotNull Method method, @NotNull PhpElementArrangementEntryBase entry) {
        if (method == null) {
            PhpOverriddenMethodGrouper.$$$reportNull$$$0(6);
        }
        if (entry == null) {
            PhpOverriddenMethodGrouper.$$$reportNull$$$0(7);
        }
        if (!method.isPhysical()) {
            return;
        }
        Ref supperClassNameRef = new Ref(null);
        PhpClassHierarchyUtils.processSuperMethods((Method)method, (classMember, subClass, baseClass) -> {
            supperClassNameRef.set((Object)baseClass.getFQN());
            return false;
        });
        if (!supperClassNameRef.isNull()) {
            this.myOverriddenMethods.putValue((Object)((String)supperClassNameRef.get()), (Object)entry);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/arrangement/PhpOverriddenMethodGrouper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addGroupingDependencies";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerMethod";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerField";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "sortByType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processOverriddenMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

