/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.caches;

import com.jetbrains.php.caches.CostEncodingMap;
import com.jetbrains.php.caches.CostSamplingMap;
import com.jetbrains.php.caches.KeyEncoder;
import com.jetbrains.php.caches.SoftValuesMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00028\u00000\u0012\u00a2\u0006\u0002\u0010\u0013J%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00000\nH\u0002J\u0015\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u001dJ#\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0006J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020 H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/php/caches/CostAdaptiveCache;", "T", "", "maxCapacity", "", "softReferences", "", "<init>", "(IZ)V", "map", "Lcom/jetbrains/php/caches/CostSamplingMap;", "", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getOrCompute", "key", "", "generator", "Lkotlin/Function1;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "update", "", "value", "cost", "", "(Ljava/lang/String;Ljava/lang/Object;B)V", "selectRemovalCandidate", "createMap", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "insert", "duration", "", "(Ljava/lang/String;Ljava/lang/Object;J)V", "clear", "doShrink", "log2", "x", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nCostAdaptiveCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CostAdaptiveCache.kt\ncom/jetbrains/php/caches/CostAdaptiveCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class CostAdaptiveCache<T> {
    private int maxCapacity;
    private final boolean softReferences;
    @NotNull
    private CostSamplingMap<byte[], T> map;
    @NotNull
    private final ReentrantReadWriteLock lock;

    @JvmOverloads
    public CostAdaptiveCache(int maxCapacity, boolean softReferences) {
        this.maxCapacity = maxCapacity;
        this.softReferences = softReferences;
        this.map = this.createMap();
        this.lock = new ReentrantReadWriteLock();
    }

    public /* synthetic */ CostAdaptiveCache(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getOrCompute(@NotNull String key, @NotNull Function1<? super String, ? extends T> generator) {
        Object v;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(generator, (String)"generator");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Object v2 = this.map.get(KeyEncoder.Companion.getINSTANCE().encode(key, (byte)0));
            v = v2;
        }
        finally {
            readLock.unlock();
        }
        Object object = v;
        if (v == null) {
            Object object2;
            long start = System.nanoTime();
            boolean bl = false;
            Object value = object2 = generator.invoke((Object)key);
            boolean bl2 = false;
            byte cost = this.log2(System.nanoTime() - start);
            this.update(key, value, cost);
            object = object2;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void update(String key, T value, byte cost) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            byte[] removalCandidate;
            boolean bl = false;
            if (removalCandidate != null) {
                byte[] byArray = removalCandidate = this.selectRemovalCandidate(cost);
                CostSamplingMap<byte[], T> costSamplingMap = this.map;
                byte[] p0 = byArray;
                boolean bl2 = false;
                costSamplingMap.remove(p0);
            }
            T t = this.map.put(KeyEncoder.Companion.getINSTANCE().encode(key, cost), value);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private final byte[] selectRemovalCandidate(byte cost) {
        if (this.map.size() >= this.maxCapacity) {
            byte threshold = Random.Default.nextInt(200) == 0 ? (byte)64 : (byte)cost;
            return (byte[])CostSamplingMap.randomKeyBelowCost$default(this.map, threshold, 0, 2, null);
        }
        return null;
    }

    private final CostSamplingMap<byte[], T> createMap() {
        return this.softReferences ? (CostSamplingMap)new SoftValuesMap(new CostEncodingMap()) : (CostSamplingMap)new CostEncodingMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final T get(@NotNull String key) {
        Object v;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            v = this.map.get(KeyEncoder.Companion.getINSTANCE().encode(key, (byte)0));
        }
        finally {
            readLock.unlock();
        }
        return (T)v;
    }

    public final void insert(@NotNull String key, T value, long duration) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.update(key, value, this.log2(duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear(boolean doShrink) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (!((Map)this.map).isEmpty()) {
                this.map = this.createMap();
                if (doShrink) {
                    this.maxCapacity = Math.max(512, (int)(0.975 * (double)this.maxCapacity));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private final byte log2(long x) {
        return (byte)(63 - Long.numberOfLeadingZeros(x));
    }

    @JvmOverloads
    public CostAdaptiveCache(int maxCapacity) {
        this(maxCapacity, false, 2, null);
    }
}

