/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.dataFlow.type;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.dataFlow.PhpConditionDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.FieldReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTypeConditionDFAnalyzer<E>
extends PhpConditionDFAnalyzer<E> {
    private static final Map<String, PhpTypeContract> myPrimitiveTypeCheckerFunctions = CollectionFactory.createCaseInsensitiveStringMap();
    private static final PhpTypeContract FIRST_PARAMETER_STRING_CONTRACT = new PhpTypeContract(PhpType.STRING, 0, false);
    private static final PhpTypeContract SECOND_PARAMETER_STRING_CONTRACT = new PhpTypeContract(PhpType.STRING, 1, false);
    private static final PhpTypeContract CALLABLE_TYPE_CONTRACT = new PhpTypeContract(PhpType.CALLABLE);
    private static final PhpTypeContract RESOURCE_TYPE_CONTRACT = new PhpTypeContract(PhpType.RESOURCE);
    protected boolean myCompleteTypeComputed;

    public boolean completeTypeComputed() {
        return this.myCompleteTypeComputed;
    }

    @NotNull
    protected static PhpType add(PhpType type, @Nullable PsiElement other, boolean filterPrimitives) {
        if (other instanceof PhpTypedElement) {
            PhpType otherType = ((PhpTypedElement)other).getType();
            type.add(filterPrimitives ? otherType.filterPrimitives() : otherType);
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(0);
        }
        return phpType;
    }

    @Override
    @NotNull
    public E performDFA(@Nullable PsiElement condition, boolean result) {
        if (condition instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)condition;
            IElementType type = binaryExpression.getOperationType();
            if (type == PhpTokenTypes.kwINSTANCEOF) {
                E eval = this.inferTypeFromIdentityCheck(binaryExpression, result);
                if (eval != null) {
                    E e = eval;
                    if (e == null) {
                        PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(1);
                    }
                    return e;
                }
            } else {
                if (PhpTokenTypes.tsAND_OPS.contains(type)) {
                    E left = this.performDFA(binaryExpression.getLeftOperand(), result);
                    E right = this.performDFA(binaryExpression.getRightOperand(), result);
                    E e = this.and(left, right, result);
                    if (e == null) {
                        PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(2);
                    }
                    return e;
                }
                if (PhpTokenTypes.tsOR_OPS.contains(type)) {
                    E left = this.performDFA(binaryExpression.getLeftOperand(), result);
                    E right = this.performDFA(binaryExpression.getRightOperand(), result);
                    E e = this.or(left, right, result);
                    if (e == null) {
                        PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(3);
                    }
                    return e;
                }
            }
        } else if (!(condition instanceof MethodReference) && condition instanceof FunctionReference) {
            E eval;
            PsiElement parameter;
            PhpTypeContract typeContract;
            FunctionReference functionReference = (FunctionReference)condition;
            if (result && (typeContract = this.getTypeFromTypeCheckerFunction(functionReference)) != null && (parameter = functionReference.getParameter(typeContract.myParameterIndex)) != null && (eval = this.tryEvaluate(parameter, typeContract.myType)) != null) {
                this.myCompleteTypeComputed = typeContract.myTotalTypeComputed;
                E e = eval;
                if (e == null) {
                    PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(4);
                }
                return e;
            }
        }
        Object e = super.performDFA(condition, result);
        if (e == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(5);
        }
        return e;
    }

    @Override
    @Nullable
    protected E computeStateFromConditionalGuard(PsiElement left, PsiElement right, IElementType type, boolean result) {
        E evalFromIdentityCheck;
        boolean isIdenticalCheck;
        boolean bl = isIdenticalCheck = type == PhpTokenTypes.opIDENTICAL;
        if ((isIdenticalCheck || type == PhpTokenTypes.opNOT_IDENTICAL) && (evalFromIdentityCheck = this.inferTypeFromIdentityCheck(left, right, isIdenticalCheck == result, false)) != null) {
            return evalFromIdentityCheck;
        }
        return super.computeStateFromConditionalGuard(left, right, type, result);
    }

    @Nullable
    public static PsiElement getGetClassTarget(PsiElement element) {
        if (element instanceof FunctionReference && PhpLangUtil.equalsFunctionNames(((FunctionReference)element).getName(), "get_class")) {
            return ((FunctionReference)element).getParameter(0);
        }
        if (element instanceof FieldReference && FieldReferenceImpl.isClassNameLiteral((MemberReference)((FieldReference)element))) {
            return ((FieldReference)element).getClassReference();
        }
        return null;
    }

    @Nullable
    private E inferTypeFromIdentityCheck(BinaryExpression binaryExpression, boolean result) {
        return this.inferTypeFromIdentityCheck(binaryExpression.getLeftOperand(), binaryExpression.getRightOperand(), result, true);
    }

    @Nullable
    private E inferTypeFromIdentityCheck(PsiElement left, PsiElement right, boolean result, boolean filterPrimitives) {
        if (result && right instanceof PhpTypedElement) {
            if (PhpLangUtil.isNull(right)) {
                return null;
            }
            E eval = this.tryEvaluate(left, right, filterPrimitives);
            if (eval != null) {
                return eval;
            }
        }
        return null;
    }

    protected void updateComputedTypeIfPrimitive(PhpType phpType) {
        if (phpType.filterNull().isNotExtendablePrimitiveType()) {
            this.myCompleteTypeComputed = true;
        }
    }

    @Nullable
    protected PhpTypeContract getTypeFromTypeCheckerFunction(@NotNull FunctionReference functionReference) {
        PsiElement arrParameter;
        String className;
        String name;
        if (functionReference == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)(name = functionReference.getName()))) {
            return null;
        }
        if ((name.equalsIgnoreCase("is_subclass_of") || name.equalsIgnoreCase("is_a")) && (className = PhpTypeConditionDFAnalyzer.inferClassName(functionReference.getParameter(1))) != null) {
            return new PhpTypeContract(new PhpType().add(className));
        }
        if (PhpTypeConditionDFAnalyzer.isStrictInArrayCall(functionReference) && (arrParameter = functionReference.getParameter(1)) instanceof PhpTypedElement) {
            return new PhpTypeContract(((PhpTypedElement)arrParameter).getType().elementType());
        }
        PhpTypeContract typeFromCheckersByContract = PhpTypeConditionDFAnalyzer.getTypeFromContractBasedTypeCheckers(functionReference);
        if (typeFromCheckersByContract != null) {
            return typeFromCheckersByContract;
        }
        return this.getTypeFromPrimitiveTypeCheckers(name);
    }

    @Nullable
    protected PhpTypeContract getTypeFromPrimitiveTypeCheckers(String name) {
        if ("is_callable".equals(name)) {
            return CALLABLE_TYPE_CONTRACT;
        }
        if ("is_resource".equals(name)) {
            return RESOURCE_TYPE_CONTRACT;
        }
        return PhpTypeConditionDFAnalyzer.getTypeFromPrimitiveTypeChecker(name);
    }

    @Nullable
    public static PhpTypeContract getTypeFromPrimitiveTypeChecker(@NotNull String name) {
        if (name == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(7);
        }
        PhpTypeContract contract = myPrimitiveTypeCheckerFunctions.get(name);
        if (PhpLangUtil.equalsFunctionNames(name, "is_numeric")) {
            return new PhpTypeContract(PhpType.or((PhpType)contract.myType, (PhpType)PhpType.STRING));
        }
        return contract;
    }

    @NotNull
    public static Collection<String> getPrimitiveTypeCheckerTypeFromName(@NotNull PhpType phpType) {
        if (phpType == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(8);
        }
        Collection collection = myPrimitiveTypeCheckerFunctions.entrySet().stream().filter(e -> PhpType.intersects((PhpType)((PhpTypeContract)e.getValue()).myType, (PhpType)phpType) || ((PhpTypeContract)e.getValue()).myType.isBoolean() && phpType.isBoolean()).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (collection == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(9);
        }
        return collection;
    }

    private static PhpTypeContract getTypeFromContractBasedTypeCheckers(FunctionReference reference) {
        String name = reference.getName();
        if (PhpLangUtil.equalsFunctionNames(name, "function_exists") || PhpLangUtil.equalsFunctionNames(name, "class_exists") || PhpLangUtil.equalsFunctionNames(name, "interface_exists") || PhpLangUtil.equalsFunctionNames(name, "defined")) {
            return FIRST_PARAMETER_STRING_CONTRACT;
        }
        if (PhpLangUtil.equalsFunctionNames(name, "method_exists") || PhpLangUtil.equalsFunctionNames(name, "property_exists")) {
            return SECOND_PARAMETER_STRING_CONTRACT;
        }
        return null;
    }

    private static boolean isStrictInArrayCall(@NotNull FunctionReference functionReference) {
        if (functionReference == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(10);
        }
        if (StringUtil.equals((CharSequence)functionReference.getName(), (CharSequence)"in_array")) {
            return PhpLangUtil.isTrue(functionReference.getParameter(2));
        }
        return false;
    }

    @Nullable
    public static String inferClassName(PsiElement parameter) {
        String referenceName;
        PhpExpression classReference;
        if (parameter instanceof StringLiteralExpression) {
            return PhpTypeConditionDFAnalyzer.getClassFqnFromContent((StringLiteralExpression)parameter);
        }
        if (parameter instanceof ClassConstantReference && (classReference = ((ClassConstantReference)parameter).getClassReference()) instanceof ClassReference && (referenceName = ((ClassConstantReference)parameter).getName()) != null && referenceName.equals("class")) {
            return ((ClassReference)classReference).getFQN();
        }
        return null;
    }

    @NotNull
    public static String getClassFqnFromContent(@NotNull StringLiteralExpression string) {
        if (string == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(11);
        }
        String contentForFQN = !string.isSingleQuote() ? StringUtil.unescapeBackSlashes((String)string.getContents()) : string.getContents();
        String string2 = PhpLangUtil.toFQN(contentForFQN);
        if (string2 == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @Nullable
    public abstract E tryEvaluate(@Nullable PsiElement var1, @NotNull PsiElement var2, boolean var3);

    @Nullable
    public abstract E tryEvaluate(@Nullable PsiElement var1, @NotNull PhpType var2);

    static {
        myPrimitiveTypeCheckerFunctions.put("is_bool", new PhpTypeContract(PhpType.BOOLEAN));
        myPrimitiveTypeCheckerFunctions.put("is_double", new PhpTypeContract(PhpType.FLOAT));
        myPrimitiveTypeCheckerFunctions.put("is_float", new PhpTypeContract(PhpType.FLOAT));
        myPrimitiveTypeCheckerFunctions.put("is_int", new PhpTypeContract(PhpType.INT));
        myPrimitiveTypeCheckerFunctions.put("is_integer", new PhpTypeContract(PhpType.INT));
        myPrimitiveTypeCheckerFunctions.put("is_long", new PhpTypeContract(PhpType.INT));
        myPrimitiveTypeCheckerFunctions.put("is_numeric", new PhpTypeContract(PhpType.FLOAT_INT));
        myPrimitiveTypeCheckerFunctions.put("is_real", new PhpTypeContract(PhpType.FLOAT));
        myPrimitiveTypeCheckerFunctions.put("is_scalar", new PhpTypeContract(PhpType.SCALAR));
        myPrimitiveTypeCheckerFunctions.put("is_string", new PhpTypeContract(PhpType.STRING));
        myPrimitiveTypeCheckerFunctions.put("is_array", new PhpTypeContract(PhpType.ARRAY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 7, 8, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/dataFlow/type/PhpTypeConditionDFAnalyzer";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "performDFA";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/dataFlow/type/PhpTypeConditionDFAnalyzer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveTypeCheckerTypeFromName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFqnFromContent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTypeCheckerFunction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromPrimitiveTypeChecker";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveTypeCheckerTypeFromName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isStrictInArrayCall";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getClassFqnFromContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 7, 8, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    public static final class PhpTypeContract {
        @NotNull
        private final PhpType myType;
        private final int myParameterIndex;
        private final boolean myTotalTypeComputed;

        private PhpTypeContract(@NotNull PhpType type, int index, boolean totalTypeComputed) {
            if (type == null) {
                PhpTypeContract.$$$reportNull$$$0(0);
            }
            this.myType = type;
            this.myParameterIndex = index;
            this.myTotalTypeComputed = totalTypeComputed;
        }

        PhpTypeContract(@NotNull PhpType type) {
            if (type == null) {
                PhpTypeContract.$$$reportNull$$$0(1);
            }
            this(type, 0, PhpTypeContract.mightBePrimitive(type));
        }

        private static boolean mightBePrimitive(@NotNull PhpType type) {
            if (type == null) {
                PhpTypeContract.$$$reportNull$$$0(2);
            }
            return ContainerUtil.and((Iterable)type.filterNull().getTypes(), ts -> PhpType.isNotExtendablePrimitiveType((String)ts) || PhpType.isResourceOrNumberType((String)ts));
        }

        public boolean intersects(PhpTypeContract contract) {
            return PhpType.intersects((PhpType)this.myType, (PhpType)contract.myType);
        }

        public PhpType getType() {
            return this.myType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "type";
            objectArray2[1] = "com/jetbrains/php/codeInsight/dataFlow/type/PhpTypeConditionDFAnalyzer$PhpTypeContract";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mightBePrimitive";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

