/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.lang.PhpCallbackFunctionUtil;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpUnitDataProviderAttributeReferenceContributor;
import com.jetbrains.php.lang.inspections.PhpUndefinedCallbackInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PhpClassAndMethodNamesInStringLiteralCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PhpClassAndMethodNamesInStringLiteralCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpClassAndMethodNamesInStringLiteralCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PhpClassAndMethodNamesInStringLiteralCompletionProvider.$$$reportNull$$$0(2);
        }
        PsiElement position = parameters.getPosition();
        if (PhpClassAndMethodNamesInStringLiteralCompletionProvider.addCompletionForArrayMemberReference(parameters, result)) {
            return;
        }
        PsiReference reference = position.getContainingFile().findReferenceAt(parameters.getOffset());
        if (reference instanceof PhpCallbackReferenceBase.PhpClassMemberCallbackReference || reference instanceof PhpUnitDataProviderAttributeReferenceContributor.PhpDataProviderReferenceProvider.PhpUnitAttributeClassReference) {
            Collection<PhpClass> classes = ((PhpCallbackReferenceBase.PhpClassMemberCallbackReferenceBase)reference).resolveClassReference();
            if (((PhpCallbackReferenceBase.PhpClassMemberCallbackReferenceBase)reference).isMethod()) {
                for (PhpClass phpClass : classes) {
                    PhpClassAndMethodNamesInStringLiteralCompletionProvider.addMethodsLookupElements(position.getProject(), phpClass.getFQN(), false, result);
                }
                PhpClassAndMethodNamesInStringLiteralCompletionProvider.addObjectMethods(position, false, result);
            } else {
                for (PhpClass aClass : classes) {
                    for (Field field : aClass.getFields()) {
                        if (!field.getModifier().isStatic() || field.isConstant()) continue;
                        result.addElement((LookupElement)PhpClassAndMethodNamesInStringLiteralCompletionProvider.createLookupElementWithoutHandler((PhpClassMember)field));
                    }
                }
            }
        }
    }

    private static void addObjectMethods(PsiElement position, boolean staticContext, @NotNull CompletionResultSet result) {
        if (result == null) {
            PhpClassAndMethodNamesInStringLiteralCompletionProvider.$$$reportNull$$$0(3);
        }
        PhpClassAndMethodNamesInStringLiteralCompletionProvider.addMethodsLookupElements(ContainerUtil.createMaybeSingletonList((Object)PhpClassHierarchyUtils.getObject((Project)position.getProject())), staticContext, result);
    }

    private static boolean addCompletionForArrayMemberReference(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        PsiElement position;
        ArrayCreationExpression arrayCreationExpression;
        if (parameters == null) {
            PhpClassAndMethodNamesInStringLiteralCompletionProvider.$$$reportNull$$$0(4);
        }
        if (result == null) {
            PhpClassAndMethodNamesInStringLiteralCompletionProvider.$$$reportNull$$$0(5);
        }
        if ((arrayCreationExpression = PhpPsiUtil.getParentOfClass(position = parameters.getPosition(), false, ArrayCreationExpression.class)) == null || arrayCreationExpression.getHashElements().iterator().hasNext()) {
            return false;
        }
        List values = ContainerUtil.map((Iterable)ArrayCreationExpressionImpl.children(arrayCreationExpression).limit(3), PhpPsiElement::getFirstPsiChild);
        if (values.isEmpty() || values.size() > 2) {
            return false;
        }
        if (!(values.get(0) instanceof PhpReference) && !PhpClassAndMethodNamesInStringLiteralCompletionProvider.isCallableParameter(arrayCreationExpression)) {
            return false;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)values.get(0)), (PsiElement)position, (boolean)true)) {
            PhpCompletionContributor.PhpStringLiteralClassesCompletionProvider.addCompletions(parameters, result);
            return true;
        }
        PhpCallbackFunctionUtil.PhpMemberCallbackInfoHolder callback = (PhpCallbackFunctionUtil.PhpMemberCallbackInfoHolder)ObjectUtils.tryCast((Object)PhpCallbackFunctionUtil.createCallback((PsiElement)arrayCreationExpression), PhpCallbackFunctionUtil.PhpMemberCallbackInfoHolder.class);
        PsiElement element = callback != null ? callback.getClassElement() : null;
        String classFqn = element != null ? PhpUndefinedCallbackInspection.checkClassReference(element) : null;
        boolean staticContext = element instanceof StringLiteralExpression;
        PhpClassAndMethodNamesInStringLiteralCompletionProvider.addObjectMethods(position, staticContext, result);
        if (classFqn != null) {
            PhpClassAndMethodNamesInStringLiteralCompletionProvider.addMethodsLookupElements(position.getProject(), PhpLangUtil.toFQN(classFqn), staticContext, result);
            return true;
        }
        return false;
    }

    private static boolean isCallableParameter(ArrayCreationExpression arrayCreationExpression) {
        Parameter parameter = PhpWorkaroundUtil.getFunctionParameter((PsiElement)arrayCreationExpression);
        return parameter != null && PhpUndefinedCallbackInspection.isCallableParameter(parameter, (PsiElement)arrayCreationExpression, false);
    }

    private static void addMethodsLookupElements(Project project, String classFqn, boolean staticContext, @NotNull CompletionResultSet result) {
        if (result == null) {
            PhpClassAndMethodNamesInStringLiteralCompletionProvider.$$$reportNull$$$0(6);
        }
        PhpClassAndMethodNamesInStringLiteralCompletionProvider.addMethodsLookupElements(PhpIndex.getInstance((Project)project).getClassesByFQN(classFqn), staticContext, result);
    }

    private static void addMethodsLookupElements(Collection<PhpClass> classes, boolean staticContext, @NotNull CompletionResultSet result) {
        if (result == null) {
            PhpClassAndMethodNamesInStringLiteralCompletionProvider.$$$reportNull$$$0(7);
        }
        ((StreamEx)StreamEx.of(classes).flatMap(e -> e.getMethods().stream()).filter(e -> e.isStatic() || !staticContext)).map(PhpClassAndMethodNamesInStringLiteralCompletionProvider::createLookupElementWithoutHandler).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
    }

    @NotNull
    public static PhpLookupElement createLookupElementWithoutHandler(PhpClassMember method) {
        PhpLookupElement element = new PhpLookupElement((PhpNamedElement)method);
        element.handler = null;
        PhpLookupElement phpLookupElement = element;
        if (phpLookupElement == null) {
            PhpClassAndMethodNamesInStringLiteralCompletionProvider.$$$reportNull$$$0(8);
        }
        return phpLookupElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpClassAndMethodNamesInStringLiteralCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpClassAndMethodNamesInStringLiteralCompletionProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElementWithoutHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addObjectMethods";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionForArrayMemberReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addMethodsLookupElements";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

