/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.ComposerAbstractAction;
import com.jetbrains.php.composer.actions.ComposerActionCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerOptionsManager;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerSelfUpdateAction
extends AnAction
implements DumbAware {
    @NonNls
    public static final String ID = "ComposerSelfUpdateAction";

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ComposerSelfUpdateAction.$$$reportNull$$$0(0);
        }
        boolean enabled = ComposerAbstractAction.getValidProject(e.getDataContext()) != null;
        e.getPresentation().setEnabled(enabled);
        if (e.isFromContextMenu()) {
            e.getPresentation().setVisible(enabled);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ComposerSelfUpdateAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext context;
        Project project;
        if (e == null) {
            ComposerSelfUpdateAction.$$$reportNull$$$0(2);
        }
        if ((project = ComposerAbstractAction.getValidProject(context = e.getDataContext())) != null) {
            ComposerDataService service = ComposerDataService.getInstance(project);
            if (!service.askForValidConfigurationIfNeeded()) {
                return;
            }
            ComposerCommandExecutor commandExecutor = ComposerSelfUpdateAction.createExecutor(project, ComposerDataService.getInstance(project).getComposerExecution(), ComposerOptionsManager.getInstallCommandLineOptions(project), e.getPlace());
            commandExecutor.execute();
        }
    }

    @NotNull
    protected static ComposerCommandExecutor createExecutor(@NotNull Project project, @NotNull ComposerExecution execution, @Nullable String commandLineOptions, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerSelfUpdateAction.$$$reportNull$$$0(3);
        }
        if (execution == null) {
            ComposerSelfUpdateAction.$$$reportNull$$$0(4);
        }
        if (placeForStatistics == null) {
            ComposerSelfUpdateAction.$$$reportNull$$$0(5);
        }
        ComposerActionStatistics actionStatistics = ComposerActionStatistics.create(ComposerActionStatistics.Action.SELF_UPDATE, placeForStatistics);
        return new ComposerActionCommandExecutor(project, project.getBasePath(), execution, commandLineOptions, actionStatistics, true, false){

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = Collections.singletonList("self-update");
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                return ComposerSelfUpdateAction.createExecutorGenerator(this.myExecution, this.myCommandLineOptions);
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage("Composer successfully updated itself.");
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createFailureSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage("Composer failed to update itself.");
            }

            @Override
            @Nls
            protected String getProgressTitle() {
                return PhpBundle.message("framework.composer.self.update.task.title", new Object[0]);
            }

            @Override
            @NlsSafe
            protected String getActionName() {
                return PhpBundle.message("framework.composer.self.update.action.name", new Object[0]);
            }

            @Override
            @Nls(capitalization=Nls.Capitalization.Title)
            @NotNull
            protected String getTaskTitle() {
                String string = PhpBundle.message("composer.update.composer.task.title", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/composer/actions/ComposerSelfUpdateAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTaskTitle";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    private static ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> createExecutorGenerator(@NotNull ComposerExecution execution, String commandLineOptions) {
        if (execution == null) {
            ComposerSelfUpdateAction.$$$reportNull$$$0(6);
        }
        ThrowableNotNullFunction throwableNotNullFunction = generatorProject -> ComposerSelfUpdateAction.createExecutor(generatorProject, execution, commandLineOptions, "ComposerLogRerun");
        if (throwableNotNullFunction == null) {
            ComposerSelfUpdateAction.$$$reportNull$$$0(7);
        }
        return throwableNotNullFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerSelfUpdateAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeForStatistics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerSelfUpdateAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutorGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createExecutor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createExecutorGenerator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7 -> new IllegalStateException(string);
        };
    }
}

