/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.json.cache;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

public class ComposerPackagesCacheStatusProvider {
    private Status myStatus = Status.NOT_DEFINED;

    public static ComposerPackagesCacheStatusProvider getInstance() {
        return (ComposerPackagesCacheStatusProvider)ApplicationManager.getApplication().getService(ComposerPackagesCacheStatusProvider.class);
    }

    public Status getStatus() {
        return this.myStatus;
    }

    public void setStatus(Status status, @Nullable Project project, @Nullable PsiFile psiFile) {
        this.myStatus = status;
        if (project != null && psiFile != null && ((Boolean)ReadAction.compute(() -> psiFile.isValid())).booleanValue()) {
            ReadAction.run(() -> DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile, (Object)this));
        }
    }

    public static enum Status {
        EMPTY,
        PACKAGIST,
        COMPOSER,
        REFRESHING,
        REUSED,
        NOT_DEFINED,
        INVALID_JSON;

    }
}

