/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurableForm;
import com.jetbrains.php.ui.PhpUiUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpProjectConfigurable
implements SearchableConfigurable {
    public static final String ID = "reference.webide.settings.project.settings.php";
    private final Project myProject;
    private PhpProjectConfigurableForm myForm;
    private final Disposable myDisposable;

    public PhpProjectConfigurable(@NotNull Project project) {
        if (project == null) {
            PhpProjectConfigurable.$$$reportNull$$$0(0);
        }
        this.myDisposable = Disposer.newDisposable();
        this.myProject = project;
    }

    @Nls
    public String getDisplayName() {
        return PhpBundle.message("configurable.PhpProjectConfigurable.display.name", new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return ID;
    }

    public JComponent createComponent() {
        if (this.myForm == null) {
            this.myForm = new PhpProjectConfigurableForm(this.myProject, false, this.myDisposable);
        }
        return this.myForm.getComponent();
    }

    public boolean isModified() {
        if (this.myForm != null) {
            return this.myForm.isModified();
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        if (this.myForm != null) {
            this.myForm.apply();
        }
    }

    public void reset() {
        if (this.myForm != null) {
            this.myForm.reset();
        }
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            PhpProjectConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void focusOn(@Nls @NotNull String label) {
        if (label == null) {
            PhpProjectConfigurable.$$$reportNull$$$0(2);
        }
        this.createComponent();
        this.reset();
        this.myForm.openTab(label);
    }

    public void openPhpRuntimeTab(boolean openDefaultStubsPanel) {
        this.openPhpRuntimeTab(openDefaultStubsPanel, null);
    }

    public void openPhpRuntimeTab(boolean openDefaultStubsPanel, @Nullable String extension) {
        this.createComponent();
        this.reset();
        this.myForm.openPhpRuntimeTab(openDefaultStubsPanel, extension);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    @NotNull
    public static Runnable createFix(@NotNull Project project) {
        if (project == null) {
            PhpProjectConfigurable.$$$reportNull$$$0(3);
        }
        Runnable runnable = () -> PhpUiUtil.editConfigurable(project, (Configurable)new PhpProjectConfigurable(project));
        if (runnable == null) {
            PhpProjectConfigurable.$$$reportNull$$$0(4);
        }
        return runnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpProjectConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpProjectConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "focusOn";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

