/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters.herd;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkType;
import com.jetbrains.php.config.interpreters.herd.PhpHerdInterpreterPathKt;
import com.jetbrains.php.config.interpreters.herd.PhpHerdInterpretersManager;
import com.jetbrains.php.ui.PhpNamedCloneableItemsListEditor;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0014J\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/php/config/interpreters/herd/PhpHerdInterpreterPath;", "Lcom/jetbrains/php/config/interpreters/PhpSdkType$PhpInterpreterPath;", "name", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "createPhpInterpreter", "Lcom/jetbrains/php/config/interpreters/PhpInterpreter;", "project", "Lcom/intellij/openapi/project/Project;", "getVersion", "buildDebuggerExtensionPath", "version", "intellij.php.impl"})
public class PhpHerdInterpreterPath
extends PhpSdkType.PhpInterpreterPath {
    public PhpHerdInterpreterPath(@NotNull String name, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(name, file);
    }

    @Override
    @NotNull
    public PhpInterpreter createPhpInterpreter(@Nullable Project project) {
        PhpInterpreter phpInterpreter;
        String version = this.getVersion();
        PhpInterpreter $this$createPhpInterpreter_u24lambda_u240 = phpInterpreter = new PhpInterpreter();
        boolean bl = false;
        $this$createPhpInterpreter_u24lambda_u240.setName(PhpNamedCloneableItemsListEditor.suggestUniqueName("PHP " + PhpHerdInterpreterPathKt.access$toDotSeparatedVersion(version), PhpInterpretersManagerImpl.getInstance(project)::findInterpreter));
        $this$createPhpInterpreter_u24lambda_u240.setHomePath(this.getFile().getPresentableUrl());
        $this$createPhpInterpreter_u24lambda_u240.setDebuggerExtension(this.buildDebuggerExtensionPath(version));
        return phpInterpreter;
    }

    @NotNull
    protected String getVersion() {
        String string;
        if (SystemInfo.isWindows) {
            String string2 = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            string = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)string2, (String)"php", null, (int)2, null), (String)".bat", null, (int)2, null);
        } else {
            String string3 = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            string = StringsKt.substringAfter$default((String)string3, (String)"php", null, (int)2, null);
        }
        return string;
    }

    @NotNull
    public final String buildDebuggerExtensionPath(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return SystemInfo.isWindows ? ((Object)Path.of(PhpHerdInterpretersManager.Companion.getInstance().getHerdXdebugDirectory() + "/xdebug-" + PhpHerdInterpreterPathKt.access$toDotSeparatedVersion(version) + ".dll", new String[0])).toString() : PhpHerdInterpretersManager.Companion.getInstance().getHerdXdebugDirectory() + "/xdebug-" + version + "-" + PhpHerdInterpreterPathKt.access$getArchitecture() + ".so";
    }
}

